/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SilentByteArrayOutputStream
extends OutputStream {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ByteArrayOutputStream outputStream;

    public SilentByteArrayOutputStream() {
        this.outputStream = new ByteArrayOutputStream(32);
    }

    public SilentByteArrayOutputStream(int size) {
        this.outputStream = new ByteArrayOutputStream(size);
    }

    @Override
    public void write(int b) {
        this.outputStream.write(b);
    }

    @Override
    public void write(byte[] b) {
        try {
            this.outputStream.write(b);
        }
        catch (IOException ex) {
            LOGGER.warn("Encountered exception while writing to ByteArrayOutputStream.");
            LOGGER.debug((Object)ex);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.outputStream.write(b, off, len);
    }

    public void writeBytes(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void writeTo(OutputStream out) {
        try {
            this.outputStream.writeTo(out);
        }
        catch (IOException ex) {
            LOGGER.error("Encountered exception while writing to OutputStream.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void reset() {
        this.outputStream.reset();
    }

    public byte[] toByteArray() {
        return this.outputStream.toByteArray();
    }

    public int size() {
        return this.outputStream.size();
    }

    public String toString() {
        return this.outputStream.toString();
    }

    public String toString(String charsetName) {
        try {
            return this.outputStream.toString(charsetName);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.warn("Unsupported encoding: {}", (Object)charsetName);
            LOGGER.debug((Object)ex);
            throw new IllegalArgumentException("Unsupported encoding: " + charsetName, ex);
        }
    }

    public String toString(Charset charset) {
        return this.outputStream.toString(charset);
    }

    @Deprecated
    public String toString(int hibyte) {
        return this.outputStream.toString(hibyte);
    }

    @Override
    public void close() {
    }
}

