/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.constants;

public enum TagClass {
    UNIVERSAL(0, "universal"),
    APPLICATION(1, "application"),
    CONTEXT_SPECIFIC(2, "context-specific"),
    PRIVATE(3, "private");

    private final int intValue;
    private final String stringValue;

    private TagClass(int intValue, String stringValue) {
        this.intValue = intValue;
        this.stringValue = stringValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public static TagClass fromIntValue(int intValue) {
        for (TagClass currentTagClass : TagClass.values()) {
            if (currentTagClass.getIntValue() != intValue) continue;
            return currentTagClass;
        }
        return null;
    }

    public static TagClass fromStringValue(String stringValue) {
        for (TagClass currentTagClass : TagClass.values()) {
            if (!currentTagClass.getStringValue().equalsIgnoreCase(stringValue)) continue;
            return currentTagClass;
        }
        return null;
    }

    public static TagClass fromIdentifierByte(byte identifierByte) {
        return TagClass.fromIntValue(identifierByte >> 6 & 3);
    }
}

