/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.constants;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum TagConstructed {
    PRIMITIVE(0, false),
    CONSTRUCTED(1, true);

    private static final Logger LOGGER;
    private final int intValue;
    private final boolean booleanValue;

    private TagConstructed(int intValue, boolean booleanValue) {
        this.intValue = intValue;
        this.booleanValue = booleanValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public static TagConstructed fromIntValue(int intValue) {
        for (TagConstructed currentTagConstructed : TagConstructed.values()) {
            if (currentTagConstructed.getIntValue() != intValue) continue;
            return currentTagConstructed;
        }
        LOGGER.warn("Could not convert int value to TagConstructed");
        return null;
    }

    public static TagConstructed fromBooleanValue(boolean booleanValue) {
        for (TagConstructed currentTagConstructed : TagConstructed.values()) {
            if (currentTagConstructed.getBooleanValue() != booleanValue) continue;
            return currentTagConstructed;
        }
        return null;
    }

    public static TagConstructed fromIdentifierByte(byte identifierByte) {
        return TagConstructed.fromBooleanValue((identifierByte & 0x20) != 0);
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

