/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.model;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Asn1Choice
implements Asn1Encodable {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean optional;
    private String identifier;
    private List<Asn1Encodable> selecteableEncodables;
    private Asn1Encodable selectedChoice;

    public Asn1Choice(String identifier, Asn1Encodable ... selectableEncodables) {
        this.identifier = identifier;
        this.selecteableEncodables = List.of(selectableEncodables);
    }

    public List<Asn1Encodable> getSelecteableEncodables() {
        return this.selecteableEncodables;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean otpional) {
        this.optional = otpional;
    }

    @Override
    public boolean matchesHeader(TagClass classType, Boolean constructed, Integer tagNumber) {
        for (Asn1Encodable asn1Encodable : this.selecteableEncodables) {
            if (!asn1Encodable.matchesHeader(classType, constructed, tagNumber)) continue;
            return true;
        }
        return false;
    }

    public Asn1Encodable getSelectedChoice() {
        return this.selectedChoice;
    }

    public void makeSelection(TagClass classType, Boolean constructed, Integer tagNumber) {
        for (Asn1Encodable asn1Encodable : this.selecteableEncodables) {
            if (!asn1Encodable.matchesHeader(classType, constructed, tagNumber)) continue;
            this.selectedChoice = asn1Encodable;
            return;
        }
        LOGGER.warn("Could not make selection in {} for tagNumber {} constructed {} classType {}", (Object)this.getIdentifier(), (Object)tagNumber, (Object)constructed, (Object)classType);
        this.selectedChoice = null;
    }

    public void makeSelection(Asn1Encodable asn1Encodable) {
        if (!this.selecteableEncodables.stream().anyMatch(encodable -> encodable.getClass().equals(asn1Encodable.getClass()))) {
            throw new RuntimeException("Could not make selection");
        }
        this.selectedChoice = asn1Encodable;
    }

    @Override
    public ModifiableByteArray getTagOctets() {
        return this.selectedChoice.getTagOctets();
    }

    @Override
    public ModifiableByteArray getLengthOctets() {
        return this.selectedChoice.getLengthOctets();
    }

    @Override
    public ModifiableByteArray getContent() {
        return this.selectedChoice.getContent();
    }
}

