/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.oid;

import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ObjectIdentifier
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private final byte[] encoded;

    private ObjectIdentifier() {
        this.encoded = null;
    }

    public ObjectIdentifier(byte[] bytes) {
        this.encoded = bytes;
    }

    public ObjectIdentifier(String id) {
        String[] splittedId = id.split("\\.");
        long[] idValues = new long[splittedId.length];
        try {
            for (int i = 0; i < splittedId.length; ++i) {
                idValues[i] = Long.parseLong(splittedId[i]);
            }
        }
        catch (RuntimeException E) {
            throw new ParserException("Could not parse OID '" + id + "'", (Throwable)E);
        }
        this.encoded = this.computeEncodedValue(idValues);
    }

    public ObjectIdentifier(long[] idValues) {
        this.encoded = this.computeEncodedValue(idValues);
    }

    private static List<Long> decodeValue(byte[] content) {
        LinkedList<Long> resultList = new LinkedList<Long>();
        if (content.length > 0) {
            resultList.add(Long.valueOf(content[0] / 40));
            resultList.add(Long.valueOf(content[0] % 40));
            int contentPos = 1;
            while (contentPos < content.length) {
                boolean partFinished;
                long oidPart = 0L;
                do {
                    oidPart = oidPart << 7 | (long)(content[contentPos] & 0x7F);
                    boolean bl = partFinished = (content[contentPos] & 0x80) == 0;
                } while (++contentPos < content.length && !partFinished);
                resultList.add(oidPart);
            }
        }
        return resultList;
    }

    private byte[] computeEncodedValue(long[] idValues) {
        try (SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();){
            if (idValues.length == 1) {
                stream.write((int)(idValues[0] * 40L));
            } else if (idValues.length >= 2) {
                stream.write((int)(idValues[0] * 40L + idValues[1]));
                for (int i = 2; i < idValues.length; ++i) {
                    stream.write(this.encodeSingleIdValue(idValues[i]));
                }
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        List<Long> idValues = ObjectIdentifier.decodeValue(this.encoded);
        for (long idValue : idValues) {
            if (!first) {
                builder.append(".");
            } else {
                first = false;
            }
            builder.append(idValue);
        }
        return builder.toString();
    }

    public byte[] getEncoded() {
        return Arrays.copyOf(this.encoded, this.encoded.length);
    }

    private byte[] encodeSingleIdValue(long idValue) {
        try (SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();){
            int moreFlag = 0;
            do {
                stream.write(new byte[]{(byte)((long)moreFlag | idValue & 0x7FL)});
                moreFlag = -128;
            } while ((idValue >>= 7) > 0L);
            byte[] byArray = ObjectIdentifier.reverse(stream.toByteArray());
            return byArray;
        }
    }

    private static byte[] reverse(byte[] array) {
        byte[] newArray = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[array.length - (i + 1)];
        }
        return newArray;
    }
}

