/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.preparator;

import de.rub.nds.asn1.constants.TagConstructed;
import de.rub.nds.asn1.constants.TimeAccurracy;
import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1BmpString;
import de.rub.nds.asn1.model.Asn1Boolean;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1GeneralizedTime;
import de.rub.nds.asn1.model.Asn1Ia5String;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1Null;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1OctetString;
import de.rub.nds.asn1.model.Asn1PrintableString;
import de.rub.nds.asn1.model.Asn1T61String;
import de.rub.nds.asn1.model.Asn1UniversalString;
import de.rub.nds.asn1.model.Asn1UtcTime;
import de.rub.nds.asn1.model.Asn1Utf8String;
import de.rub.nds.asn1.model.Asn1VisibleString;
import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.asn1.time.TimeEncoder;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class Asn1PreparatorHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    private Asn1PreparatorHelper() {
    }

    public static void prepareTagOctets(Asn1Field field) {
        field.setTagOctets(Asn1PreparatorHelper.encodeTag(field));
    }

    public static void prepareTagNumber(Asn1Field field) {
        if (field.getUniversalTagNumberType() != null) {
            field.setTagNumber(field.getUniversalTagNumberType().getIntValue());
        } else {
            field.setTagNumber(0);
        }
    }

    public static void prepareTagConstructed(Asn1Field field) {
        field.setTagConstructed(field.getTagConstructedType() == TagConstructed.CONSTRUCTED);
    }

    public static void prepareTagClass(Asn1Field field) {
        field.setTagClass(field.getTagClassType().getIntValue());
    }

    public static void prepareLengthOctets(Asn1Field field) {
        field.setLengthOctets(Asn1PreparatorHelper.encodeLength(field, (BigInteger)field.getLength().getValue()));
    }

    public static void prepareLength(Asn1Field field) {
        field.setLength(BigInteger.valueOf(((byte[])field.getContent().getValue()).length));
    }

    private static byte[] encodeTag(Asn1Field field) {
        byte firstIdentifierByte = 0;
        firstIdentifierByte = Asn1PreparatorHelper.encodeTagClass(firstIdentifierByte, (Integer)field.getTagClass().getValue());
        firstIdentifierByte = Asn1PreparatorHelper.encodeIsConstructed(firstIdentifierByte, (Boolean)field.getTagConstructed().getValue());
        return Asn1PreparatorHelper.encodeTagNumber(firstIdentifierByte, (Integer)field.getTagNumber().getValue());
    }

    private static byte encodeTagClass(byte firstIdentifierByte, int tagClass) {
        return (byte)(firstIdentifierByte | (tagClass & 3) << 6);
    }

    private static byte encodeIsConstructed(byte firstIdentifierByte, boolean isConstructed) {
        return isConstructed ? (byte)(firstIdentifierByte | 0x20) : firstIdentifierByte;
    }

    private static byte[] encodeTagNumber(byte firstIdentifierByte, int tagNumber) {
        try (SilentByteArrayOutputStream resultStream = new SilentByteArrayOutputStream();){
            byte[] byArray;
            try (SilentByteArrayOutputStream longEncodingStream = new SilentByteArrayOutputStream();){
                if (tagNumber < 0) {
                    LOGGER.warn("Tag number is smaller than zero. Defaulting to zero!");
                    tagNumber = 0;
                }
                if (tagNumber <= 31) {
                    byte[] result = new byte[]{firstIdentifierByte};
                    result[0] = (byte)(result[0] | (byte)(tagNumber & 0x1F));
                    resultStream.write(result);
                } else {
                    int longTagNumberBytes = Asn1PreparatorHelper.getTagNumberByteCount(tagNumber);
                    byte[] longEncoding = Asn1PreparatorHelper.encodeLongTagNumber(tagNumber);
                    if (longEncoding.length < longTagNumberBytes) {
                        longEncodingStream.write(new byte[longTagNumberBytes - longEncoding.length]);
                        longEncodingStream.write(longEncoding);
                    }
                    firstIdentifierByte = (byte)(firstIdentifierByte | 0x1F);
                    resultStream.write(new byte[]{firstIdentifierByte});
                    resultStream.write(longEncoding);
                }
                byArray = resultStream.toByteArray();
            }
            return byArray;
        }
    }

    public static void prepareAfterContent(Asn1Field field) {
        Asn1PreparatorHelper.prepareLength(field);
        Asn1PreparatorHelper.prepareLengthOctets(field);
        Asn1PreparatorHelper.prepareTagClass(field);
        Asn1PreparatorHelper.prepareTagConstructed(field);
        Asn1PreparatorHelper.prepareTagNumber(field);
        Asn1PreparatorHelper.prepareTagOctets(field);
    }

    public static Asn1Boolean prepareField(Asn1Boolean asn1Boolean, boolean value) {
        if (asn1Boolean == null) {
            asn1Boolean = new Asn1Boolean("boolean");
        }
        asn1Boolean.setValue(value);
        asn1Boolean.setContent(Asn1PreparatorHelper.encodeBoolean((Boolean)asn1Boolean.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1Boolean);
        return asn1Boolean;
    }

    public static Asn1Integer prepareField(Asn1Integer asn1Integer, BigInteger value) {
        if (asn1Integer == null) {
            asn1Integer = new Asn1Integer("integer");
        }
        asn1Integer.setValue(value);
        asn1Integer.setContent(Asn1PreparatorHelper.encodeInteger((BigInteger)asn1Integer.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1Integer);
        return asn1Integer;
    }

    public static Asn1Null prepareField(Asn1Null asn1Null) {
        Asn1Null result = asn1Null;
        if (result == null) {
            result = new Asn1Null("null");
        }
        result.setContent(Asn1PreparatorHelper.encodeNull());
        Asn1PreparatorHelper.prepareAfterContent(result);
        return result;
    }

    public static Asn1ObjectIdentifier prepareField(Asn1ObjectIdentifier asn1ObjectIdentifier, ObjectIdentifier oid) {
        if (asn1ObjectIdentifier == null) {
            asn1ObjectIdentifier = new Asn1ObjectIdentifier("objectIdentifier");
        }
        asn1ObjectIdentifier.setValue(oid.toString());
        asn1ObjectIdentifier.setContent(Asn1PreparatorHelper.encodeObjectIdentifier(new ObjectIdentifier((String)asn1ObjectIdentifier.getValue().getValue())));
        Asn1PreparatorHelper.prepareAfterContent(asn1ObjectIdentifier);
        return asn1ObjectIdentifier;
    }

    public static Asn1BitString prepareField(Asn1BitString asn1BitString, byte[] usedBits, byte unusedBits) {
        if (asn1BitString == null) {
            asn1BitString = new Asn1BitString("bitstring");
        }
        asn1BitString.setUsedBits(usedBits);
        asn1BitString.setUnusedBits(unusedBits);
        asn1BitString.setPadding((byte)0);
        asn1BitString.setContent(Asn1PreparatorHelper.encodeBitString((byte[])asn1BitString.getUsedBits().getValue(), (Byte)asn1BitString.getUnusedBits().getValue(), (Byte)asn1BitString.getPadding().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1BitString);
        return asn1BitString;
    }

    public static Asn1GeneralizedTime prepareFieldGeneralizedTime(Asn1GeneralizedTime asn1GeneralizedTime, DateTime time, TimeAccurracy accurracy) {
        if (asn1GeneralizedTime == null) {
            asn1GeneralizedTime = new Asn1GeneralizedTime("generalizedTime");
        }
        asn1GeneralizedTime.setValue(new String(Asn1PreparatorHelper.encodeGeneralizedTime(time, accurracy), StandardCharsets.US_ASCII));
        asn1GeneralizedTime.setContent(((String)asn1GeneralizedTime.getValue().getValue()).getBytes(StandardCharsets.US_ASCII));
        Asn1PreparatorHelper.prepareAfterContent(asn1GeneralizedTime);
        return asn1GeneralizedTime;
    }

    public static Asn1GeneralizedTime prepareFieldGeneralizedTimeUtc(Asn1GeneralizedTime asn1GeneralizedTime, DateTime time, TimeAccurracy accurracy) {
        if (asn1GeneralizedTime == null) {
            asn1GeneralizedTime = new Asn1GeneralizedTime("generalizedTime");
        }
        asn1GeneralizedTime.setValue(new String(Asn1PreparatorHelper.encodeGeneralizedTimeUtc(time, accurracy), StandardCharsets.US_ASCII));
        asn1GeneralizedTime.setContent(((String)asn1GeneralizedTime.getValue().getValue()).getBytes(StandardCharsets.US_ASCII));
        Asn1PreparatorHelper.prepareAfterContent(asn1GeneralizedTime);
        return asn1GeneralizedTime;
    }

    public static Asn1GeneralizedTime prepareFieldGeneralizedTimeUtcDifferential(Asn1GeneralizedTime asn1GeneralizedTime, DateTime time, TimeAccurracy accurracy, int timeZoneOffset) {
        if (asn1GeneralizedTime == null) {
            asn1GeneralizedTime = new Asn1GeneralizedTime("generalizedTime");
        }
        asn1GeneralizedTime.setValue(new String(Asn1PreparatorHelper.encodeGneralizedTimeUtcDifferential(time, accurracy, timeZoneOffset), StandardCharsets.US_ASCII));
        asn1GeneralizedTime.setContent(((String)asn1GeneralizedTime.getValue().getValue()).getBytes(StandardCharsets.US_ASCII));
        Asn1PreparatorHelper.prepareAfterContent(asn1GeneralizedTime);
        return asn1GeneralizedTime;
    }

    public static Asn1GeneralizedTime prepareField(Asn1GeneralizedTime asn1GeneralizedTime, DateTime time, TimeAccurracy accurracy) {
        if (asn1GeneralizedTime == null) {
            asn1GeneralizedTime = new Asn1GeneralizedTime("generalizedTime");
        }
        asn1GeneralizedTime.setValue(new String(Asn1PreparatorHelper.encodeGeneralizedTime(time, accurracy), StandardCharsets.US_ASCII));
        asn1GeneralizedTime.setContent(((String)asn1GeneralizedTime.getValue().getValue()).getBytes(StandardCharsets.US_ASCII));
        Asn1PreparatorHelper.prepareAfterContent(asn1GeneralizedTime);
        return asn1GeneralizedTime;
    }

    public static Asn1UtcTime prepareFieldUtcTime(Asn1UtcTime asn1UtcTime, DateTime time, TimeAccurracy accurracy) {
        if (asn1UtcTime == null) {
            asn1UtcTime = new Asn1UtcTime("utcTime");
        }
        asn1UtcTime.setValue(new String(Asn1PreparatorHelper.encodeFullUtcTime(time, accurracy), StandardCharsets.US_ASCII));
        asn1UtcTime.setContent(((String)asn1UtcTime.getValue().getValue()).getBytes(StandardCharsets.US_ASCII));
        Asn1PreparatorHelper.prepareAfterContent(asn1UtcTime);
        return asn1UtcTime;
    }

    public static Asn1UtcTime prepareFieldUtcTimeDifferential(Asn1UtcTime asn1UtcTime, DateTime time, TimeAccurracy accurracy, int timeZoneOffset) {
        if (asn1UtcTime == null) {
            asn1UtcTime = new Asn1UtcTime("utcTime");
        }
        asn1UtcTime.setValue(new String(Asn1PreparatorHelper.encodeUtcTimeDifferential(time, accurracy, timeZoneOffset), StandardCharsets.US_ASCII));
        asn1UtcTime.setContent(((String)asn1UtcTime.getValue().getValue()).getBytes(StandardCharsets.US_ASCII));
        Asn1PreparatorHelper.prepareAfterContent(asn1UtcTime);
        return asn1UtcTime;
    }

    public static Asn1PrintableString prepareField(Asn1PrintableString asn1PrintableString, String value) {
        if (asn1PrintableString == null) {
            asn1PrintableString = new Asn1PrintableString("printableString");
        }
        asn1PrintableString.setValue(value);
        asn1PrintableString.setContent(Asn1PreparatorHelper.encodePrintableString((String)asn1PrintableString.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1PrintableString);
        return asn1PrintableString;
    }

    public static Asn1BmpString prepareField(Asn1BmpString asn1BmpString, String value) {
        if (asn1BmpString == null) {
            asn1BmpString = new Asn1BmpString("bmpString");
        }
        asn1BmpString.setValue(value);
        asn1BmpString.setContent(Asn1PreparatorHelper.encodeBmpString((String)asn1BmpString.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1BmpString);
        return asn1BmpString;
    }

    public static Asn1UniversalString prepareField(Asn1UniversalString asn1UniversalString, String value) {
        if (asn1UniversalString == null) {
            asn1UniversalString = new Asn1UniversalString("universalString");
        }
        asn1UniversalString.setValue(value);
        asn1UniversalString.setContent(Asn1PreparatorHelper.encodeUniversalString((String)asn1UniversalString.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1UniversalString);
        return asn1UniversalString;
    }

    public static Asn1Ia5String prepareField(Asn1Ia5String asn1Ia5String, String value) {
        if (asn1Ia5String == null) {
            asn1Ia5String = new Asn1Ia5String("ia5String");
        }
        asn1Ia5String.setValue(value);
        asn1Ia5String.setContent(Asn1PreparatorHelper.encodePrintableString((String)asn1Ia5String.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1Ia5String);
        return asn1Ia5String;
    }

    public static Asn1OctetString prepareField(Asn1OctetString asn1OctetString, byte[] value) {
        if (asn1OctetString == null) {
            asn1OctetString = new Asn1OctetString("octetString");
        }
        asn1OctetString.setValue(value);
        asn1OctetString.setContent(Asn1PreparatorHelper.encodeOctetString((byte[])asn1OctetString.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1OctetString);
        return asn1OctetString;
    }

    public static Asn1T61String prepareField(Asn1T61String asn1T61String, String value) {
        if (asn1T61String == null) {
            asn1T61String = new Asn1T61String("t61String");
        }
        asn1T61String.setValue(value);
        asn1T61String.setContent(Asn1PreparatorHelper.encodeT61String((String)asn1T61String.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1T61String);
        return asn1T61String;
    }

    public static Asn1Utf8String prepareField(Asn1Utf8String asn1Utf8String, String value) {
        if (asn1Utf8String == null) {
            asn1Utf8String = new Asn1Utf8String("utf8String");
        }
        asn1Utf8String.setValue(value);
        asn1Utf8String.setContent(Asn1PreparatorHelper.encodeUtf8String((String)asn1Utf8String.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1Utf8String);
        return asn1Utf8String;
    }

    public static Asn1VisibleString prepareField(Asn1VisibleString asn1VisibleString, String value) {
        if (asn1VisibleString == null) {
            asn1VisibleString = new Asn1VisibleString("visibleString");
        }
        asn1VisibleString.setValue(value);
        asn1VisibleString.setContent(Asn1PreparatorHelper.encodeVisibleString((String)asn1VisibleString.getValue().getValue()));
        Asn1PreparatorHelper.prepareAfterContent(asn1VisibleString);
        return asn1VisibleString;
    }

    public static byte[] encodeBoolean(boolean value) {
        if (value) {
            return new byte[]{-1};
        }
        return new byte[1];
    }

    public static byte[] encodeInteger(BigInteger bigInt) {
        return bigInt.toByteArray();
    }

    public static byte[] encodeNull() {
        return new byte[0];
    }

    public static byte[] encodeObjectIdentifier(ObjectIdentifier oid) {
        return oid.getEncoded();
    }

    public static byte[] encodeBitString(byte[] usedBits, Byte unusedBits, Byte padding) {
        try (SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();){
            outputStream.write(new byte[]{unusedBits});
            byte[] encodedContent = Arrays.copyOf(usedBits, usedBits.length);
            encodedContent = Asn1PreparatorHelper.shiftLeft(encodedContent, unusedBits.byteValue());
            if (encodedContent.length > 0) {
                int n = encodedContent.length - 1;
                encodedContent[n] = (byte)(encodedContent[n] & 255 - (1 << unusedBits - 1));
                int n2 = encodedContent.length - 1;
                encodedContent[n2] = (byte)(encodedContent[n2] | padding);
            }
            outputStream.write(encodedContent);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] encodeGeneralizedTime(DateTime date, TimeAccurracy accurracy) {
        return TimeEncoder.encodeGeneralizedTimeLocalTime(date, accurracy).getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] encodeFullUtcTime(DateTime date, TimeAccurracy accurracy) {
        return TimeEncoder.encodeFullUtc(date, accurracy).getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] encodeUtcTimeDifferential(DateTime date, TimeAccurracy accurracy, int timeZoneOffset) {
        return TimeEncoder.encodeUtcWithDifferential(date, accurracy, timeZoneOffset).getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] encodeGeneralizedTimeUtc(DateTime date, TimeAccurracy accurracy) {
        return TimeEncoder.encodeGeneralizedTimeUtc(date, accurracy).getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] encodeGneralizedTimeUtcDifferential(DateTime date, TimeAccurracy accurracy, int timeZoneOffset) {
        return TimeEncoder.encodeGeneralizedTimeUtcWithDifferential(date, accurracy, timeZoneOffset).getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] encodeIa5String(String tempString) {
        return tempString.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] encodePrintableString(String tempString) {
        return tempString.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] encodeBmpString(String tempString) {
        return tempString.getBytes(StandardCharsets.UTF_16BE);
    }

    public static byte[] encodeUniversalString(String tempString) {
        return tempString.getBytes(Charset.forName("UTF-32BE"));
    }

    public static byte[] encodeOctetString(byte[] bytes) {
        return bytes;
    }

    public static byte[] encodeT61String(String tempString) {
        return tempString.getBytes(StandardCharsets.ISO_8859_1);
    }

    public static byte[] encodeUtf8String(String tempString) {
        return tempString.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] encodeVisibleString(String tempString) {
        return tempString.getBytes(StandardCharsets.US_ASCII);
    }

    private static byte[] shiftLeft(byte[] input, int n) {
        if (input.length == 0 || n == 0) {
            return input;
        }
        BigInteger tempBigInt = new BigInteger(1, input);
        tempBigInt = tempBigInt.shiftLeft(n);
        byte[] signedByte = tempBigInt.toByteArray();
        return Arrays.copyOfRange(signedByte, 1, signedByte.length);
    }

    private static byte[] encodeLongTagNumber(int tagNumber) {
        int tagNumberByteCount = Asn1PreparatorHelper.getTagNumberByteCount(tagNumber);
        byte[] result = new byte[tagNumberByteCount];
        int moreFlag = 0;
        for (int i = tagNumberByteCount - 1; i >= 0; --i) {
            result[i] = (byte)(moreFlag | tagNumber & 0x7F);
            tagNumber >>= 7;
            moreFlag = -128;
        }
        return result;
    }

    private static int getTagNumberByteCount(int tagNumber) {
        int result = 0;
        while (tagNumber > 0) {
            ++result;
            tagNumber >>= 7;
        }
        return result;
    }

    private static int getLengthByteCount(BigInteger length) {
        int fullBytes = length.bitLength() / 8;
        if (length.bitLength() % 8 != 0) {
            ++fullBytes;
        }
        return fullBytes;
    }

    private static byte[] encodeLength(Asn1Field field, BigInteger contentLength) {
        field.setLength(contentLength);
        BigInteger length = (BigInteger)field.getLength().getValue();
        if (length.compareTo(BigInteger.ZERO) == -1) {
            LOGGER.warn("Field length is smaller than zero. Defaulting to zero!");
            length = BigInteger.ZERO;
        }
        if (length.compareTo(BigInteger.valueOf(127L)) <= 0) {
            return new byte[]{length.byteValue()};
        }
        return Asn1PreparatorHelper.encodeLongLength(length);
    }

    private static byte[] encodeLongLength(BigInteger length) {
        try (SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();){
            int numberOfBytes = Asn1PreparatorHelper.getLengthByteCount(length);
            outputStream.write(numberOfBytes | 0x80);
            LOGGER.debug("Encoding: {} as {}", (Object)length, (Object)DataConverter.bytesToHexString((byte[])DataConverter.bigIntegerToByteArray((BigInteger)length, (int)numberOfBytes, (boolean)true)));
            outputStream.writeBytes(DataConverter.bigIntegerToByteArray((BigInteger)length, (int)numberOfBytes, (boolean)true));
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

