/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.serializer;

import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Asn1FieldSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Asn1Field field;

    public Asn1FieldSerializer(Asn1Field field) {
        this.field = field;
    }

    public final byte[] serialize() {
        LOGGER.trace("Serializing: {} ", (Object)this.field.getIdentifier());
        try (SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();){
            stream.writeBytes((byte[])this.field.getTagOctets().getValue());
            stream.writeBytes((byte[])this.field.getLengthOctets().getValue());
            stream.write((byte[])this.field.getContent().getValue());
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }
}

