/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.time;

import de.rub.nds.protocol.exception.ParserException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimeDecoder {
    private static final Logger LOGGER = LogManager.getLogger();

    public static DateTime decodeGeneralizedTimeUtc(String generalizedTimeString) {
        String[] formats;
        LOGGER.debug("Decoding GeneralizedTimeUtc: {}", (Object)generalizedTimeString);
        for (String format : formats = new String[]{"yyyyMMddHH", "yyyyMMddHHmm", "yyyyMMddHHmmss", "yyyyMMddHHmmss.SSS", "yyyyMMddHH'Z'", "yyyyMMddHHmm'Z'", "yyyyMMddHHmmss'Z'", "yyyyMMddHHmmss.SSS'Z'", "yyyyMMddHHZ", "yyyyMMddHHmmZ", "yyyyMMddHHmmssZ", "yyyyMMddHHmmss.SSSZ"}) {
            try {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
                DateTime dateTime = formatter.parseDateTime(generalizedTimeString);
                return dateTime;
            }
            catch (IllegalArgumentException E) {
                LOGGER.trace("Format {} failed for input {}", (Object)format, (Object)generalizedTimeString);
            }
        }
        throw new ParserException("Cannot parse time" + generalizedTimeString);
    }

    public static DateTime decodeUtc(String utcTimeString) {
        String[] formats;
        LOGGER.debug("Decoding UTC time: {}", (Object)utcTimeString);
        for (String format : formats = new String[]{"yyMMddHHmm", "yyMMddHHmmss", "yyMMddHHmm'Z'", "yyMMddHHmmss'Z'", "yyMMddHHmmZ'", "yyMMddHHmmssZ'"}) {
            try {
                DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format).withZoneUTC();
                DateTime dateTime = formatter.parseDateTime(utcTimeString);
                return dateTime;
            }
            catch (IllegalArgumentException E) {
                LOGGER.trace("Format {} failed for input {}", (Object)format, (Object)utcTimeString);
            }
        }
        throw new ParserException("Cannot parse time: " + utcTimeString);
    }
}

