/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.tracetool.main;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.GeneralDelegate;
import de.rub.nds.tlsattacker.core.config.delegate.ListDelegate;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceSerializer;
import de.rub.nds.tlsattacker.tracetool.config.TraceToolCommandConfig;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraceTool {
    private static final Logger LOGGER = LogManager.getLogger();
    private String[] args;

    public TraceTool(String ... args) {
        this.args = args;
    }

    public void run() throws ParameterException, ConfigurationException, JAXBException, IOException {
        TraceToolCommandConfig cmdConfig = new TraceToolCommandConfig(new GeneralDelegate());
        JCommander commander = new JCommander((Object)cmdConfig);
        try {
            commander.parse(this.args);
        }
        catch (ParameterException pe) {
            LOGGER.error("Could not parse provided parameters. {}", (Object)pe.getLocalizedMessage());
            LOGGER.info("Try -help");
            throw pe;
        }
        if (cmdConfig.getGeneralDelegate().isHelp()) {
            commander.usage();
            return;
        }
        ListDelegate list = cmdConfig.getDelegate(ListDelegate.class);
        if (list.isSet()) {
            list.plotListing();
            return;
        }
        try {
            Config config = cmdConfig.createConfig();
            State state = new State(config);
            WorkflowTrace filtered = state.getFilteredTraceCopy();
            String xml = WorkflowTraceSerializer.write(filtered);
            System.out.println(xml);
        }
        catch (ConfigurationException ce) {
            LOGGER.error("Encountered a ConfigurationException aborting. {} - See debug messages for more details.", (Object)ce.getLocalizedMessage());
            LOGGER.debug(ce.getLocalizedMessage(), (Throwable)ce);
            throw ce;
        }
        catch (ParameterException pe) {
            LOGGER.error("Could not parse provided parameters. {}", (Object)pe.getLocalizedMessage());
            LOGGER.info("Try -help");
            throw pe;
        }
    }
}

