/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import java.io.IOException;

public abstract class TransportHandler {
    protected long timeout;
    protected boolean initialized = false;
    private final ConnectionEndType connectionEndType;
    protected SocketState cachedSocketState = null;
    protected boolean resetClientSourcePort = true;
    protected boolean useIpv6 = false;

    public TransportHandler(Connection con) {
        this.connectionEndType = con.getLocalConnectionEndType();
        this.timeout = con.getTimeout().intValue();
        this.useIpv6 = con.getUseIpv6();
    }

    public TransportHandler(long timeout, ConnectionEndType type) {
        this.timeout = timeout;
        this.connectionEndType = type;
    }

    public abstract void closeConnection() throws IOException;

    public abstract void closeClientConnection() throws IOException;

    public ConnectionEndType getConnectionEndType() {
        return this.connectionEndType;
    }

    public abstract void preInitialize() throws IOException;

    public abstract void initialize() throws IOException;

    public abstract void sendData(byte[] var1) throws IOException;

    public abstract byte[] fetchData() throws IOException;

    public abstract byte[] fetchData(int var1) throws IOException;

    public boolean isInitialized() {
        return this.initialized;
    }

    public abstract boolean isClosed() throws IOException;

    public long getTimeout() {
        return this.timeout;
    }

    public abstract void setTimeout(long var1);

    public boolean isResetClientSourcePort() {
        return this.resetClientSourcePort;
    }

    public void setResetClientSourcePort(boolean resetClientSourcePort) {
        this.resetClientSourcePort = resetClientSourcePort;
    }

    public boolean isUseIpv6() {
        return this.useIpv6;
    }

    public void setUseIpv6(boolean useIpv6) {
        this.useIpv6 = useIpv6;
    }
}

