/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.recording;

import de.rub.nds.modifiablevariable.util.RandomHelper;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.StreambasedTransportHandler;
import de.rub.nds.tlsattacker.transport.recording.RecordedLine;
import de.rub.nds.tlsattacker.transport.recording.Recording;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayBackTransportHandler
extends StreambasedTransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<RecordedLine> linesToSend;
    private int position = 0;
    private final Recording recording;
    private boolean closed = false;

    PlayBackTransportHandler(Recording recording) {
        super(0L, ConnectionEndType.SERVER);
        this.recording = recording;
        this.linesToSend = recording.getReceivedLines();
    }

    @Override
    public void closeConnection() throws IOException {
        this.closed = true;
    }

    @Override
    public void preInitialize() throws IOException {
    }

    @Override
    public void initialize() throws IOException {
        this.cachedSocketState = null;
        RandomHelper.getRandom().setSeed(this.recording.getSeed());
    }

    @Override
    public void sendData(byte[] data) throws IOException {
        LOGGER.debug("Not sending Data. This is a recording");
    }

    @Override
    public byte[] fetchData() throws IOException {
        if (this.linesToSend.size() <= this.position) {
            LOGGER.warn("Recoding ended");
            return new byte[0];
        }
        RecordedLine data = this.linesToSend.get(this.position);
        ++this.position;
        return data.getRecordedMessage();
    }

    @Override
    public void closeClientConnection() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.closed;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

