/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class TimeoutableInputStream
extends InputStream {
    private InputStream stream;
    private volatile long timeout;

    public TimeoutableInputStream(InputStream stream, long timeout) {
        this.stream = stream;
        this.timeout = timeout;
    }

    @Override
    public int read() throws IOException {
        long start = System.currentTimeMillis();
        while (this.stream.available() <= 0) {
            if (System.currentTimeMillis() > start + this.timeout) {
                throw new SocketTimeoutException();
            }
            try {
                Thread.currentThread();
                Thread.sleep(5L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.stream.read();
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public synchronized void mark(int i) {
        this.stream.mark(i);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.stream.skip(l);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (off < 0 || len < 0 || b.length - off < len) {
            throw new IndexOutOfBoundsException();
        }
        for (i = 0; i < len; ++i) {
            try {
                int ch = this.read();
                if (ch < 0) {
                    return i == 0 ? -1 : i;
                }
                b[off + i] = (byte)ch;
                continue;
            }
            catch (IOException ex) {
                if (i != 0) continue;
                throw ex;
            }
        }
        return i;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

