/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.StreambasedTransportHandler;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TcpTransportHandler
extends StreambasedTransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected Socket socket;
    protected Integer srcPort;
    protected Integer dstPort;

    public TcpTransportHandler(Connection con) {
        super(con);
        this.srcPort = con.getSourcePort();
    }

    public TcpTransportHandler(long timeout, ConnectionEndType type) {
        super(timeout, type);
    }

    public SocketState getSocketState(boolean withTimeout) {
        try {
            if (this.cachedSocketState != null) {
                return this.cachedSocketState;
            }
            if (this.inStream == null) {
                return SocketState.UNAVAILABLE;
            }
            if (this.inStream.available() > 0) {
                return SocketState.DATA_AVAILABLE;
            }
            if (withTimeout) {
                this.socket.setSoTimeout((int)this.timeout);
            } else {
                this.socket.setSoTimeout(1);
            }
            int read = this.inStream.read();
            if (read == -1) {
                return SocketState.CLOSED;
            }
            this.inStream.unread(read);
            return SocketState.DATA_AVAILABLE;
        }
        catch (SocketTimeoutException ex) {
            return SocketState.UP;
        }
        catch (SocketException ex) {
            return SocketState.SOCKET_EXCEPTION;
        }
        catch (IOException ex) {
            return SocketState.IO_EXCEPTION;
        }
    }

    @Override
    public void setTimeout(long timeout) {
        try {
            this.timeout = timeout;
            this.socket.setSoTimeout((int)timeout);
        }
        catch (SocketException ex) {
            LOGGER.debug("Could not adjust socket timeout", (Throwable)ex);
        }
    }

    public SocketState getSocketState() {
        return this.getSocketState(false);
    }

    public abstract Integer getSrcPort();

    public abstract void setSrcPort(int var1);

    public abstract Integer getDstPort();

    public abstract void setDstPort(int var1);

    public String getSrcIp() {
        if (this.socket == null || this.socket.getLocalAddress() == null) {
            return null;
        }
        return this.socket.getLocalAddress().getHostAddress();
    }

    public String getDstIp() {
        if (this.socket == null || this.socket.getInetAddress() == null) {
            return null;
        }
        return this.socket.getInetAddress().getHostAddress();
    }
}

