/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.tcp.proxy;

import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ProxyableTransportHandler;
import de.rub.nds.tlsattacker.transport.TimeableTransportHandler;
import de.rub.nds.tlsattacker.transport.tcp.ClientTcpTransportHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimingProxyClientTcpTransportHandler
extends ClientTcpTransportHandler
implements ProxyableTransportHandler,
TimeableTransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_PROXY_DATA_PORT = 4444;
    private static final int DEFAULT_PROXY_CONTROL_PORT = 5555;
    protected Socket controlSocket;
    protected String proxyDataHostName = "127.0.0.1";
    protected int proxyDataPort = 4444;
    protected String proxyControlHostName = "127.0.0.1";
    protected int proxyControlPort = 5555;
    protected Long measurement = null;

    public TimingProxyClientTcpTransportHandler(Connection connection) {
        super(connection);
        this.proxyDataHostName = connection.getProxyDataHostname();
        this.proxyDataPort = connection.getProxyDataPort();
        this.proxyControlHostName = connection.getProxyControlHostname();
        this.proxyControlPort = connection.getProxyControlPort();
    }

    public TimingProxyClientTcpTransportHandler(long firstTimeout, long timeout, String hostname, int port) {
        super(firstTimeout, timeout, hostname, port);
    }

    @Override
    public byte[] fetchData() throws IOException {
        byte[] data = super.fetchData();
        byte[] controlData = new byte[8];
        if (data.length > 0) {
            int bytesRead = this.controlSocket.getInputStream().read(controlData);
            if (bytesRead != 8) {
                throw new IOException("Should return 64 bit unsigned int");
            }
            this.measurement = ByteBuffer.wrap(controlData).getLong();
        }
        return data;
    }

    @Override
    public void setProxy(String dataChannelHost, int dataChanelPort, String controlChannelHost, int controlChanelPort) {
        this.proxyDataHostName = dataChannelHost;
        this.proxyDataPort = dataChanelPort;
        this.proxyControlHostName = controlChannelHost;
        this.proxyControlPort = controlChanelPort;
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.socket == null) {
            throw new IOException("Transporthandler is not initalized!");
        }
        this.socket.close();
        if (this.controlSocket == null) {
            throw new IOException("Transport handler is not initialized!");
        }
        this.controlSocket.close();
    }

    @Override
    public void initialize() throws IOException {
        this.controlSocket = new Socket();
        this.controlSocket.connect(new InetSocketAddress(this.proxyControlHostName, this.proxyControlPort), (int)this.connectionTimeout);
        this.cachedSocketState = null;
        this.controlSocket.getOutputStream().write((this.hostname + "\n").getBytes(StandardCharsets.ISO_8859_1));
        this.controlSocket.getOutputStream().write((Integer.toString(this.dstPort) + "\n").getBytes(StandardCharsets.ISO_8859_1));
        this.controlSocket.getOutputStream().flush();
        this.hostname = this.proxyDataHostName;
        this.dstPort = this.proxyDataPort;
        super.initialize();
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.socket.isClosed() || this.socket.isInputShutdown() || this.controlSocket.isClosed() || this.controlSocket.isInputShutdown();
    }

    @Override
    public void closeClientConnection() throws IOException {
        this.closeConnection();
    }

    @Override
    public Long getLastMeasurement() {
        return this.measurement;
    }

    @Override
    public boolean isMeasuringActive() {
        return true;
    }

    @Override
    public void setMeasuringActive(boolean measuringActive) {
        if (!measuringActive) {
            LOGGER.warn("Ignoring deactivation of measuring for proxy-based transport handler.");
        }
    }
}

