/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.transport.udp;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.PacketbasedTransportHandler;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.socket.SocketState;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class UdpTransportHandler
extends PacketbasedTransportHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected DatagramSocket socket;
    protected int port;
    private static final int RECEIVE_BUFFER_SIZE = 65536;
    private final byte[] dataBuffer = new byte[65536];
    private ByteArrayInputStream dataBufferInputStream;

    public UdpTransportHandler(Connection con) {
        super(con);
    }

    public UdpTransportHandler(long timeout, ConnectionEndType type) {
        super(timeout, type);
    }

    @Override
    public void sendData(byte[] data) throws IOException {
        DatagramPacket packet = new DatagramPacket(data, data.length);
        this.socket.send(packet);
    }

    @Override
    public byte[] fetchData() throws IOException {
        DatagramPacket packet;
        block4: {
            if (this.dataBufferInputStream != null && this.dataBufferInputStream.available() > 0) {
                return this.dataBufferInputStream.readAllBytes();
            }
            this.setTimeout(this.timeout);
            packet = new DatagramPacket(this.dataBuffer, 65536);
            try {
                this.socket.receive(packet);
            }
            catch (SocketException ex) {
                if (this.isClosed()) break block4;
                LOGGER.error("Could not receive on socket", (Throwable)ex);
            }
        }
        if (!this.socket.isConnected()) {
            this.socket.connect(packet.getSocketAddress());
        }
        return Arrays.copyOfRange(packet.getData(), 0, packet.getLength());
    }

    @Override
    public byte[] fetchData(int amountOfData) throws IOException {
        try (SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();){
            outputStream.write(this.dataBufferInputStream.readAllBytes());
            this.setTimeout(this.timeout);
            while (outputStream.size() < amountOfData) {
                DatagramPacket packet = new DatagramPacket(this.dataBuffer, 65536);
                this.socket.receive(packet);
                if (!this.socket.isConnected()) {
                    this.socket.connect(packet.getSocketAddress());
                }
                outputStream.write(Arrays.copyOfRange(packet.getData(), 0, packet.getLength()));
            }
            this.dataBufferInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            byte[] byArray = this.dataBufferInputStream.readNBytes(amountOfData);
            return byArray;
        }
    }

    @Override
    public void setTimeout(long timeout) {
        block3: {
            try {
                this.timeout = timeout;
                if (this.socket != null) {
                    this.socket.setSoTimeout((int)timeout);
                }
            }
            catch (SocketException ex) {
                if (this.isClosed()) break block3;
                LOGGER.error("Could not adjust socket timeout", (Throwable)ex);
            }
        }
    }

    @Override
    public void closeConnection() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    @Override
    public boolean isClosed() {
        if (this.socket != null) {
            return this.socket.isClosed();
        }
        return true;
    }

    public SocketState getSocketState() {
        if (this.socket.isClosed()) {
            return SocketState.CLOSED;
        }
        if (this.socket.isConnected()) {
            return SocketState.UP;
        }
        if (this.socket.isBound()) {
            return SocketState.BOUND;
        }
        return SocketState.UNAVAILABLE;
    }

    public int getSrcPort() {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getLocalPort();
    }

    public int getDstPort() {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getPort();
    }

    public String getSrcIp() {
        if (this.socket == null || this.socket.getLocalAddress() == null) {
            return null;
        }
        return this.socket.getLocalAddress().getHostAddress();
    }

    public String getDstIp() {
        if (this.socket == null || this.socket.getInetAddress() == null) {
            return null;
        }
        return this.socket.getInetAddress().getHostAddress();
    }
}

