/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.server;

import de.rub.nds.protocol.exception.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TlsServer {
    private static final Logger LOGGER = LogManager.getLogger();

    public State execute(Config config, WorkflowTrace trace) {
        State state = trace != null ? new State(config, trace) : new State(config);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(config.getWorkflowExecutorType(), state);
        try {
            workflowExecutor.executeWorkflow();
        }
        catch (WorkflowExecutionException ex) {
            LOGGER.info("The TLS protocol flow was not executed completely, follow the debug messages for more information.", (Throwable)ex);
        }
        return state;
    }
}

