/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.chooser;

import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.xml.Pair;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import de.rub.nds.x509attacker.constants.X509NamedCurve;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.constants.X509SignatureAlgorithm;
import de.rub.nds.x509attacker.context.X509Context;
import java.math.BigInteger;
import java.util.List;

public class X509Chooser {
    private final X509CertificateConfig config;
    private final X509Context context;

    public X509Chooser(X509CertificateConfig config, X509Context context) {
        this.config = config;
        this.context = context;
    }

    public X509CertificateConfig getConfig() {
        return this.config;
    }

    public X509Context getContext() {
        return this.context;
    }

    public X509SignatureAlgorithm getSignatureAlgorithm() {
        if (this.context.getSubjectSignatureAlgorithm() != null) {
            return this.context.getSubjectSignatureAlgorithm();
        }
        return this.config.getDefaultSignatureAlgorithm();
    }

    public X509PublicKeyType getIssuerPublicKeyType() {
        if (this.context.getIssuerPublicKeyType() != null) {
            return this.context.getIssuerPublicKeyType();
        }
        return this.config.getDefaultIssuerPublicKeyType();
    }

    public X509NamedCurve getIssuerNamedCurve() {
        if (this.context.getIssuerNamedCurve() != null) {
            return this.context.getIssuerNamedCurve();
        }
        return this.config.getDefaultIssuerNamedCurve();
    }

    public BigInteger getIssuerRsaPrivateExponent() {
        if (this.context.getIssuerRsaPrivateExponent() != null) {
            return this.context.getIssuerRsaPrivateExponent();
        }
        return this.config.getDefaultIssuerRsaPrivateExponent();
    }

    public BigInteger getIssuerRsaModulus() {
        if (this.context.getIssuerRsaModulus() != null) {
            return this.context.getIssuerRsaModulus();
        }
        return this.config.getDefaultIssuerRsaModulus();
    }

    public BigInteger getIssuerDsaPrivateKeyX() {
        if (this.context.getIssuerDsaPrivateKeyX() != null) {
            return this.context.getIssuerDsaPrivateKeyX();
        }
        return this.config.getDefaultIssuerDsaPrivateKey();
    }

    public BigInteger getIssuerDsaPrivateK() {
        if (this.context.getIssuerDsaPrivateK() != null) {
            return this.context.getIssuerDsaPrivateK();
        }
        return this.config.getDefaultIssuerDsaNonce();
    }

    public BigInteger getIssuerEcPrivateKey() {
        if (this.context.getIssuerEcPrivateKey() != null) {
            return this.context.getIssuerEcPrivateKey();
        }
        return this.config.getDefaultIssuerEcPrivateKey();
    }

    public Point getIssuerEcPublicKey() {
        if (this.context.getIssuerEcPrivateKey() != null) {
            return this.context.getIssuerEcPublicKey();
        }
        return this.config.getDefaultIssuerEcPublicKey();
    }

    public List<Pair<X500AttributeType, String>> getIssuer() {
        if (this.context.getIssuer() != null) {
            return this.context.getIssuer();
        }
        return this.config.getDefaultIssuer();
    }

    public byte[] getIssuerUniqueId() {
        if (this.context.getIssuerUniqueId() != null) {
            return this.context.getIssuerUniqueId();
        }
        return this.config.getDefaultIssuerUniqueId();
    }

    public X509PublicKeyType getSubjectPublicKeyType() {
        if (this.context.getSubjectPublicKeyType() != null) {
            return this.context.getSubjectPublicKeyType();
        }
        return this.config.getPublicKeyType();
    }

    public X509NamedCurve getSubjectNamedCurve() {
        if (this.context.getSubjectNamedCurve() != null) {
            return this.context.getSubjectNamedCurve();
        }
        return this.config.getDefaultSubjectNamedCurve();
    }

    public BigInteger getSubjectDhPrivateKey() {
        if (this.context.getSubjectDhPrivateKey() != null) {
            return this.context.getSubjectDhPrivateKey();
        }
        return this.config.getDefaultSubjectDhPrivateKey();
    }

    public BigInteger getSubjectDhModulus() {
        if (this.context.getSubjectDhModulus() != null) {
            return this.context.getSubjectDhModulus();
        }
        return this.config.getDhModulus();
    }

    public BigInteger getSubjectDhGenerator() {
        if (this.context.getSubjectDhModulus() != null) {
            return this.context.getSubjectDhGenerator();
        }
        return this.config.getDhGenerator();
    }

    public BigInteger getSubjectRsaPublicExponent() {
        if (this.context.getSubjectRsaPublicExponent() != null) {
            return this.context.getSubjectRsaPublicExponent();
        }
        return this.config.getDefaultSubjectRsaPublicExponent();
    }

    public BigInteger getSubjectRsaModulus() {
        if (this.context.getSubjectRsaModulus() != null) {
            return this.context.getSubjectRsaModulus();
        }
        return this.config.getDefaultSubjectRsaModulus();
    }

    public BigInteger getSubjectEcPrivateKey() {
        if (this.context.getSubjectEcPrivateKey() != null) {
            return this.context.getSubjectEcPrivateKey();
        }
        return this.config.getDefaultSubjectEcPrivateKey();
    }

    public Point getSubjectEcPublicKey() {
        if (this.context.getSubjectEcPublicKey() != null) {
            return this.context.getSubjectEcPublicKey();
        }
        return this.config.getDefaultSubjectEcPublicKey();
    }

    public BigInteger getSubjectDsaPrivateKeyX() {
        if (this.context.getSubjectDsaPrivateKeyX() != null) {
            return this.context.getSubjectDsaPrivateKeyX();
        }
        return this.config.getDefaultSubjectDsaPrivateKey();
    }

    public BigInteger getSubjectDsaPrivateKeyK() {
        if (this.context.getSubjectDsaPrivateK() != null) {
            return this.context.getSubjectDsaPrivateK();
        }
        return this.config.getDefaultSubjectDsaNonce();
    }

    public BigInteger getSubjectRsaPrivateKey() {
        if (this.context.getSubjectRsaPrivateExponent() != null) {
            return this.context.getSubjectRsaPrivateExponent();
        }
        return this.config.getDefaultSubjectRsaPrivateExponent();
    }

    public BigInteger getSubjectDhPublicKey() {
        if (this.context.getSubjectDhPublicKey() != null) {
            return this.context.getSubjectDhPublicKey();
        }
        return this.config.getDefaultSubjectDhPublicKey();
    }

    public BigInteger getSubjectDsaPrimeP() {
        if (this.context.getSubjectDsaPrimeModulusP() != null) {
            return this.context.getSubjectDsaPrimeModulusP();
        }
        return this.config.getDefaultSubjectDsaPrimeP();
    }

    public BigInteger getSubjectDsaPrimeQ() {
        if (this.context.getSubjectDsaPrimeDivisorQ() != null) {
            return this.context.getSubjectDsaPrimeDivisorQ();
        }
        return this.config.getDefaultSubjectDsaPrimeQ();
    }

    public BigInteger getSubjectDsaGenerator() {
        if (this.context.getSubjectDsaGeneratorG() != null) {
            return this.context.getSubjectDsaGeneratorG();
        }
        return this.config.getDefaultSubjectDsaGenerator();
    }

    public BigInteger getIssuerDsaPrimeP() {
        if (this.context.getIssuerDsaPrimeModulusP() != null) {
            return this.context.getIssuerDsaPrimeModulusP();
        }
        return this.config.getDefaultIssuerDsaPrimeP();
    }

    public BigInteger getIssuerDsaPrimeQ() {
        if (this.context.getIssuerDsaPrimeDivisorQ() != null) {
            return this.context.getIssuerDsaPrimeDivisorQ();
        }
        return this.config.getDefaultIssuerDsaPrimeQ();
    }

    public BigInteger getIssuerDsaGenerator() {
        if (this.context.getIssuerDsaGeneratorG() != null) {
            return this.context.getIssuerDsaGeneratorG();
        }
        return this.config.getDefaultIssuerDsaGenerator();
    }

    public byte[] getRsaPssSalt() {
        if (this.context.getRsaPssSalt() != null) {
            return this.context.getRsaPssSalt();
        }
        return this.config.getRsaPssSalt();
    }

    public HashAlgorithm getRsaPssHashAlgorithm() {
        if (this.context.getRsaPssHashAlgorithm() != null) {
            return this.context.getRsaPssHashAlgorithm();
        }
        return this.config.getRsaPssHashAlgorithm();
    }
}

