/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.config.extension;

import de.rub.nds.x509attacker.config.extension.ExtensionConfig;
import de.rub.nds.x509attacker.constants.GeneralNameChoiceType;
import de.rub.nds.x509attacker.constants.X509ExtensionType;
import de.rub.nds.x509attacker.x509.model.GeneralName;
import de.rub.nds.x509attacker.x509.model.extensions.AuthorityKeyIdentifier;
import java.util.ArrayList;
import java.util.List;

public class AuthorityKeyIdentifierConfig
extends ExtensionConfig {
    private byte[] keyIdentifier;
    private List<GeneralNameChoiceType> generalNameChoiceTypeConfigs;
    private List<Object> generalNameConfigValues;
    private int serialNumber;

    public AuthorityKeyIdentifierConfig() {
        super(X509ExtensionType.AUTHORITY_KEY_IDENTIFIER.getOid(), "authorityKeyIdentifier");
    }

    @Override
    public AuthorityKeyIdentifier getExtensionFromConfig() {
        return new AuthorityKeyIdentifier("authorityKeyIdentifier");
    }

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyIdentifier(byte[] keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    public List<GeneralNameChoiceType> getGeneralNameChoiceTypeConfig() {
        return this.generalNameChoiceTypeConfigs;
    }

    public void setGeneralNameChoiceTypeConfig(List<GeneralNameChoiceType> generalNameChoiceTypeConfigs) {
        this.generalNameChoiceTypeConfigs = generalNameChoiceTypeConfigs;
    }

    public List<Object> getGeneralNameConfigValues() {
        return this.generalNameConfigValues;
    }

    public void setGeneralNameConfigValues(List<Object> generalNameConfigValues) {
        this.generalNameConfigValues = generalNameConfigValues;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public List<GeneralName> getAuthorityCertIssuers() {
        ArrayList<GeneralName> authorityCertIssuers = new ArrayList<GeneralName>();
        for (int i = 0; i < this.generalNameConfigValues.size(); ++i) {
            GeneralName authorityCertIssuer = new GeneralName("authorityCertIssuer");
            authorityCertIssuer.setGeneralNameChoiceTypeConfig(this.generalNameChoiceTypeConfigs.get(i));
            authorityCertIssuer.setGeneralNameConfigValue(this.generalNameConfigValues.get(i));
            authorityCertIssuers.add(authorityCertIssuer);
        }
        return authorityCertIssuers;
    }
}

