/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.config.extension;

import de.rub.nds.x509attacker.config.extension.ExtensionConfig;
import de.rub.nds.x509attacker.constants.GeneralNameChoiceType;
import de.rub.nds.x509attacker.constants.X509ExtensionType;
import de.rub.nds.x509attacker.x509.model.GeneralName;
import de.rub.nds.x509attacker.x509.model.extensions.IssuerAlternativeName;
import java.util.ArrayList;
import java.util.List;

public class IssuerAlternativeNameConfig
extends ExtensionConfig {
    private List<GeneralNameChoiceType> generalNameChoiceTypeConfigs;
    private List<Object> generalNameConfigValues;

    public IssuerAlternativeNameConfig() {
        super(X509ExtensionType.ISSUER_ALTERNATIVE_NAME.getOid(), "issuerAltName");
    }

    @Override
    public IssuerAlternativeName getExtensionFromConfig() {
        return new IssuerAlternativeName("issuerAltName");
    }

    public List<GeneralName> getIssuerAltName() {
        ArrayList<GeneralName> issuerAltName = new ArrayList<GeneralName>();
        for (int i = 0; i < this.generalNameConfigValues.size(); ++i) {
            GeneralName issuerName = new GeneralName("issuerAltName");
            issuerName.setGeneralNameChoiceTypeConfig(this.generalNameChoiceTypeConfigs.get(i));
            issuerName.setGeneralNameConfigValue(this.generalNameConfigValues.get(i));
            issuerAltName.add(issuerName);
        }
        return issuerAltName;
    }

    public List<GeneralNameChoiceType> getGeneralNameChoiceTypeConfigs() {
        return this.generalNameChoiceTypeConfigs;
    }

    public void setGeneralNameChoiceTypeConfigs(List<GeneralNameChoiceType> generalNameChoiceTypeConfigs) {
        this.generalNameChoiceTypeConfigs = generalNameChoiceTypeConfigs;
    }

    public List<Object> getGeneralNameConfigValues() {
        return this.generalNameConfigValues;
    }

    public void setGeneralNameConfigValues(List<Object> generalNameConfigValues) {
        this.generalNameConfigValues = generalNameConfigValues;
    }
}

