/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.constants;

import java.math.BigInteger;

public enum X509Version {
    V1(new BigInteger("0")),
    V2(new BigInteger("1")),
    V3(new BigInteger("2"));

    private final BigInteger value;

    private X509Version(BigInteger value) {
        this.value = value;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public static X509Version convert(BigInteger value) {
        for (X509Version version : X509Version.values()) {
            if (!version.getValue().equals(value)) continue;
            return version;
        }
        return null;
    }
}

