/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.context;

import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.xml.Pair;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import de.rub.nds.x509attacker.constants.X509NamedCurve;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.constants.X509SignatureAlgorithm;
import de.rub.nds.x509attacker.constants.X509Version;
import java.math.BigInteger;
import java.util.List;
import org.joda.time.DateTime;

public class X509Context {
    private BigInteger issuerRsaPrivateExponent = null;
    private BigInteger issuerRsaModulus = null;
    private BigInteger issuerDsaPublicKeyY = null;
    private BigInteger issuerDsaPrivateKeyX = null;
    private BigInteger issuerDsaPrivateK = null;
    private BigInteger issuerEcPrivateKey = null;
    private Point issuerEcPublicKey = null;
    private X509PublicKeyType issuerPublicKeyType = null;
    private byte[] issuerUniqueId = null;
    private byte[] subjectUniqueId = null;
    private X509NamedCurve issuerNamedCurve = null;
    private List<Pair<X500AttributeType, String>> issuer = null;
    private List<Pair<X500AttributeType, String>> subject = null;
    private BigInteger subjectRsaPrivateExponent = null;
    private BigInteger subjectRsaModulus = null;
    private BigInteger subjectRsaPublicExponent = null;
    private BigInteger subjectDsaPublicKeyY = null;
    private BigInteger subjectDsaPrimeModulusP = null;
    private BigInteger subjectDsaPrimeDivisorQ = null;
    private BigInteger subjectDsaGeneratorG = null;
    private BigInteger issuerDsaPrimeModulusP = null;
    private BigInteger issuerDsaPrimeDivisorQ = null;
    private BigInteger issuerDsaGeneratorG = null;
    private BigInteger subjectDsaPrivateK = null;
    private BigInteger subjectDsaPrivateKeyX = null;
    private BigInteger subjectEcPrivateKey = null;
    private Point subjectEcPublicKey = null;
    private X509SignatureAlgorithm subjectSignatureAlgorithm;
    private X509PublicKeyType subjectPublicKeyType = null;
    private X509NamedCurve subjectNamedCurve = null;
    private BigInteger subjectDhPrivateKey = null;
    private BigInteger subjectDhPublicKey = null;
    private BigInteger subjectDhModulus = null;
    private BigInteger subjectDhGenerator = null;
    private byte[] subjectDhValidationParamsSeed = null;
    private BigInteger subjectDhValidationParamsPgen = null;
    private BigInteger serialNumber = null;
    private DateTime notBefore = null;
    private DateTime notAfter = null;
    private X509Version version = null;
    private byte[] rsaPssSalt = null;
    private HashAlgorithm rsaPssHashAlgorithm;
    private BigInteger ecdsaNonce;
    private X509CertificateConfig config;
    private X509Chooser chooser;

    public X509Context() {
        this(new X509CertificateConfig());
    }

    public X509Context(X509CertificateConfig config) {
        this.config = config;
        this.chooser = new X509Chooser(config, this);
    }

    public X509Version getVersion() {
        return this.version;
    }

    public void setVersion(X509Version version) {
        this.version = version;
    }

    public byte[] getRsaPssSalt() {
        return this.rsaPssSalt;
    }

    public void setRsaPssSalt(byte[] rsaPssSalt) {
        this.rsaPssSalt = rsaPssSalt;
    }

    public HashAlgorithm getRsaPssHashAlgorithm() {
        return this.rsaPssHashAlgorithm;
    }

    public void setRsaPssHashAlgorithm(HashAlgorithm rsaPssHashAlgorithm) {
        this.rsaPssHashAlgorithm = rsaPssHashAlgorithm;
    }

    public DateTime getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(DateTime notBefore) {
        this.notBefore = notBefore;
    }

    public DateTime getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(DateTime notAfter) {
        this.notAfter = notAfter;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public byte[] getSubjectDhValidationParamsSeed() {
        return this.subjectDhValidationParamsSeed;
    }

    public void setSubjectDhValidationParamsSeed(byte[] subjectDhValidationParamsSeed) {
        this.subjectDhValidationParamsSeed = subjectDhValidationParamsSeed;
    }

    public BigInteger getSubjectDhValidationParamsPgen() {
        return this.subjectDhValidationParamsPgen;
    }

    public void setSubjectDhValidationParamsPgen(BigInteger subjectDhValidationParamsPgen) {
        this.subjectDhValidationParamsPgen = subjectDhValidationParamsPgen;
    }

    public X509CertificateConfig getConfig() {
        return this.config;
    }

    public void setConfig(X509CertificateConfig config) {
        this.config = config;
        this.chooser = new X509Chooser(config, this);
    }

    public X509Chooser getChooser() {
        return this.chooser;
    }

    public BigInteger getSubjectDhPrivateKey() {
        return this.subjectDhPrivateKey;
    }

    public void setSubjectDhPrivateKey(BigInteger subjectDhPrivateKey) {
        this.subjectDhPrivateKey = subjectDhPrivateKey;
    }

    public BigInteger getSubjectDhModulus() {
        return this.subjectDhModulus;
    }

    public void setSubjectDhModulus(BigInteger subjectDhModulus) {
        this.subjectDhModulus = subjectDhModulus;
    }

    public BigInteger getSubjectDhGenerator() {
        return this.subjectDhGenerator;
    }

    public void setSubjectDhGenerator(BigInteger subjectDhGenerator) {
        this.subjectDhGenerator = subjectDhGenerator;
    }

    public List<Pair<X500AttributeType, String>> getSubject() {
        return this.subject;
    }

    public void setSubject(List<Pair<X500AttributeType, String>> subject) {
        this.subject = subject;
    }

    public BigInteger getSubjectRsaPrivateExponent() {
        return this.subjectRsaPrivateExponent;
    }

    public void setSubjectRsaPrivateExponent(BigInteger subjectRsaPrivateExponent) {
        this.subjectRsaPrivateExponent = subjectRsaPrivateExponent;
    }

    public BigInteger getSubjectRsaModulus() {
        return this.subjectRsaModulus;
    }

    public void setSubjectRsaModulus(BigInteger subjectRsaModulus) {
        this.subjectRsaModulus = subjectRsaModulus;
    }

    public BigInteger getSubjectDsaPublicKeyY() {
        return this.subjectDsaPublicKeyY;
    }

    public void setSubjectDsaPublicKeyY(BigInteger subjectDsaPublicKeyY) {
        this.subjectDsaPublicKeyY = subjectDsaPublicKeyY;
    }

    public BigInteger getSubjectDsaPrivateKeyX() {
        return this.subjectDsaPrivateKeyX;
    }

    public void setSubjectDsaPrivateKeyX(BigInteger subjectDsaPrivateKeyX) {
        this.subjectDsaPrivateKeyX = subjectDsaPrivateKeyX;
    }

    public BigInteger getSubjectDsaPrivateK() {
        return this.subjectDsaPrivateK;
    }

    public void setSubjectDsaPrivateK(BigInteger subjectDsaPrivateK) {
        this.subjectDsaPrivateK = subjectDsaPrivateK;
    }

    public BigInteger getSubjectEcPrivateKey() {
        return this.subjectEcPrivateKey;
    }

    public void setSubjectEcPrivateKey(BigInteger subjectEcPrivateKey) {
        this.subjectEcPrivateKey = subjectEcPrivateKey;
    }

    public BigInteger getSubjectDhPublicKey() {
        return this.subjectDhPublicKey;
    }

    public void setSubjectDhPublicKey(BigInteger subjectDhPublicKey) {
        this.subjectDhPublicKey = subjectDhPublicKey;
    }

    public X509NamedCurve getIssuerNamedCurve() {
        return this.issuerNamedCurve;
    }

    public void setIssuerNamedCurve(X509NamedCurve issuerNamedCurve) {
        this.issuerNamedCurve = issuerNamedCurve;
    }

    public X509NamedCurve getSubjectNamedCurve() {
        return this.subjectNamedCurve;
    }

    public void setSubjectNamedCurve(X509NamedCurve subjectNamedCurve) {
        this.subjectNamedCurve = subjectNamedCurve;
    }

    public BigInteger getIssuerDsaPublicKeyY() {
        return this.issuerDsaPublicKeyY;
    }

    public void setIssuerDsaPublicKeyY(BigInteger issuerDsaPublicKeyY) {
        this.issuerDsaPublicKeyY = issuerDsaPublicKeyY;
    }

    public X509PublicKeyType getSubjectPublicKeyType() {
        return this.subjectPublicKeyType;
    }

    public void setSubjectPublicKeyType(X509PublicKeyType subjectPublicKeyType) {
        this.subjectPublicKeyType = subjectPublicKeyType;
    }

    public X509SignatureAlgorithm getSubjectSignatureAlgorithm() {
        return this.subjectSignatureAlgorithm;
    }

    public void setSubjectSignatureAlgorithm(X509SignatureAlgorithm subjectSignatureAlgorithm) {
        this.subjectSignatureAlgorithm = subjectSignatureAlgorithm;
    }

    public BigInteger getIssuerRsaPrivateExponent() {
        return this.issuerRsaPrivateExponent;
    }

    public void setIssuerRsaPrivateExponent(BigInteger issuerRsaPrivateExponent) {
        this.issuerRsaPrivateExponent = issuerRsaPrivateExponent;
    }

    public BigInteger getIssuerRsaModulus() {
        return this.issuerRsaModulus;
    }

    public void setIssuerRsaModulus(BigInteger issuerRsaModulus) {
        this.issuerRsaModulus = issuerRsaModulus;
    }

    public BigInteger getIssuerDsaPrivateKeyX() {
        return this.issuerDsaPrivateKeyX;
    }

    public void setIssuerDsaPrivateKeyX(BigInteger issuerDsaPrivateKeyX) {
        this.issuerDsaPrivateKeyX = issuerDsaPrivateKeyX;
    }

    public BigInteger getIssuerDsaPrivateK() {
        return this.issuerDsaPrivateK;
    }

    public void setIssuerDsaPrivateK(BigInteger issuerDsaPrivateK) {
        this.issuerDsaPrivateK = issuerDsaPrivateK;
    }

    public BigInteger getIssuerEcPrivateKey() {
        return this.issuerEcPrivateKey;
    }

    public void setIssuerEcPrivateKey(BigInteger issuerEcPrivateKey) {
        this.issuerEcPrivateKey = issuerEcPrivateKey;
    }

    public List<Pair<X500AttributeType, String>> getIssuer() {
        return this.issuer;
    }

    public void setIssuer(List<Pair<X500AttributeType, String>> issuer) {
        this.issuer = issuer;
    }

    public byte[] getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public void setIssuerUniqueId(byte[] issuerUniqueId) {
        this.issuerUniqueId = issuerUniqueId;
    }

    public Point getIssuerEcPublicKey() {
        return this.issuerEcPublicKey;
    }

    public void setIssuerEcPublicKey(Point issuerEcPublicKey) {
        this.issuerEcPublicKey = issuerEcPublicKey;
    }

    public X509PublicKeyType getIssuerPublicKeyType() {
        return this.issuerPublicKeyType;
    }

    public void setIssuerPublicKeyType(X509PublicKeyType issuerPublicKeyType) {
        this.issuerPublicKeyType = issuerPublicKeyType;
    }

    public Point getSubjectEcPublicKey() {
        return this.subjectEcPublicKey;
    }

    public void setSubjectEcPublicKey(Point subjectEcPublicKey) {
        this.subjectEcPublicKey = subjectEcPublicKey;
    }

    public BigInteger getSubjectRsaPublicExponent() {
        return this.subjectRsaPublicExponent;
    }

    public void setSubjectRsaPublicExponent(BigInteger subjectRsaPublicExponent) {
        this.subjectRsaPublicExponent = subjectRsaPublicExponent;
    }

    public byte[] getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public void setSubjectUniqueId(byte[] subjectUniqueId) {
        this.subjectUniqueId = subjectUniqueId;
    }

    public BigInteger getSubjectDsaPrimeModulusP() {
        return this.subjectDsaPrimeModulusP;
    }

    public void setSubjectDsaPrimeModulusP(BigInteger subjectDsaPrimeModulusP) {
        this.subjectDsaPrimeModulusP = subjectDsaPrimeModulusP;
    }

    public BigInteger getSubjectDsaPrimeDivisorQ() {
        return this.subjectDsaPrimeDivisorQ;
    }

    public void setSubjectDsaPrimeDivisorQ(BigInteger subjectDsaPrimeDivisorQ) {
        this.subjectDsaPrimeDivisorQ = subjectDsaPrimeDivisorQ;
    }

    public BigInteger getSubjectDsaGeneratorG() {
        return this.subjectDsaGeneratorG;
    }

    public void setSubjectDsaGeneratorG(BigInteger subjectDsaGeneratorG) {
        this.subjectDsaGeneratorG = subjectDsaGeneratorG;
    }

    public BigInteger getIssuerDsaPrimeModulusP() {
        return this.issuerDsaPrimeModulusP;
    }

    public void setIssuerDsaPrimeModulusP(BigInteger issuerDsaPrimeModulusP) {
        this.issuerDsaPrimeModulusP = issuerDsaPrimeModulusP;
    }

    public BigInteger getIssuerDsaPrimeDivisorQ() {
        return this.issuerDsaPrimeDivisorQ;
    }

    public void setIssuerDsaPrimeDivisorQ(BigInteger issuerDsaPrimeDivisorQ) {
        this.issuerDsaPrimeDivisorQ = issuerDsaPrimeDivisorQ;
    }

    public BigInteger getIssuerDsaGeneratorG() {
        return this.issuerDsaGeneratorG;
    }

    public void setIssuerDsaGeneratorG(BigInteger issuerDsaGeneratorG) {
        this.issuerDsaGeneratorG = issuerDsaGeneratorG;
    }

    public BigInteger getEcdsaNonce() {
        return this.ecdsaNonce;
    }

    public void setEcdsaNonce(BigInteger ecdsaNonce) {
        this.ecdsaNonce = ecdsaNonce;
    }
}

