/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.filesystem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class CertificateFileWriter {
    public static final String CERTIFICATE_PEM_PREFIX = "-----BEGIN CERTIFICATE-----\r\n";
    public static final String CERTIFICATE_PEM_SUFFIX = "\r\n-----END CERTIFICATE-----\r\n";
    private final FileOutputStream outputStream;

    public CertificateFileWriter(File file) throws IOException {
        this.outputStream = new FileOutputStream(file);
    }

    public void writeCertificate(byte[] certificateBytes) throws IOException {
        this.writeCertificate(new String(Base64.getMimeEncoder(64, "\r\n".getBytes(StandardCharsets.UTF_8)).encode(certificateBytes), StandardCharsets.UTF_8));
    }

    public void writeCertificate(String certificateBase64String) throws IOException {
        this.outputStream.write(CERTIFICATE_PEM_PREFIX.getBytes(StandardCharsets.UTF_8));
        this.outputStream.write(certificateBase64String.getBytes(StandardCharsets.UTF_8));
        this.outputStream.write(CERTIFICATE_PEM_SUFFIX.getBytes(StandardCharsets.UTF_8));
    }

    public void close() throws IOException {
        this.outputStream.close();
    }
}

