/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.signatureengine.keyparsers;

import de.rub.nds.x509attacker.constants.KeyFormat;
import de.rub.nds.x509attacker.signatureengine.keyparsers.KeyParser;
import de.rub.nds.x509attacker.signatureengine.keyparsers.KeyParserException;
import de.rub.nds.x509attacker.signatureengine.keyparsers.PemUtil;
import java.io.ByteArrayInputStream;
import java.security.PrivateKey;
import java.security.PublicKey;

public class DefaultKeyParser
implements KeyParser {
    @Override
    public final PrivateKey parsePrivateKey(byte[] keyBytes, KeyFormat keyFormat) {
        switch (keyFormat) {
            case PEM_ENCODED: {
                return this.parsePemPrivateKey(keyBytes);
            }
        }
        throw new KeyParserException("Key format " + String.valueOf((Object)keyFormat) + " not supported by key parser!");
    }

    @Override
    public final PublicKey parsePublicKey(byte[] keyBytes, KeyFormat keyFormat) {
        switch (keyFormat) {
            case PEM_ENCODED: {
                return this.parsePemPublicKey(keyBytes);
            }
        }
        throw new KeyParserException("Key format " + String.valueOf((Object)keyFormat) + " not supported by key parser!");
    }

    protected PrivateKey parsePemPrivateKey(byte[] keyBytes) {
        ByteArrayInputStream keyBytesInputSteam = new ByteArrayInputStream(keyBytes);
        return PemUtil.readPrivateKey(keyBytesInputSteam);
    }

    protected PublicKey parsePemPublicKey(byte[] keyBytes) {
        ByteArrayInputStream keyBytesInputSteam = new ByteArrayInputStream(keyBytes);
        return PemUtil.readPublicKey(keyBytesInputSteam);
    }
}

