/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.signatureengine.keyparsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class PemUtil {
    private PemUtil() {
    }

    public static void writePublicKey(PublicKey key, File targetFile) {
        PemObject pemObject = new PemObject("PublicKey", key.getEncoded());
        PemWriter pemWriter = null;
        try {
            pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), StandardCharsets.UTF_8));
            pemWriter.writeObject((PemObjectGenerator)pemObject);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (pemWriter != null) {
                    pemWriter.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void writeCertificate(Certificate cert, File file) {
        PemWriter pemWriter = null;
        try {
            pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            for (TlsCertificate tempCert : cert.getCertificateList()) {
                PemObject pemObject = new PemObject("CERTIFICATE", tempCert.getEncoded());
                pemWriter.writeObject((PemObjectGenerator)pemObject);
            }
            pemWriter.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (pemWriter != null) {
                    pemWriter.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static Certificate readCertificate(InputStream stream) throws FileNotFoundException, CertificateException, IOException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends java.security.cert.Certificate> certs = certFactory.generateCertificates(stream);
        java.security.cert.Certificate sunCert = (java.security.cert.Certificate)certs.toArray()[0];
        byte[] certBytes = sunCert.getEncoded();
        BcTlsCrypto crypto = new BcTlsCrypto(new SecureRandom());
        TlsCertificate tlsCertificate = crypto.createCertificate(certBytes);
        return new Certificate(new TlsCertificate[]{tlsCertificate});
    }

    public static Certificate readCertificate(File file) throws FileNotFoundException, CertificateException, IOException {
        return PemUtil.readCertificate(new FileInputStream(file));
    }

    /*
     * Loose catch block
     */
    public static PrivateKey readPrivateKey(InputStream stream) {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            PrivateKey privateKey;
            PEMParser parser = new PEMParser((Reader)reader);
            Object obj = null;
            while ((obj = parser.readObject()) != null) {
                PrivateKey privKey;
                if (!(obj instanceof PEMKeyPair)) break block20;
                PEMKeyPair pair = (PEMKeyPair)obj;
                privateKey = privKey = converter.getPrivateKey(pair.getPrivateKeyInfo());
            }
            {
                catch (Throwable throwable) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            {
                PrivateKey privKey;
                block20: {
                    parser.close();
                    return privateKey;
                }
                if (!(obj instanceof PrivateKeyInfo)) continue;
                PrivateKey privateKey2 = privKey = converter.getPrivateKey((PrivateKeyInfo)obj);
                parser.close();
                return privateKey2;
            }
            try {
                throw new RuntimeException("No valid private key found in PEM data");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read private key", e);
            }
        }
        finally {
            try {
                stream.close();
                reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static PrivateKey readPrivateKey(File file) {
        try {
            return PemUtil.readPrivateKey(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Loose catch block
     */
    public static PublicKey readPublicKey(InputStream stream) {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            PublicKey publicKey;
            PEMParser parser = new PEMParser((Reader)reader);
            Object obj = null;
            while ((obj = parser.readObject()) != null) {
                PublicKey pubKey;
                if (!(obj instanceof PEMKeyPair)) break block20;
                PEMKeyPair pair = (PEMKeyPair)obj;
                publicKey = pubKey = converter.getPublicKey(pair.getPublicKeyInfo());
            }
            {
                catch (Throwable throwable) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            {
                PublicKey pubKey;
                block20: {
                    parser.close();
                    return publicKey;
                }
                if (!(obj instanceof SubjectPublicKeyInfo)) continue;
                PublicKey publicKey2 = pubKey = converter.getPublicKey((SubjectPublicKeyInfo)obj);
                parser.close();
                return publicKey2;
            }
            try {
                throw new RuntimeException("No valid public key found in PEM data");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read public key", e);
            }
        }
        finally {
            try {
                stream.close();
                reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static PublicKey readPublicKey(File file) {
        try {
            return PemUtil.readPublicKey(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

