/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.trust;

import de.rub.nds.modifiablevariable.util.ComparableByteArray;
import de.rub.nds.x509attacker.trust.TrustPlatform;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrustAnchorManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<TrustPlatform> trustPlatformList = new LinkedList<TrustPlatform>();
    private HashMap<ComparableByteArray, X509Certificate> trustAnchors = new HashMap();
    private Set<X509Certificate> trustAnchorSet = new LinkedHashSet<X509Certificate>();

    public void addTrustPlaform(TrustPlatform platform) {
        this.trustPlatformList.add(platform);
        for (X509Certificate anchor : platform.getTrustAnchors()) {
            if (this.trustAnchors.containsKey(new ComparableByteArray(anchor.getSha256Fingerprint()))) continue;
            this.trustAnchors.put(new ComparableByteArray(anchor.getSha256Fingerprint()), anchor);
        }
        for (X509Certificate entry : platform.getBlockedTrustAnchors()) {
            if (this.trustAnchors.containsKey(new ComparableByteArray(entry.getSha256Fingerprint()))) continue;
            this.trustAnchors.put(new ComparableByteArray(entry.getSha256Fingerprint()), entry);
        }
    }

    public List<TrustPlatform> getTrustPlatformList() {
        return this.trustPlatformList;
    }

    public boolean isTrustAnchor(X509Certificate certificate) {
        if (this.trustAnchors.containsKey(new ComparableByteArray(certificate.getSha256Fingerprint()))) {
            LOGGER.debug("Found a trustAnchor for certificate");
            return true;
        }
        return false;
    }

    public Set<X509Certificate> getTrustAnchorSet() {
        return this.trustAnchorSet;
    }
}

