/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.trust;

import de.rub.nds.x509attacker.x509.model.X509Certificate;
import java.util.Arrays;
import java.util.List;

public class TrustPath {
    private List<X509Certificate> certificateList;

    public TrustPath(List<X509Certificate> certificateList) {
        this.certificateList = certificateList;
    }

    public List<X509Certificate> getCertificateList() {
        return this.certificateList;
    }

    public X509Certificate getTrustAnchor() {
        return this.certificateList.get(this.certificateList.size() - 1);
    }

    public Boolean containsExpiredCertificate() {
        for (X509Certificate certificate : this.certificateList) {
            if (!certificate.isExpired().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean containsNotYetValidCertificate() {
        for (X509Certificate certificate : this.certificateList) {
            if (certificate.isYetValid().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean containsWeakSignature() {
        for (X509Certificate certificate : this.certificateList) {
            if (!Arrays.equals(certificate.getSha256Fingerprint(), this.getTrustAnchor().getSha256Fingerprint()) || !certificate.isWeakSignature()) continue;
            return true;
        }
        return false;
    }
}

