/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.trust;

import de.rub.nds.x509attacker.x509.model.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class TrustPlatform {
    private final String platform;
    private final String version;
    private final String url;
    private final Date lastUpdate;
    private final List<X509Certificate> trustAnchors;
    private final List<X509Certificate> blockedTrustAnchors;

    public TrustPlatform() {
        this.blockedTrustAnchors = null;
        this.trustAnchors = null;
        this.lastUpdate = null;
        this.platform = null;
        this.url = null;
        this.version = null;
    }

    public TrustPlatform(String platform, String version, String url, Date lastUpdate, List<X509Certificate> certificateEntries, List<X509Certificate> blockedCertificateEntries) {
        this.platform = platform;
        this.version = version;
        this.url = url;
        this.lastUpdate = lastUpdate;
        this.trustAnchors = certificateEntries;
        this.blockedTrustAnchors = blockedCertificateEntries;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public List<X509Certificate> getTrustAnchors() {
        return this.trustAnchors;
    }

    public List<X509Certificate> getBlockedTrustAnchors() {
        return this.blockedTrustAnchors;
    }

    public boolean isTrusted(byte[] sha256Fingerprint) {
        for (X509Certificate anchor : this.trustAnchors) {
            if (!Arrays.equals(anchor.getSha256Fingerprint(), sha256Fingerprint)) continue;
            return true;
        }
        return false;
    }

    public boolean isBlacklisted(byte[] sha256Fingerprint) {
        for (X509Certificate anchor : this.blockedTrustAnchors) {
            if (!Arrays.equals(anchor.getSha256Fingerprint(), sha256Fingerprint)) continue;
            return true;
        }
        return false;
    }

    public X509Certificate getTrustedCertificateEntry(byte[] sha256Fingerprint) {
        for (X509Certificate anchor : this.trustAnchors) {
            if (!Arrays.equals(anchor.getSha256Fingerprint(), sha256Fingerprint)) continue;
            return anchor;
        }
        return null;
    }

    public X509Certificate getBlacklistedCertificateEntry(byte[] sha256Fingerprint) {
        for (X509Certificate anchor : this.blockedTrustAnchors) {
            if (!Arrays.equals(anchor.getSha256Fingerprint(), sha256Fingerprint)) continue;
            return anchor;
        }
        return null;
    }
}

