/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.handler;

import de.rub.nds.protocol.xml.Pair;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.NameType;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import de.rub.nds.x509attacker.x509.handler.X509FieldHandler;
import de.rub.nds.x509attacker.x509.model.AttributeTypeAndValue;
import de.rub.nds.x509attacker.x509.model.Name;
import de.rub.nds.x509attacker.x509.model.RelativeDistinguishedName;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NameHandler
extends X509FieldHandler<Name> {
    private static final Logger LOGGER = LogManager.getLogger();

    public NameHandler(X509Chooser chooser, Name name) {
        super(chooser, name);
    }

    @Override
    public void adjustContextAfterParse() {
        this.adjustContext();
    }

    @Override
    public void adjustContextAfterPrepare() {
        this.adjustContext();
    }

    public void adjustContext() {
        LOGGER.debug("Converting RDN to context RDN");
        LinkedList<Pair<X500AttributeType, String>> rdnList = new LinkedList<Pair<X500AttributeType, String>>();
        for (RelativeDistinguishedName parsedRdn : ((Name)this.component).getRelativeDistinguishedNames()) {
            for (AttributeTypeAndValue attributeTypeAndValue : parsedRdn.getAttributeTypeAndValueList()) {
                rdnList.add((Pair<X500AttributeType, String>)new Pair((Object)attributeTypeAndValue.getAttributeTypeConfig(), (Object)attributeTypeAndValue.getValueConfig()));
            }
        }
        LOGGER.debug("Converted into {} elements", (Object)rdnList.size());
        if (((Name)this.component).getType() == NameType.ISSUER) {
            this.context.setIssuer(rdnList);
        } else if (((Name)this.component).getType() == NameType.SUBJECT) {
            this.context.setSubject(rdnList);
        } else {
            throw new RuntimeException("Unknown NameType: " + ((Name)this.component).getType().name());
        }
    }
}

