/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.handler;

import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.x509.handler.X509FieldHandler;
import de.rub.nds.x509attacker.x509.model.SubjectPublicKeyAlgorithmIdentifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubjectPublicKeyAlgorithmIdentifierHandler
extends X509FieldHandler<SubjectPublicKeyAlgorithmIdentifier> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SubjectPublicKeyAlgorithmIdentifierHandler(X509Chooser chooser, SubjectPublicKeyAlgorithmIdentifier identifier) {
        super(chooser, identifier);
    }

    @Override
    public void adjustContextAfterParse() {
        this.adjustContext();
    }

    @Override
    public void adjustContextAfterPrepare() {
        this.adjustContext();
    }

    public void adjustContext() {
        ObjectIdentifier objectIdentifier = ((SubjectPublicKeyAlgorithmIdentifier)this.component).getAlgorithm().getValueAsOid();
        LOGGER.debug("ObjectIdentifier: {}", (Object)objectIdentifier);
        this.context.setSubjectPublicKeyType(X509PublicKeyType.decodeFromOidBytes(objectIdentifier.getEncoded()));
    }
}

