/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.model;

import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.protocol.xml.Pair;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.DirectoryStringChoiceType;
import de.rub.nds.x509attacker.constants.NameType;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import de.rub.nds.x509attacker.x509.handler.NameHandler;
import de.rub.nds.x509attacker.x509.handler.X509Handler;
import de.rub.nds.x509attacker.x509.model.RelativeDistinguishedName;
import de.rub.nds.x509attacker.x509.model.X509Component;
import de.rub.nds.x509attacker.x509.parser.NameParser;
import de.rub.nds.x509attacker.x509.parser.X509Parser;
import de.rub.nds.x509attacker.x509.preparator.NamePreparator;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Name
extends Asn1Sequence
implements X509Component {
    @HoldsModifiableVariable
    private List<RelativeDistinguishedName> relativeDistinguishedNames;
    private NameType type;

    private Name() {
        super(null);
    }

    public Name(String identifier, NameType type) {
        super(identifier);
        this.type = type;
        this.relativeDistinguishedNames = new LinkedList<RelativeDistinguishedName>();
    }

    public Name(String identifier, NameType type, int implicitTagNumber) {
        super(identifier, implicitTagNumber);
        this.type = type;
        this.relativeDistinguishedNames = new LinkedList<RelativeDistinguishedName>();
    }

    public Name(String identifier, NameType type, List<Pair<X500AttributeType, String>> attributeList, DirectoryStringChoiceType choiceType, List<Pair<X500AttributeType, DirectoryStringChoiceType>> divergentTypes) {
        super(identifier);
        this.type = type;
        this.relativeDistinguishedNames = new LinkedList<RelativeDistinguishedName>();
        for (Pair<X500AttributeType, String> attributePair : attributeList) {
            AtomicReference<DirectoryStringChoiceType> choice = new AtomicReference<DirectoryStringChoiceType>(choiceType);
            divergentTypes.stream().filter(p -> ((X500AttributeType)((Object)((Object)p.getKey()))).equals(attributePair.getKey())).findFirst().ifPresent(matchingPair -> choice.set((DirectoryStringChoiceType)((Object)((Object)matchingPair.getRightElement()))));
            RelativeDistinguishedName relativeDistinguishedName = new RelativeDistinguishedName("relativeDistinguishedName", List.of(attributePair), choice.get());
            this.relativeDistinguishedNames.add(relativeDistinguishedName);
        }
    }

    public NameType getType() {
        return this.type;
    }

    public List<RelativeDistinguishedName> getRelativeDistinguishedNames() {
        return this.relativeDistinguishedNames;
    }

    public void setRelativeDistinguishedNames(List<RelativeDistinguishedName> relativeDistinguishedNames) {
        this.relativeDistinguishedNames = relativeDistinguishedNames;
    }

    public void addRelativeDistinguishedNames(RelativeDistinguishedName relativeDistinguishedName) {
        this.relativeDistinguishedNames.add(relativeDistinguishedName);
    }

    @Override
    public X509Handler getHandler(X509Chooser chooser) {
        return new NameHandler(chooser, this);
    }

    @Override
    public X509Parser getParser(X509Chooser chooser) {
        return new NameParser(chooser, this);
    }

    @Override
    public X509Preparator getPreparator(X509Chooser chooser) {
        return new NamePreparator(chooser, this);
    }
}

