/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.model;

import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.crypto.key.DhPublicKey;
import de.rub.nds.protocol.crypto.key.DsaPublicKey;
import de.rub.nds.protocol.crypto.key.EcdhPublicKey;
import de.rub.nds.protocol.crypto.key.EcdsaPublicKey;
import de.rub.nds.protocol.crypto.key.PublicKeyContainer;
import de.rub.nds.protocol.crypto.key.RsaPublicKey;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.X509NamedCurve;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.x509.handler.SubjectPublicKeyInfoHandler;
import de.rub.nds.x509attacker.x509.handler.X509Handler;
import de.rub.nds.x509attacker.x509.model.SubjectPublicKeyAlgorithmIdentifier;
import de.rub.nds.x509attacker.x509.model.X509Component;
import de.rub.nds.x509attacker.x509.model.publickey.PublicKeyBitString;
import de.rub.nds.x509attacker.x509.model.publickey.PublicKeyContent;
import de.rub.nds.x509attacker.x509.model.publickey.X509DhPublicKey;
import de.rub.nds.x509attacker.x509.model.publickey.X509DsaPublicKey;
import de.rub.nds.x509attacker.x509.model.publickey.X509EcdhEcdsaPublicKey;
import de.rub.nds.x509attacker.x509.model.publickey.X509EcdhPublicKey;
import de.rub.nds.x509attacker.x509.model.publickey.X509RsaPublicKey;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.PublicParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DhParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DssParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509EcNamedCurveParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509NullParameters;
import de.rub.nds.x509attacker.x509.parser.SubjectPublicKeyInfoParser;
import de.rub.nds.x509attacker.x509.parser.X509Parser;
import de.rub.nds.x509attacker.x509.preparator.SubjectPublicKeyInfoPreparator;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SubjectPublicKeyInfo
extends Asn1Sequence
implements X509Component {
    @HoldsModifiableVariable
    private SubjectPublicKeyAlgorithmIdentifier algorithm;
    @HoldsModifiableVariable
    private PublicKeyBitString subjectPublicKeyBitString;

    private SubjectPublicKeyInfo() {
        super(null);
    }

    public SubjectPublicKeyInfo(String identifier, X509CertificateConfig config) {
        super(identifier);
        this.algorithm = new SubjectPublicKeyAlgorithmIdentifier("algorithm");
        this.subjectPublicKeyBitString = new PublicKeyBitString("subjectPublicKeyBitstring", config);
        this.initPublicKeyParameters(config);
    }

    public SubjectPublicKeyInfo(String identifier) {
        super(identifier);
        this.algorithm = new SubjectPublicKeyAlgorithmIdentifier("algorithm");
        this.subjectPublicKeyBitString = new PublicKeyBitString("subjectPublicKeyBitstring");
    }

    public void setAlgorithm(SubjectPublicKeyAlgorithmIdentifier algorithm) {
        this.algorithm = algorithm;
    }

    public SubjectPublicKeyAlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    public PublicKeyBitString getSubjectPublicKeyBitString() {
        return this.subjectPublicKeyBitString;
    }

    public void setSubjectPublicKeyBitString(PublicKeyBitString subjectPublicKeyBitString) {
        this.subjectPublicKeyBitString = subjectPublicKeyBitString;
    }

    private void initPublicKeyParameters(X509CertificateConfig config) {
        PublicParameters publicParameters = null;
        switch (config.getPublicKeyType()) {
            case DH: {
                publicParameters = new X509DhParameters("dhParameters");
                break;
            }
            case ECDH_ECDSA: {
                publicParameters = new X509EcNamedCurveParameters("namedCurveParameters");
                break;
            }
            case RSA: {
                publicParameters = new X509NullParameters("nullParameters");
                break;
            }
            case DSA: {
                publicParameters = new X509DssParameters("dssParameters");
                break;
            }
            case ECDH_ONLY: 
            case ED25519: 
            case ED448: 
            case X25519: 
            case X448: {
                publicParameters = new X509NullParameters("nullParameters");
                break;
            }
            case RSASSA_PSS: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("PublicKeyType: " + config.getPublicKeyType().getHumanReadableName() + " is not supported");
            }
        }
        this.algorithm.setParameters(publicParameters);
    }

    @Override
    public X509Handler getHandler(X509Chooser chooser) {
        return new SubjectPublicKeyInfoHandler(chooser, this);
    }

    @Override
    public X509Parser getParser(X509Chooser chooser) {
        return new SubjectPublicKeyInfoParser(chooser, this);
    }

    @Override
    public X509Preparator getPreparator(X509Chooser chooser) {
        return new SubjectPublicKeyInfoPreparator(chooser, this);
    }

    public PublicKeyContainer getPublicKeyContainer() {
        X509PublicKeyType certificateKeyType = this.subjectPublicKeyBitString.getX509PublicKeyContent().getX509PublicKeyType();
        PublicKeyContent content = this.subjectPublicKeyBitString.getX509PublicKeyContent();
        switch (certificateKeyType) {
            case DH: {
                BigInteger publicKey = (BigInteger)((X509DhPublicKey)content).getValue().getValue();
                BigInteger generator = (BigInteger)((X509DhParameters)this.algorithm.getParameters()).getG().getValue().getValue();
                BigInteger modulus = (BigInteger)((X509DhParameters)this.algorithm.getParameters()).getP().getValue().getValue();
                return new DhPublicKey(publicKey, generator, modulus);
            }
            case DSA: {
                BigInteger Q = (BigInteger)((X509DssParameters)this.algorithm.getParameters()).getQ().getValue().getValue();
                BigInteger X = (BigInteger)((X509DsaPublicKey)content).getValue().getValue();
                BigInteger generator = (BigInteger)((X509DssParameters)this.algorithm.getParameters()).getG().getValue().getValue();
                BigInteger modulus = (BigInteger)((X509DssParameters)this.algorithm.getParameters()).getP().getValue().getValue();
                return new DsaPublicKey(Q, X, generator, modulus);
            }
            case ECDH_ECDSA: {
                BigInteger xCoordinate = (BigInteger)((X509EcdhEcdsaPublicKey)content).getxCoordinate().getValue();
                BigInteger yCoordinate = (BigInteger)((X509EcdhEcdsaPublicKey)content).getyCoordinate().getValue();
                NamedEllipticCurveParameters parameters = X509NamedCurve.decodeFromOidBytes(((X509EcNamedCurveParameters)this.algorithm.getParameters()).getValueAsOid().getEncoded()).getParameters();
                return new EcdsaPublicKey(parameters.getGroup().getPoint(xCoordinate, yCoordinate), parameters);
            }
            case ECDH_ONLY: {
                BigInteger xCoordinate = (BigInteger)((X509EcdhPublicKey)content).getxCoordinate().getValue();
                BigInteger yCoordinate = (BigInteger)((X509EcdhPublicKey)content).getyCoordinate().getValue();
                NamedEllipticCurveParameters parameters = X509NamedCurve.decodeFromOidBytes(((X509EcNamedCurveParameters)this.algorithm.getParameters()).getValueAsOid().getEncoded()).getParameters();
                return new EcdhPublicKey(parameters.getGroup().getPoint(xCoordinate, yCoordinate), parameters);
            }
            case RSA: {
                BigInteger modulus = (BigInteger)((X509RsaPublicKey)content).getModulus().getValue().getValue();
                BigInteger publicExponent = (BigInteger)((X509RsaPublicKey)content).getPublicExponent().getValue().getValue();
                return new RsaPublicKey(publicExponent, modulus);
            }
        }
        throw new UnsupportedOperationException("PublicKeyContainer " + String.valueOf((Object)certificateKeyType) + " not yet implemented");
    }
}

