/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.model;

import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.integer.IntegerExplicitValueModification;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.protocol.xml.Pair;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.DirectoryStringChoiceType;
import de.rub.nds.x509attacker.constants.NameType;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import de.rub.nds.x509attacker.x509.handler.TbsCertificateHandler;
import de.rub.nds.x509attacker.x509.handler.X509Handler;
import de.rub.nds.x509attacker.x509.model.CertificateSignatureAlgorithmIdentifier;
import de.rub.nds.x509attacker.x509.model.Extensions;
import de.rub.nds.x509attacker.x509.model.Name;
import de.rub.nds.x509attacker.x509.model.SubjectPublicKeyInfo;
import de.rub.nds.x509attacker.x509.model.Validity;
import de.rub.nds.x509attacker.x509.model.Version;
import de.rub.nds.x509attacker.x509.model.X509Component;
import de.rub.nds.x509attacker.x509.model.X509Explicit;
import de.rub.nds.x509attacker.x509.parser.TbsCertificateParser;
import de.rub.nds.x509attacker.x509.parser.X509Parser;
import de.rub.nds.x509attacker.x509.preparator.TbsCertificatePreparator;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TbsCertificate
extends Asn1Sequence
implements X509Component {
    @HoldsModifiableVariable
    private X509Explicit<Version> version;
    @HoldsModifiableVariable
    private Asn1Integer serialNumber;
    @HoldsModifiableVariable
    private CertificateSignatureAlgorithmIdentifier signature;
    @HoldsModifiableVariable
    private Name issuer;
    @HoldsModifiableVariable
    private Validity validity;
    @HoldsModifiableVariable
    private Name subject;
    @HoldsModifiableVariable
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    @HoldsModifiableVariable
    private Asn1BitString issuerUniqueId;
    @HoldsModifiableVariable
    private Asn1BitString subjectUniqueId;
    @HoldsModifiableVariable
    private X509Explicit<Extensions> explicitExtensions;

    private TbsCertificate() {
        super(null);
    }

    public TbsCertificate(String identifier, X509CertificateConfig config) {
        super(identifier);
        this.version = new X509Explicit<Version>("versionExplicit", 0, new Version("version"));
        this.version.setOptional(true);
        this.setContextSpecificTagNumber((Asn1Field)this.version, 0);
        if (config.isIncludeSerialNumber()) {
            this.serialNumber = new Asn1Integer("serialNumber");
        }
        this.signature = new CertificateSignatureAlgorithmIdentifier("signature");
        this.issuer = new Name("issuer", NameType.ISSUER, config.getDefaultIssuer(), config.getDefaultDirectoryStringType(), config.getDivergentIssuerDirectoryStringChoices());
        if (config.isIncludeValidity()) {
            this.validity = new Validity("validity", config);
        }
        this.subject = new Name("subject", NameType.SUBJECT, config.getSubject(), config.getDefaultDirectoryStringType(), new ArrayList<Pair<X500AttributeType, DirectoryStringChoiceType>>());
        if (config.isIncludeSubjectPublicKeyInfo()) {
            this.subjectPublicKeyInfo = new SubjectPublicKeyInfo("subjectPublicKeyInfo", config);
        }
        if (config.isIncludeIssuerUniqueId()) {
            this.issuerUniqueId = new Asn1BitString("issuerUniqueID", 1);
            this.issuerUniqueId.setOptional(true);
            this.setContextSpecificTagNumber((Asn1Field)this.issuerUniqueId, 1);
        }
        if (config.isIncludeSubjectUniqueId()) {
            this.subjectUniqueId = new Asn1BitString("subjectUniqueID", 2);
            this.subjectUniqueId.setOptional(true);
            this.setContextSpecificTagNumber((Asn1Field)this.subjectUniqueId, 2);
        }
        if (config.isIncludeExtensions()) {
            this.explicitExtensions = new X509Explicit<Extensions>("extensionsExplicit", 3, new Extensions("extensions"));
            this.explicitExtensions.setOptional(true);
            this.setContextSpecificTagNumber((Asn1Field)this.explicitExtensions, 3);
        }
    }

    public TbsCertificate(String identifier) {
        super(identifier);
        this.version = new X509Explicit<Version>("versionExplicit", 0, new Version("version"));
        this.version.setOptional(true);
        this.setContextSpecificTagNumber((Asn1Field)this.version, 0);
        this.serialNumber = new Asn1Integer("serialNumber");
        this.signature = new CertificateSignatureAlgorithmIdentifier("signature");
        this.issuer = new Name("issuer", NameType.ISSUER);
        this.validity = new Validity("validity");
        this.subject = new Name("subject", NameType.SUBJECT);
        this.subjectPublicKeyInfo = new SubjectPublicKeyInfo("subjectPublicKeyInfo");
        this.issuerUniqueId = new Asn1BitString("issuerUniqueID", 1);
        this.issuerUniqueId.setOptional(true);
        this.setContextSpecificTagNumber((Asn1Field)this.issuerUniqueId, 1);
        this.subjectUniqueId = new Asn1BitString("subjectUniqueID", 2);
        this.subjectUniqueId.setOptional(true);
        this.setContextSpecificTagNumber((Asn1Field)this.subjectUniqueId, 2);
        this.explicitExtensions = new X509Explicit<Extensions>("extensionsExplicit", 3, new Extensions("extensions"));
        this.explicitExtensions.setOptional(true);
        this.setContextSpecificTagNumber((Asn1Field)this.explicitExtensions, 3);
    }

    private void setContextSpecificTagNumber(Asn1Field field, int tagClass) {
        field.setTagNumber(ModifiableVariableFactory.safelySetValue((ModifiableInteger)field.getTagClass(), (Integer)0));
        field.getTagNumber().setModifications(new VariableModification[]{new IntegerExplicitValueModification(tagClass)});
    }

    public Asn1Integer getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(Asn1Integer serialNumber) {
        this.serialNumber = serialNumber;
    }

    public CertificateSignatureAlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public void setSignature(CertificateSignatureAlgorithmIdentifier signature) {
        this.signature = signature;
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Name issuer) {
        this.issuer = issuer;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public void setValidity(Validity validity) {
        this.validity = validity;
    }

    public Name getSubject() {
        return this.subject;
    }

    public void setSubject(Name subject) {
        this.subject = subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public Asn1BitString getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public void setIssuerUniqueId(Asn1BitString issuerUniqueID) {
        this.issuerUniqueId = issuerUniqueID;
    }

    public Asn1BitString getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public void setSubjectUniqueId(Asn1BitString subjectUniqueID) {
        this.subjectUniqueId = subjectUniqueID;
    }

    public X509Explicit<Extensions> getExplicitExtensions() {
        return this.explicitExtensions;
    }

    public void setExplicitExtensions(X509Explicit<Extensions> explicitExtensions) {
        this.explicitExtensions = explicitExtensions;
    }

    @Override
    public X509Handler getHandler(X509Chooser chooser) {
        return new TbsCertificateHandler(chooser, this);
    }

    @Override
    public X509Parser getParser(X509Chooser chooser) {
        return new TbsCertificateParser(chooser, this);
    }

    @Override
    public X509Preparator getPreparator(X509Chooser chooser) {
        return new TbsCertificatePreparator(chooser, this);
    }

    public X509Explicit<Version> getVersion() {
        return this.version;
    }

    public void setVersion(X509Explicit<Version> version) {
        this.version = version;
    }
}

