/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.model;

import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Sequence;
import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.protocol.crypto.hash.HashCalculator;
import de.rub.nds.protocol.crypto.key.EcdhPublicKey;
import de.rub.nds.protocol.crypto.key.EcdsaPublicKey;
import de.rub.nds.protocol.crypto.key.EddsaPublicKey;
import de.rub.nds.protocol.crypto.key.PublicKeyContainer;
import de.rub.nds.protocol.crypto.signature.SignatureComputations;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.ExtendedKeyUsageType;
import de.rub.nds.x509attacker.constants.KeyUsage;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.constants.X509SignatureAlgorithm;
import de.rub.nds.x509attacker.constants.X509Version;
import de.rub.nds.x509attacker.context.X509Context;
import de.rub.nds.x509attacker.x509.handler.X509CertificateHandler;
import de.rub.nds.x509attacker.x509.handler.X509Handler;
import de.rub.nds.x509attacker.x509.model.AttributeTypeAndValue;
import de.rub.nds.x509attacker.x509.model.CertificateSignatureAlgorithmIdentifier;
import de.rub.nds.x509attacker.x509.model.RelativeDistinguishedName;
import de.rub.nds.x509attacker.x509.model.SubjectPublicKeyInfo;
import de.rub.nds.x509attacker.x509.model.TbsCertificate;
import de.rub.nds.x509attacker.x509.model.Version;
import de.rub.nds.x509attacker.x509.model.X509Component;
import de.rub.nds.x509attacker.x509.model.publickey.PublicKeyBitString;
import de.rub.nds.x509attacker.x509.model.publickey.PublicKeyContent;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.PublicParameters;
import de.rub.nds.x509attacker.x509.parser.X509CertificateParser;
import de.rub.nds.x509attacker.x509.parser.X509Parser;
import de.rub.nds.x509attacker.x509.preparator.X509CertificatePreparator;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class X509Certificate
extends Asn1Sequence
implements X509Component {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final X509SignatureAlgorithm[] WEAK_SIGNATURE_ALGORITHMS = new X509SignatureAlgorithm[]{X509SignatureAlgorithm.DSA_WITH_SHA1, X509SignatureAlgorithm.ECDSA_WITH_SHA1, X509SignatureAlgorithm.MD2_WITH_RSA_ENCRYPTION, X509SignatureAlgorithm.MD5_WITH_RSA_ENCRYPTION, X509SignatureAlgorithm.MD4_WITH_RSA_ENCRYPTION, X509SignatureAlgorithm.SHA1_WITH_RSA_ENCRYPTION};
    @HoldsModifiableVariable
    private TbsCertificate tbsCertificate;
    @HoldsModifiableVariable
    private CertificateSignatureAlgorithmIdentifier signatureAlgorithmIdentifier;
    @HoldsModifiableVariable
    private Asn1BitString signature;
    @HoldsModifiableVariable
    private SignatureComputations signatureComputations;

    public X509Certificate(String identifier, X509CertificateConfig certificateConfig) {
        super(identifier);
        this.tbsCertificate = new TbsCertificate("tbsCertificate", certificateConfig);
        this.signatureAlgorithmIdentifier = new CertificateSignatureAlgorithmIdentifier("signatureAlgorithm");
        this.signature = new Asn1BitString("signature");
    }

    public X509Certificate(String identifier) {
        super(identifier);
        this.tbsCertificate = new TbsCertificate("tbsCertificate");
        this.signatureAlgorithmIdentifier = new CertificateSignatureAlgorithmIdentifier("signatureAlgorithm");
        this.signature = new Asn1BitString("signature");
    }

    private X509Certificate() {
        super(null);
    }

    public TbsCertificate getTbsCertificate() {
        return this.tbsCertificate;
    }

    public void setTbsCertificate(TbsCertificate tbsCertificate) {
        this.tbsCertificate = tbsCertificate;
    }

    public CertificateSignatureAlgorithmIdentifier getSignatureAlgorithmIdentifier() {
        return this.signatureAlgorithmIdentifier;
    }

    public void setSignatureAlgorithmIdentifier(CertificateSignatureAlgorithmIdentifier signatureAlgorithm) {
        this.signatureAlgorithmIdentifier = signatureAlgorithm;
    }

    public Asn1BitString getSignature() {
        return this.signature;
    }

    public void setSignature(Asn1BitString signature) {
        this.signature = signature;
    }

    public byte[] getSha256Fingerprint() {
        return HashCalculator.compute((byte[])this.getSerializer(new X509Chooser(new X509CertificateConfig(), new X509Context())).serialize(), (HashAlgorithm)HashAlgorithm.SHA256);
    }

    public X509PublicKeyType getCertificateKeyType() {
        return this.getPublicKey().getX509PublicKeyType();
    }

    public NamedEllipticCurveParameters getEllipticCurve() {
        PublicKeyContainer publicKeyContainer = this.getPublicKeyContainer();
        if (publicKeyContainer instanceof EcdsaPublicKey) {
            return ((EcdsaPublicKey)publicKeyContainer).getParameters();
        }
        if (publicKeyContainer instanceof EcdhPublicKey) {
            return ((EcdhPublicKey)publicKeyContainer).getParameters();
        }
        if (publicKeyContainer instanceof EddsaPublicKey) {
            return ((EddsaPublicKey)publicKeyContainer).getParameters();
        }
        LOGGER.warn("X.509 Certificate does not contain an EC PublicKey. Returning null.");
        return null;
    }

    public PublicKeyContent getPublicKey() {
        Optional<TbsCertificate> optionalTbs = Optional.ofNullable(this.getTbsCertificate());
        Optional<SubjectPublicKeyInfo> optionalPublicKeyType = optionalTbs.map(TbsCertificate::getSubjectPublicKeyInfo);
        Optional<PublicKeyBitString> publicKeyString = optionalPublicKeyType.map(SubjectPublicKeyInfo::getSubjectPublicKeyBitString);
        Optional<PublicKeyContent> publicKeyContentOptional = publicKeyString.map(PublicKeyBitString::getX509PublicKeyContent);
        return publicKeyContentOptional.get();
    }

    public PublicParameters getPublicParameters() {
        return this.getTbsCertificate().getSubjectPublicKeyInfo().getAlgorithm().getParameters();
    }

    public PublicKeyContainer getPublicKeyContainer() {
        Optional<TbsCertificate> optionalTbs = Optional.ofNullable(this.getTbsCertificate());
        return optionalTbs.map(TbsCertificate::getSubjectPublicKeyInfo).get().getPublicKeyContainer();
    }

    public DateTime getNotBefore() {
        return this.tbsCertificate.getValidity().getNotBefore().getTimeValue();
    }

    public DateTime getNotAfter() {
        return this.tbsCertificate.getValidity().getNotAfter().getTimeValue();
    }

    public Boolean isExpired() {
        return this.getNotAfter().isBeforeNow();
    }

    public Boolean isYetValid() {
        return this.getNotBefore().isBeforeNow();
    }

    public Boolean isRevokedCrl() {
        throw new UnsupportedOperationException("isRevokedCrl not implemented yet");
    }

    public Boolean isRevokedOcsp() {
        throw new UnsupportedOperationException("isRevokedOcsp not implemented yet");
    }

    public HashAlgorithm getHashAlgorithm() {
        ObjectIdentifier oid = new ObjectIdentifier((String)this.getSignatureAlgorithmIdentifier().getAlgorithm().getValue().getValue());
        return X509SignatureAlgorithm.decodeFromOidBytes(oid.getEncoded()).getHashAlgorithm();
    }

    public Boolean hasWeakBlacklistedDebianKey() {
        throw new UnsupportedOperationException("hasWeakBlacklistedDebianKey not implemented yet");
    }

    public Boolean isLeaf() {
        String commonName = this.getSubjectCommonName();
        return commonName != null && this.isIpOrDomain(commonName);
    }

    private boolean isIpOrDomain(String input) {
        try {
            InetAddress.getByName(input);
            return true;
        }
        catch (UnknownHostException e) {
            try {
                InetAddress.getAllByName(input);
                return true;
            }
            catch (UnknownHostException e2) {
                return false;
            }
        }
    }

    public Boolean isValidLeafForUri(String uri) {
        if (this.isLeaf().booleanValue()) {
            return this.isCommonNameValidForUri(uri);
        }
        return false;
    }

    public boolean isCommonNameValidForUri(String uri) {
        String commonName = this.getSubjectCommonName();
        if (commonName.startsWith("*.")) {
            String suffix = commonName.substring(2);
            return uri.endsWith(suffix);
        }
        return uri.equals(commonName);
    }

    public boolean isSanValidForUri(String uri) {
        List<String> subjectAlternativeNames = this.getSubjectAlternativeNames();
        for (String name : subjectAlternativeNames) {
            String suffix;
            if (!(name.startsWith("*.") ? uri.endsWith(suffix = name.substring(2)) : uri.equals(name))) continue;
            return true;
        }
        return false;
    }

    public String getSubjectCommonName() {
        for (RelativeDistinguishedName relativeDistinguishedName : this.getTbsCertificate().getSubject().getRelativeDistinguishedNames()) {
            for (AttributeTypeAndValue attributeTypeAndValue : relativeDistinguishedName.getAttributeTypeAndValueList()) {
                if (attributeTypeAndValue.getX500AttributeTypeFromValue() != X500AttributeType.COMMON_NAME) continue;
                return attributeTypeAndValue.getStringValueOfValue();
            }
        }
        return null;
    }

    public String getIssuerCommonName() {
        for (RelativeDistinguishedName relativeDistinguishedName : this.getTbsCertificate().getIssuer().getRelativeDistinguishedNames()) {
            for (AttributeTypeAndValue attributeTypeAndValue : relativeDistinguishedName.getAttributeTypeAndValueList()) {
                if (attributeTypeAndValue.getX500AttributeTypeFromValue() != X500AttributeType.COMMON_NAME) continue;
                return attributeTypeAndValue.getStringValueOfValue();
            }
        }
        return null;
    }

    public List<String> getSubjectAlternativeNames() {
        throw new UnsupportedOperationException("getSubjectAlternativeNames not implemented yet");
    }

    public Boolean hasSanExtension() {
        throw new UnsupportedOperationException("hasSanExtension not implemented yet");
    }

    public Boolean hasExtendedKeyUsageExtension() {
        throw new UnsupportedOperationException("hasExtendedKeyUsageExtension not implemented yet");
    }

    public Boolean hasSignedCertificateTransparencyEntry() {
        throw new UnsupportedOperationException("hasSignedCertificateTransparencyEntry not implemented yet");
    }

    public Boolean hasOcsp() {
        throw new UnsupportedOperationException("hasOcsp not implemented yet");
    }

    public Boolean hasCertificateRevocationList() {
        throw new UnsupportedOperationException("hasCertificateRevocationList not implemented yet");
    }

    public Boolean isOcspMustStaple() {
        throw new UnsupportedOperationException("isOcspMustStaple not implemented yet");
    }

    public Boolean isSelfSigned() {
        return this.getIssuerString().equals(this.getSubjectString());
    }

    private String getRdnString(List<RelativeDistinguishedName> relativeDistinguishedNames) {
        StringBuilder builder = new StringBuilder();
        for (RelativeDistinguishedName relativeDistinguishedName : relativeDistinguishedNames) {
            for (AttributeTypeAndValue attributeTypeAndValue : relativeDistinguishedName.getAttributeTypeAndValueList()) {
                builder.append(attributeTypeAndValue.getStringRepresentation());
                builder.append(" ");
            }
        }
        return builder.toString();
    }

    public String getSubjectString() {
        return this.getRdnString(this.getTbsCertificate().getSubject().getRelativeDistinguishedNames()).trim();
    }

    public String getIssuerString() {
        return this.getRdnString(this.getTbsCertificate().getIssuer().getRelativeDistinguishedNames()).trim();
    }

    public X509Version getX509Version() {
        return ((Version)this.tbsCertificate.getVersion().getInnerField()).getVersion();
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        ObjectIdentifier oid = new ObjectIdentifier((String)this.getSignatureAlgorithmIdentifier().getAlgorithm().getValue().getValue());
        return X509SignatureAlgorithm.decodeFromOidBytes(oid.getEncoded()).getSignatureAlgorithm();
    }

    public X509SignatureAlgorithm getX509SignatureAlgorithm() {
        ObjectIdentifier oid = new ObjectIdentifier((String)this.getSignatureAlgorithmIdentifier().getAlgorithm().getValue().getValue());
        return X509SignatureAlgorithm.decodeFromOidBytes(oid.getEncoded());
    }

    public ObjectIdentifier getX509SignatureAlgorithmObjectIdentifier() {
        return new ObjectIdentifier((String)this.getSignatureAlgorithmIdentifier().getAlgorithm().getValue().getValue());
    }

    public List<KeyUsage> getKeyUsages() {
        throw new UnsupportedOperationException("getKeyUsages not implemented yet");
    }

    public List<ExtendedKeyUsageType> getExtendedKeyUsages() {
        throw new UnsupportedOperationException("getExtendedKeyUsages not implemented yet");
    }

    public SignatureComputations getSignatureComputations() {
        return this.signatureComputations;
    }

    public void setSignatureComputations(SignatureComputations signatureComputations) {
        this.signatureComputations = signatureComputations;
    }

    public byte[] getAkid() {
        throw new UnsupportedOperationException("getAkid not implemented yet");
    }

    public byte[] getSkid() {
        throw new UnsupportedOperationException("getSkid not implemented yet");
    }

    public int hashCode() {
        return Arrays.hashCode(this.getSha256Fingerprint());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509Certificate other = (X509Certificate)obj;
        return Arrays.equals(this.getSha256Fingerprint(), other.getSha256Fingerprint());
    }

    @Override
    public X509Handler getHandler(X509Chooser chooser) {
        return new X509CertificateHandler(chooser, this);
    }

    @Override
    public X509Parser getParser(X509Chooser chooser) {
        return new X509CertificateParser(chooser, this);
    }

    @Override
    public X509Preparator getPreparator(X509Chooser chooser) {
        return new X509CertificatePreparator(chooser, this);
    }

    public boolean isWeakSignature() {
        for (X509SignatureAlgorithm algorithm : WEAK_SIGNATURE_ALGORITHMS) {
            if (algorithm != this.getX509SignatureAlgorithm()) continue;
            return true;
        }
        return false;
    }

    public Boolean isSignatureValid() {
        return this.signatureComputations.getSignatureValid();
    }
}

