/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.model.extensions;

import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.model.Asn1OctetString;
import de.rub.nds.asn1.model.Asn1UnknownSequence;
import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.config.extension.AuthorityKeyIdentifierConfig;
import de.rub.nds.x509attacker.x509.handler.X509Handler;
import de.rub.nds.x509attacker.x509.handler.extension.AuthorityKeyIdentifierHandler;
import de.rub.nds.x509attacker.x509.model.Extension;
import de.rub.nds.x509attacker.x509.model.extensions.GeneralNames;
import de.rub.nds.x509attacker.x509.parser.X509Parser;
import de.rub.nds.x509attacker.x509.parser.extension.AuthorityKeyIdentifierParser;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;
import de.rub.nds.x509attacker.x509.preparator.extension.AuthorityKeyIdentifierPreparator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AuthorityKeyIdentifier
extends Extension<AuthorityKeyIdentifierConfig> {
    @HoldsModifiableVariable
    private Asn1UnknownSequence wrappingSequence;
    @HoldsModifiableVariable
    private Asn1OctetString keyIdentifier;
    @HoldsModifiableVariable
    private GeneralNames authorityCertIssuer;
    @HoldsModifiableVariable
    private Asn1Integer authorityCertSerialNumber;

    private AuthorityKeyIdentifier() {
        super(null);
    }

    public AuthorityKeyIdentifier(String identifier) {
        super(identifier);
        this.keyIdentifier = new Asn1OctetString("keyIdentifier");
        this.authorityCertIssuer = new GeneralNames("authorityCertIssuer");
        this.authorityCertSerialNumber = new Asn1Integer("authorityCertSerialNumber");
        this.wrappingSequence = new Asn1UnknownSequence("wrappingSequence");
    }

    public Asn1OctetString getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyIdentifier(Asn1OctetString keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.authorityCertIssuer;
    }

    public void setAuthorityCertIssuer(GeneralNames authorityCertIssuer) {
        this.authorityCertIssuer = authorityCertIssuer;
    }

    public Asn1Integer getAuthorityCertSerialNumber() {
        return this.authorityCertSerialNumber;
    }

    public void setAuthorityCertSerialNumber(Asn1Integer authorityCertSerialNumber) {
        this.authorityCertSerialNumber = authorityCertSerialNumber;
    }

    public Asn1UnknownSequence getWrappingSequence() {
        return this.wrappingSequence;
    }

    public void setWrappingSequence(Asn1UnknownSequence wrappingSequence) {
        this.wrappingSequence = wrappingSequence;
    }

    @Override
    public X509Handler getHandler(X509Chooser chooser) {
        return new AuthorityKeyIdentifierHandler(chooser, this);
    }

    @Override
    public X509Parser getParser(X509Chooser chooser) {
        return new AuthorityKeyIdentifierParser(chooser, this);
    }

    @Override
    public X509Preparator getPreparator(X509Chooser chooser, AuthorityKeyIdentifierConfig config) {
        return new AuthorityKeyIdentifierPreparator(chooser, this, config);
    }
}

