/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.model.publickey;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.biginteger.ModifiableBigInteger;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.constants.PointFormat;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.protocol.crypto.key.EcdhPublicKey;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.X509NamedCurve;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.x509.model.publickey.PublicKeyContent;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.math.BigInteger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class X509EcdhEcdsaPublicKey
implements PublicKeyContent {
    private ModifiableBigInteger xCoordinate;
    private ModifiableBigInteger yCoordinate;
    private ModifiableByteArray encodedPointBytes;

    public ModifiableBigInteger getxCoordinate() {
        return this.xCoordinate;
    }

    public void setxCoordinate(ModifiableBigInteger xCoordinate) {
        this.xCoordinate = xCoordinate;
    }

    public void setxCoordinate(BigInteger xCoordinate) {
        this.xCoordinate = ModifiableVariableFactory.safelySetValue((ModifiableBigInteger)this.xCoordinate, (BigInteger)xCoordinate);
    }

    public ModifiableBigInteger getyCoordinate() {
        return this.yCoordinate;
    }

    public void setyCoordinate(ModifiableBigInteger yCoordinate) {
        this.yCoordinate = yCoordinate;
    }

    public void setyCoordinate(BigInteger yCoordinate) {
        this.yCoordinate = ModifiableVariableFactory.safelySetValue((ModifiableBigInteger)this.yCoordinate, (BigInteger)yCoordinate);
    }

    public ModifiableByteArray getEncodedPointBytes() {
        return this.encodedPointBytes;
    }

    public void setEncodedPointBytes(ModifiableByteArray encodedPointBytes) {
        this.encodedPointBytes = encodedPointBytes;
    }

    public void setEncodedPointBytes(byte[] encodedPointBytes) {
        this.encodedPointBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.encodedPointBytes, (byte[])encodedPointBytes);
    }

    @Override
    public X509PublicKeyType getX509PublicKeyType() {
        return X509PublicKeyType.ECDH_ECDSA;
    }

    @Override
    public void prepare(X509Chooser chooser) {
        X509NamedCurve namedCurve = chooser.getConfig().getDefaultSubjectNamedCurve();
        Point publicKey = namedCurve.getParameters().getGroup().nTimesGroupOperationOnGenerator(chooser.getConfig().getDefaultSubjectEcPrivateKey());
        this.setxCoordinate(publicKey.getFieldX().getData());
        this.setyCoordinate(publicKey.getFieldY().getData());
        EcdhPublicKey ecdhPublicKey = new EcdhPublicKey((BigInteger)this.getxCoordinate().getValue(), (BigInteger)this.getyCoordinate().getValue(), chooser.getConfig().getDefaultSubjectNamedCurve().getParameters());
        this.setEncodedPointBytes(PointFormatter.formatToByteArray((GroupParameters)chooser.getConfig().getDefaultSubjectNamedCurve().getParameters(), (Point)ecdhPublicKey.getPublicPoint(), (PointFormat)chooser.getConfig().getDefaultEcPointFormat()));
    }

    @Override
    public byte[] getEncoded(X509Chooser chooser) {
        return (byte[])this.getEncodedPointBytes().getValue();
    }

    @Override
    public void adjustInContext(X509Chooser chooser) {
        chooser.getContext().setSubjectEcPublicKey(PointFormatter.formatFromByteArray((GroupParameters)chooser.getSubjectNamedCurve().getParameters(), (byte[])((byte[])this.getEncodedPointBytes().getValue())));
    }

    @Override
    public void readIn(X509Chooser chooser, byte[] bytesToRead) {
        this.setEncodedPointBytes(bytesToRead);
        Point publicKeyPoint = PointFormatter.formatFromByteArray((GroupParameters)chooser.getSubjectNamedCurve().getParameters(), (byte[])bytesToRead);
        this.setxCoordinate(publicKeyPoint.getFieldX().getData());
        this.setyCoordinate(publicKeyPoint.getFieldY().getData());
    }
}

