/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.constants.UniversalTagNumber;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.X509SignatureAlgorithm;
import de.rub.nds.x509attacker.x509.model.CertificateSignatureAlgorithmIdentifier;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509NullParameters;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateSignatureAlgorithmIdentifierParser
extends X509ComponentContainerParser<CertificateSignatureAlgorithmIdentifier> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateSignatureAlgorithmIdentifierParser(X509Chooser chooser, CertificateSignatureAlgorithmIdentifier algorithmIdentifier) {
        super(chooser, algorithmIdentifier);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing CertificateSignatureAlgorithmIdentifier");
        ParserHelper.parseAsn1ObjectIdentifier((Asn1ObjectIdentifier)((CertificateSignatureAlgorithmIdentifier)this.encodable).getAlgorithm(), (BufferedInputStream)inputStream);
        X509SignatureAlgorithm signatureAlgorithm = X509SignatureAlgorithm.decodeFromOidBytes(((CertificateSignatureAlgorithmIdentifier)this.encodable).getAlgorithm().getValueAsOid().getEncoded());
        LOGGER.debug("Parsed Oid: {} ({})", ((CertificateSignatureAlgorithmIdentifier)this.encodable).getAlgorithm().getValue().getValue(), (Object)(signatureAlgorithm != null ? signatureAlgorithm.name() : "unknown"));
        if (signatureAlgorithm == null) {
            LOGGER.debug("Unkown signature algorithm. Not parsing anything");
            return;
        }
        switch (signatureAlgorithm) {
            case DSA_WITH_SHA1: 
            case DSA_WITH_SHA224: 
            case DSA_WITH_SHA256: 
            case DSA_WITH_SHA384: 
            case DSA_WITH_SHA512: {
                LOGGER.debug("{} has no parameters. Not parsing any.", (Object)signatureAlgorithm.name());
                break;
            }
            case ECDSA_WITH_SHA1: 
            case ECDSA_WITH_SHA224: 
            case ECDSA_WITH_SHA256: 
            case ECDSA_WITH_SHA384: 
            case ECDSA_WITH_SHA512: {
                if (!ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.UNIVERSAL, (int)UniversalTagNumber.NULL.getIntValue())) break;
                LOGGER.debug("{} seems to have X509NullParameters. Parsing X509NullParameters", (Object)signatureAlgorithm.name());
                X509NullParameters nullParameters = new X509NullParameters("nullParameters");
                ((CertificateSignatureAlgorithmIdentifier)this.encodable).setParameters(nullParameters);
                nullParameters.getParser(this.chooser).parse(inputStream);
                nullParameters.getHandler(this.chooser).adjustContextAfterParse();
                break;
            }
            case MD2_WITH_RSA_ENCRYPTION: 
            case MD4_WITH_RSA_ENCRYPTION: 
            case MD5_WITH_RSA_ENCRYPTION: 
            case SHA1_WITH_RSA_ENCRYPTION: 
            case SHA224_WITH_RSA_ENCRYPTION: 
            case SHA256_WITH_RSA_ENCRYPTION: 
            case SHA384_WITH_RSA_ENCRYPTION: 
            case SHA512_WITH_RSA_ENCRYPTION: {
                X509NullParameters nullParameters = new X509NullParameters("nullParameters");
                ((CertificateSignatureAlgorithmIdentifier)this.encodable).setParameters(nullParameters);
                nullParameters.getParser(this.chooser).parse(inputStream);
                nullParameters.getHandler(this.chooser).adjustContextAfterParse();
                LOGGER.debug("{} must have X509NullParameters. Parsed X509NullParameters", (Object)signatureAlgorithm.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Encountered unknown signature algorithm: %s", signatureAlgorithm.name()));
            }
        }
    }
}

