/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.X509ExtensionType;
import de.rub.nds.x509attacker.x509.model.Extension;
import de.rub.nds.x509attacker.x509.model.Extensions;
import de.rub.nds.x509attacker.x509.model.extensions.Unknown;
import de.rub.nds.x509attacker.x509.parser.X509Asn1ObjectIdentifierParser;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtensionsParser
extends X509ComponentContainerParser<Extensions> {
    private final Logger LOGGER = LogManager.getLogger();

    public ExtensionsParser(X509Chooser chooser, Extensions extensions) {
        super(chooser, extensions);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        this.LOGGER.debug("Parsing Extensions");
        try {
            while (inputStream.available() > 0) {
                this.LOGGER.debug("Parsing Extension");
                Extension extension = X509ExtensionType.decodeFromOidBytes(this.peekNextObjectIdentifier(inputStream).getEncoded()).generateExtension();
                extension.getParser(this.chooser).parse(inputStream);
                extension.getHandler(this.chooser).adjustContextAfterParse();
                ((Extensions)this.encodable).addExtension(extension);
            }
        }
        catch (IOException E) {
            throw new ParserException("IOException in RelativeDistinguishedNameParser", (Throwable)E);
        }
    }

    private ObjectIdentifier peekNextObjectIdentifier(BufferedInputStream inputStream) {
        try {
            Asn1ObjectIdentifier oid = new Asn1ObjectIdentifier("oid");
            inputStream.mark(inputStream.available());
            Unknown unknown = new Unknown("extension");
            ParserHelper.parseStructure((Asn1Field)unknown, (BufferedInputStream)inputStream);
            X509Asn1ObjectIdentifierParser oidParser = new X509Asn1ObjectIdentifierParser(this.chooser, oid);
            oidParser.parse(new BufferedInputStream(new ByteArrayInputStream(unknown.getContent().getOriginalValue())));
            inputStream.reset();
            return oid.getValueAsOid();
        }
        catch (IOException e) {
            throw new ParserException("Could not look ahead to next extension OID.");
        }
    }
}

