/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.X509PublicKeyType;
import de.rub.nds.x509attacker.x509.model.SubjectPublicKeyAlgorithmIdentifier;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.PublicParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DhParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509DssParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509EcNamedCurveParameters;
import de.rub.nds.x509attacker.x509.model.publickey.parameters.X509NullParameters;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubjectPublicKeyAlgorithmIdentifierParser
extends X509ComponentContainerParser<SubjectPublicKeyAlgorithmIdentifier> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SubjectPublicKeyAlgorithmIdentifierParser(X509Chooser chooser, SubjectPublicKeyAlgorithmIdentifier algorithmIdentifier) {
        super(chooser, algorithmIdentifier);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing SubjectPublicKeyAlgorithmIdentifier");
        ParserHelper.parseAsn1ObjectIdentifier((Asn1ObjectIdentifier)((SubjectPublicKeyAlgorithmIdentifier)this.encodable).getAlgorithm(), (BufferedInputStream)inputStream);
        X509PublicKeyType publicKeyType = X509PublicKeyType.decodeFromOidBytes(((SubjectPublicKeyAlgorithmIdentifier)this.encodable).getAlgorithm().getValueAsOid().getEncoded());
        LOGGER.debug("X509PublicKeyType: {} ({})", (Object)publicKeyType, (Object)(publicKeyType == null ? "unknown" : publicKeyType.name()));
        if (publicKeyType == null) {
            LOGGER.debug("Unknown public key type. Not parsing parameters");
            return;
        }
        PublicParameters parameters = switch (publicKeyType) {
            case X509PublicKeyType.ECDH_ECDSA -> new X509EcNamedCurveParameters("EcNamedCurveParameters");
            case X509PublicKeyType.DH -> new X509DhParameters("DhParameters");
            case X509PublicKeyType.DSA -> new X509DssParameters("DssParameters");
            case X509PublicKeyType.RSA -> new X509NullParameters("nullParameters");
            default -> throw new UnsupportedOperationException(String.format("Unknown SubjectPublicKeyAlgorithmIdentifier: %s", publicKeyType.name()));
        };
        LOGGER.debug("Expecting {}", (Object)parameters.getClass().getSimpleName());
        parameters.getParser(this.chooser).parse(inputStream);
        parameters.getHandler(this.chooser).adjustContextAfterParse();
        ((SubjectPublicKeyAlgorithmIdentifier)this.encodable).setParameters(parameters);
    }
}

