/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.TbsCertificate;
import de.rub.nds.x509attacker.x509.model.Version;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TbsCertificateParser
extends X509ComponentContainerParser<TbsCertificate> {
    private static final Logger LOGGER = LogManager.getLogger();

    public TbsCertificateParser(X509Chooser chooser, TbsCertificate tbsCertificate) {
        super(chooser, tbsCertificate);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        if (this.hasVersionField(inputStream)) {
            LOGGER.debug("Assuming Certificate has a Version field");
            this.parseVersion(inputStream);
        } else {
            ((TbsCertificate)this.encodable).setVersion(null);
        }
        this.parseSerialNumber(inputStream);
        this.parseSignatureInformation(inputStream);
        this.parseIssuer(inputStream);
        this.parseValidity(inputStream);
        this.parseSubject(inputStream);
        this.parseSubjectPublicKey(inputStream);
        if (this.hasIssuerUniqueId(inputStream)) {
            LOGGER.debug("Assuming Certificate has an IssuerUniqueID field");
            this.parseIssuerUniqueId(inputStream);
        } else {
            ((TbsCertificate)this.encodable).setIssuerUniqueId(null);
        }
        if (this.hasSubjectUniqueId(inputStream)) {
            LOGGER.debug("Assuming Certificate has a SubjectUniqueID field");
            this.parseSubjectUniqueId(inputStream);
        } else {
            ((TbsCertificate)this.encodable).setSubjectUniqueId(null);
        }
        if (this.hasExtensions(inputStream)) {
            LOGGER.debug("Assuming Certificate has an Extensions field");
            this.parseExtensions(inputStream);
        } else {
            ((TbsCertificate)this.encodable).setExplicitExtensions(null);
        }
    }

    private void parseExtensions(BufferedInputStream inputStream) {
        ((TbsCertificate)this.encodable).getExplicitExtensions().getParser(this.chooser).parse(inputStream);
        ((TbsCertificate)this.encodable).getExplicitExtensions().getHandler(this.chooser).adjustContextAfterParse();
        LOGGER.debug("Extensions are not yet visible in the TbsCertificate");
    }

    private void parseSubjectUniqueId(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1BitString((Asn1BitString)((TbsCertificate)this.encodable).getSubjectUniqueId(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed SubjectUniqueID: {}", ((TbsCertificate)this.encodable).getSubjectUniqueId().getUsedBits().getValue());
    }

    private void parseIssuerUniqueId(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1BitString((Asn1BitString)((TbsCertificate)this.encodable).getIssuerUniqueId(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed IssuerUniqueID: {}", ((TbsCertificate)this.encodable).getSubjectUniqueId().getUsedBits().getValue());
    }

    private boolean hasVersionField(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.CONTEXT_SPECIFIC, (int)0);
    }

    private boolean hasExtensions(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.CONTEXT_SPECIFIC, (int)3);
    }

    private boolean hasSubjectUniqueId(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.CONTEXT_SPECIFIC, (int)2);
    }

    private boolean hasIssuerUniqueId(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.CONTEXT_SPECIFIC, (int)1);
    }

    private void parseSubjectPublicKey(BufferedInputStream inputStream) {
        ((TbsCertificate)this.encodable).getSubjectPublicKeyInfo().getParser(this.chooser).parse(inputStream);
        ((TbsCertificate)this.encodable).getSubjectPublicKeyInfo().getHandler(this.chooser).adjustContextAfterParse();
    }

    private void parseSubject(BufferedInputStream inputStream) {
        ((TbsCertificate)this.encodable).getSubject().getParser(this.chooser).parse(inputStream);
        ((TbsCertificate)this.encodable).getSubject().getHandler(this.chooser).adjustContextAfterParse();
    }

    private void parseValidity(BufferedInputStream inputStream) {
        ((TbsCertificate)this.encodable).getValidity().getParser(this.chooser).parse(inputStream);
        ((TbsCertificate)this.encodable).getValidity().getHandler(this.chooser).adjustContextAfterParse();
    }

    private void parseIssuer(BufferedInputStream inputStream) {
        ((TbsCertificate)this.encodable).getIssuer().getParser(this.chooser).parse(inputStream);
        ((TbsCertificate)this.encodable).getIssuer().getHandler(this.chooser).adjustContextAfterParse();
    }

    private void parseSignatureInformation(BufferedInputStream inputStream) {
        ((TbsCertificate)this.encodable).getSignature().getParser(this.chooser).parse(inputStream);
        ((TbsCertificate)this.encodable).getSignature().getHandler(this.chooser).adjustContextAfterParse();
    }

    private void parseSerialNumber(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((TbsCertificate)this.encodable).getSerialNumber(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed SerialNumber: {}", (Object)((TbsCertificate)this.encodable).getSerialNumber().getValue());
    }

    private void parseVersion(BufferedInputStream inputStream) {
        ((TbsCertificate)this.encodable).getVersion().getParser(this.chooser).parse(inputStream);
        ((TbsCertificate)this.encodable).getVersion().getHandler(this.chooser).adjustContextAfterParse();
        LOGGER.debug("Parsed Version: {}", ((Version)((TbsCertificate)this.encodable).getVersion().getInnerField()).getValue().getValue());
    }
}

