/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser;

import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.X509Certificate;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509CertificateParser
extends X509ComponentContainerParser<X509Certificate> {
    private static final Logger LOGGER = LogManager.getLogger();

    public X509CertificateParser(X509Chooser chooser, X509Certificate x509Certificate) {
        super(chooser, x509Certificate);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing X509Certificate");
        this.parseTbsCertificate(inputStream);
        this.parseSignatureAlgorithmIdentifier(inputStream);
        this.parseSignature(inputStream);
    }

    private void parseSignature(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1BitString((Asn1BitString)((X509Certificate)this.encodable).getSignature(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed Signature: {}", ((X509Certificate)this.encodable).getSignature().getUsedBits().getValue());
    }

    private void parseSignatureAlgorithmIdentifier(BufferedInputStream inputStream) {
        ((X509Certificate)this.encodable).getSignatureAlgorithmIdentifier().getParser(this.chooser).parse(inputStream);
        ((X509Certificate)this.encodable).getSignatureAlgorithmIdentifier().getHandler(this.chooser).adjustContextAfterParse();
        LOGGER.debug("Parsed SignatureAlgorithmIdentifier: {}", ((X509Certificate)this.encodable).getSignatureAlgorithmIdentifier().getAlgorithm().getValue().getValue());
    }

    private void parseTbsCertificate(BufferedInputStream inputStream) {
        ((X509Certificate)this.encodable).getTbsCertificate().getParser(this.chooser).parse(inputStream);
        ((X509Certificate)this.encodable).getTbsCertificate().getHandler(this.chooser).adjustContextAfterParse();
        LOGGER.debug("Parsed TbsCertificate");
    }
}

