/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser.extension;

import de.rub.nds.asn1.constants.TagClass;
import de.rub.nds.asn1.model.Asn1Boolean;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.extensions.BasicConstraints;
import de.rub.nds.x509attacker.x509.parser.extension.ExtensionParser;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicConstraintsParser
extends ExtensionParser<BasicConstraints> {
    private static final Logger LOGGER = LogManager.getLogger();

    public BasicConstraintsParser(X509Chooser chooser, BasicConstraints basicConstraints) {
        super(chooser, basicConstraints);
    }

    @Override
    protected void parseExtensionContent(BufferedInputStream inputStream) {
        this.parseSequence(inputStream);
        BufferedInputStream contentStream = new BufferedInputStream(new ByteArrayInputStream((byte[])((BasicConstraints)this.encodable).getWrappingSequence().getContent().getValue()));
        if (this.hasCAField(contentStream)) {
            this.parseCA(contentStream);
        }
        if (this.hasPathLenConstraint(contentStream)) {
            this.parsePathLengthConstraint(contentStream);
            if (!((Boolean)((BasicConstraints)this.encodable).getCa().getValue().getValue()).booleanValue()) {
                LOGGER.debug("PathLenConstraint set on non-CA certificate!");
            }
        }
    }

    private void parseSequence(BufferedInputStream inputStream) {
        ParserHelper.parseStructure((Asn1Field)((BasicConstraints)this.encodable).getWrappingSequence(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed Basic Constraint Sequence: {}", (Object)((BasicConstraints)this.encodable).getWrappingSequence());
    }

    private void parseCA(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Boolean((Asn1Boolean)((BasicConstraints)this.encodable).getCa(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed Basic Constraint CA: {}", (Object)((BasicConstraints)this.encodable).getCa());
    }

    private void parsePathLengthConstraint(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((BasicConstraints)this.encodable).getPathLenConstraint(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed Basic Constraint Path Length: {}", (Object)((BasicConstraints)this.encodable).getPathLenConstraint());
    }

    private boolean hasCAField(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.UNIVERSAL, (int)1);
    }

    private boolean hasPathLenConstraint(BufferedInputStream inputStream) {
        return ParserHelper.canParse((BufferedInputStream)inputStream, (TagClass)TagClass.UNIVERSAL, (int)2);
    }
}

