/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.parser.publickey;

import de.rub.nds.asn1.model.Asn1Integer;
import de.rub.nds.asn1.parser.ParserHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.publickey.X509RsaPublicKey;
import de.rub.nds.x509attacker.x509.parser.X509ComponentContainerParser;
import java.io.BufferedInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class X509RsaPublicKeyParser
extends X509ComponentContainerParser<X509RsaPublicKey> {
    private static final Logger LOGGER = LogManager.getLogger();

    public X509RsaPublicKeyParser(X509Chooser chooser, X509RsaPublicKey rsaPublicKey) {
        super(chooser, rsaPublicKey);
    }

    @Override
    protected void parseSubcomponents(BufferedInputStream inputStream) {
        LOGGER.debug("Parsing X509RsaPublicKey");
        this.parseModulus(inputStream);
        this.parsePublicExponent(inputStream);
    }

    private void parseModulus(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509RsaPublicKey)this.encodable).getModulus(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed Modulus (N): {}", ((X509RsaPublicKey)this.encodable).getModulus().getValue().getValue());
    }

    private void parsePublicExponent(BufferedInputStream inputStream) {
        ParserHelper.parseAsn1Integer((Asn1Integer)((X509RsaPublicKey)this.encodable).getPublicExponent(), (BufferedInputStream)inputStream);
        LOGGER.debug("Parsed Public exponent (e): {}", ((X509RsaPublicKey)this.encodable).getPublicExponent().getValue().getValue());
    }
}

