/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.model.Asn1BmpString;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Ia5String;
import de.rub.nds.asn1.model.Asn1PrintableString;
import de.rub.nds.asn1.model.Asn1T61String;
import de.rub.nds.asn1.model.Asn1UniversalString;
import de.rub.nds.asn1.model.Asn1Utf8String;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.DirectoryStringChoiceType;
import de.rub.nds.x509attacker.x509.model.AttributeValueSet;
import de.rub.nds.x509attacker.x509.model.DirectoryString;
import de.rub.nds.x509attacker.x509.preparator.DirectoryStringPreparator;
import de.rub.nds.x509attacker.x509.preparator.X509ContainerPreparator;

public class AttributeValueSetPreparator
extends X509ContainerPreparator<AttributeValueSet> {
    public AttributeValueSetPreparator(X509Chooser chooser, AttributeValueSet attributeValueSet) {
        super(chooser, attributeValueSet);
    }

    @Override
    public void prepareSubComponents() {
        for (int i = 0; i < ((AttributeValueSet)this.field).getValues().size(); ++i) {
            this.prepareTypeValue(((AttributeValueSet)this.field).getValueHolders().get(i), ((AttributeValueSet)this.field).getValues().get(i));
        }
    }

    @Override
    public byte[] encodeChildrenContent() {
        return this.encodeChildren(((AttributeValueSet)this.field).getValueHolders());
    }

    public void prepareTypeValue(Asn1Encodable valueField, String value) {
        if (value == null && !(valueField instanceof DirectoryString)) {
            value = "";
        }
        if (valueField instanceof Asn1Utf8String) {
            Asn1PreparatorHelper.prepareField((Asn1Utf8String)((Asn1Utf8String)valueField), (String)value);
        } else if (valueField instanceof Asn1PrintableString) {
            Asn1PreparatorHelper.prepareField((Asn1PrintableString)((Asn1PrintableString)valueField), (String)value);
        } else if (valueField instanceof Asn1Ia5String) {
            Asn1PreparatorHelper.prepareField((Asn1Ia5String)((Asn1Ia5String)valueField), (String)value);
        } else if (valueField instanceof Asn1T61String) {
            Asn1PreparatorHelper.prepareField((Asn1T61String)((Asn1T61String)valueField), (String)value);
        } else if (valueField instanceof Asn1UniversalString) {
            Asn1PreparatorHelper.prepareField((Asn1UniversalString)((Asn1UniversalString)valueField), (String)value);
        } else if (valueField instanceof Asn1BmpString) {
            Asn1PreparatorHelper.prepareField((Asn1BmpString)((Asn1BmpString)valueField), (String)value);
        } else if (valueField instanceof DirectoryString) {
            this.prepareDirectoryString((DirectoryString)valueField);
        } else {
            throw new UnsupportedOperationException(String.format("AttributeTypeAndValue value type not supported yet: %s", valueField.getClass().getSimpleName()));
        }
    }

    private void prepareDirectoryString(DirectoryString directoryString) {
        if (directoryString.getSelectedChoice() instanceof Asn1Utf8String) {
            directoryString.setDirectoryStringChoiceType(DirectoryStringChoiceType.UTF8_STRING);
            directoryString.setConfigValue((String)((Asn1Utf8String)directoryString.getSelectedChoice()).getValue().getValue());
        } else if (directoryString.getSelectedChoice() instanceof Asn1PrintableString) {
            directoryString.setDirectoryStringChoiceType(DirectoryStringChoiceType.PRINTABLE_STRING);
            directoryString.setConfigValue((String)((Asn1PrintableString)directoryString.getSelectedChoice()).getValue().getValue());
        } else if (directoryString.getSelectedChoice() instanceof Asn1BmpString) {
            directoryString.setDirectoryStringChoiceType(DirectoryStringChoiceType.BMP_STRING);
            directoryString.setConfigValue((String)((Asn1BmpString)directoryString.getSelectedChoice()).getValue().getValue());
        } else if (directoryString.getSelectedChoice() instanceof Asn1UniversalString) {
            directoryString.setDirectoryStringChoiceType(DirectoryStringChoiceType.UNIVERSAL_STRING);
            directoryString.setConfigValue((String)((Asn1UniversalString)directoryString.getSelectedChoice()).getValue().getValue());
        } else {
            throw new UnsupportedOperationException("DirectoryString type not supported: " + directoryString.getSelectedChoice().getClass().getSimpleName());
        }
        new DirectoryStringPreparator(this.chooser, directoryString).prepare();
    }
}

