/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.model.Asn1BmpString;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1PrintableString;
import de.rub.nds.asn1.model.Asn1T61String;
import de.rub.nds.asn1.model.Asn1UniversalString;
import de.rub.nds.asn1.model.Asn1Utf8String;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.x509.model.DirectoryString;
import de.rub.nds.x509attacker.x509.preparator.X509Asn1FieldPreparator;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;

public class DirectoryStringPreparator
implements X509Preparator {
    private final X509Chooser chooser;
    private final DirectoryString directoryString;

    public DirectoryStringPreparator(X509Chooser chooser, DirectoryString directoryString) {
        this.chooser = chooser;
        this.directoryString = directoryString;
    }

    @Override
    public void prepare() {
        switch (this.directoryString.getDirectoryStringChoiceType()) {
            case BMP_STRING: {
                this.directoryString.makeSelection((Asn1Encodable)this.directoryString.getBmpString());
                this.directoryString.setConfigValue((String)this.directoryString.getBmpString().getValue().getValue());
                break;
            }
            case PRINTABLE_STRING: {
                this.directoryString.makeSelection((Asn1Encodable)this.directoryString.getPrintableString());
                this.directoryString.setConfigValue((String)this.directoryString.getPrintableString().getValue().getValue());
                break;
            }
            case TELETEX_STRING: {
                this.directoryString.makeSelection((Asn1Encodable)this.directoryString.getTeletexString());
                this.directoryString.setConfigValue((String)this.directoryString.getTeletexString().getValue().getValue());
                break;
            }
            case UNIVERSAL_STRING: {
                this.directoryString.makeSelection((Asn1Encodable)this.directoryString.getUniversalString());
                this.directoryString.setConfigValue((String)this.directoryString.getUniversalString().getValue().getValue());
                break;
            }
            case UTF8_STRING: {
                this.directoryString.makeSelection((Asn1Encodable)this.directoryString.getUtf8String());
                this.directoryString.setConfigValue((String)this.directoryString.getUtf8String().getValue().getValue());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unimplemented DirectoryStringChoiceType: " + String.valueOf((Object)this.directoryString.getDirectoryStringChoiceType()));
            }
        }
        HelperPreparator helper = new HelperPreparator(this, this.chooser, (Asn1Field)this.directoryString.getSelectedChoice(), this.directoryString.getConfigValue());
        helper.prepare();
    }

    private class HelperPreparator<T extends Asn1Field>
    extends X509Asn1FieldPreparator<T> {
        private String value;

        /*
         * WARNING - Possible parameter corruption
         */
        public HelperPreparator(X509Chooser chooser, T type, String value) {
            super(chooser, type);
            this.value = value;
        }

        protected byte[] encodeContent() {
            if (this.field instanceof Asn1BmpString) {
                Asn1PreparatorHelper.prepareField((Asn1BmpString)((Asn1BmpString)this.field), (String)this.value);
            } else if (this.field instanceof Asn1PrintableString) {
                Asn1PreparatorHelper.prepareField((Asn1PrintableString)((Asn1PrintableString)this.field), (String)this.value);
            } else if (this.field instanceof Asn1T61String) {
                Asn1PreparatorHelper.prepareField((Asn1T61String)((Asn1T61String)this.field), (String)this.value);
            } else if (this.field instanceof Asn1UniversalString) {
                Asn1PreparatorHelper.prepareField((Asn1UniversalString)((Asn1UniversalString)this.field), (String)this.value);
            } else if (this.field instanceof Asn1Utf8String) {
                Asn1PreparatorHelper.prepareField((Asn1Utf8String)((Asn1Utf8String)this.field), (String)this.value);
            } else {
                throw new UnsupportedOperationException("Unimplemented Asn1Field: " + this.field.getClass().getName());
            }
            return this.field.getContent().getOriginalValue();
        }
    }
}

