/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator;

import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.model.Asn1Ia5String;
import de.rub.nds.asn1.model.Asn1ObjectIdentifier;
import de.rub.nds.asn1.model.Asn1OctetString;
import de.rub.nds.asn1.oid.ObjectIdentifier;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.constants.GeneralNameChoiceType;
import de.rub.nds.x509attacker.x509.model.GeneralName;
import de.rub.nds.x509attacker.x509.preparator.X509Asn1FieldPreparator;
import de.rub.nds.x509attacker.x509.preparator.X509Preparator;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class GeneralNamePreparator
implements X509Preparator {
    private final GeneralName generalName;
    private final X509Chooser chooser;

    public GeneralNamePreparator(X509Chooser chooser, GeneralName generalName) {
        this.generalName = generalName;
        this.chooser = chooser;
    }

    @Override
    public void prepare() {
        byte contextTag = switch (this.generalName.getGeneralNameChoiceTypeConfig()) {
            case GeneralNameChoiceType.DIRECTORY_NAME -> {
                this.generalName.makeSelection(this.generalName.getDirectoryName());
                yield -124;
            }
            case GeneralNameChoiceType.DNS_NAME -> {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getDnsName());
                yield -126;
            }
            case GeneralNameChoiceType.EDI_PARTY_NAME -> {
                this.generalName.makeSelection(this.generalName.getEdiPartyName());
                yield -123;
            }
            case GeneralNameChoiceType.IP_ADDRESS -> {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getIpAddress());
                yield -121;
            }
            case GeneralNameChoiceType.OTHER_NAME -> {
                this.generalName.makeSelection(this.generalName.getOtherName());
                yield -128;
            }
            case GeneralNameChoiceType.REGISTERED_ID -> {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getRegisteredId());
                yield -120;
            }
            case GeneralNameChoiceType.RFC822_NAME -> {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getRfc822Name());
                yield -127;
            }
            case GeneralNameChoiceType.UNIFORM_RESOURCE_IDENTIFIER -> {
                this.generalName.makeSelection((Asn1Encodable)this.generalName.getUniformResourceIdentifier());
                yield -122;
            }
            case GeneralNameChoiceType.X400_ADDRESS -> {
                this.generalName.makeSelection(this.generalName.getX400Address());
                yield -125;
            }
            default -> throw new UnsupportedOperationException("GeneralNameChoiceType " + this.generalName.getGeneralNameChoiceTypeConfig().name() + " not yet implemented.");
        };
        if (!(this.generalName.getSelectedChoice() instanceof Asn1Field)) {
            throw new UnsupportedOperationException("GeneralName only supports Asn1Field and X509 Components at the time");
        }
        HelperPreparator preparator = new HelperPreparator(this, this.chooser, (Asn1Field)this.generalName.getSelectedChoice(), this.generalName.getGeneralNameConfigValue(), contextTag);
        preparator.prepareWithTag();
    }

    private class HelperPreparator<T extends Asn1Field>
    extends X509Asn1FieldPreparator<T> {
        private final Object value;
        private final byte contextTag;

        /*
         * WARNING - Possible parameter corruption
         */
        public HelperPreparator(X509Chooser chooser, T type, Object value, byte contextTag) {
            super(chooser, type);
            this.value = value;
            this.contextTag = contextTag;
        }

        protected byte[] encodeContent() {
            Asn1Field asn1Field = this.field;
            Objects.requireNonNull(asn1Field);
            Asn1Field asn1Field2 = asn1Field;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Asn1Ia5String.class, Asn1ObjectIdentifier.class, Asn1OctetString.class}, (Object)asn1Field2, n)) {
                case 0: {
                    Asn1Ia5String asn1Ia5String = (Asn1Ia5String)asn1Field2;
                    Asn1PreparatorHelper.prepareField((Asn1Ia5String)asn1Ia5String, (String)((String)this.value));
                    break;
                }
                case 1: {
                    Asn1ObjectIdentifier asn1ObjectIdentifier = (Asn1ObjectIdentifier)asn1Field2;
                    Asn1PreparatorHelper.prepareField((Asn1ObjectIdentifier)asn1ObjectIdentifier, (ObjectIdentifier)new ObjectIdentifier((String)this.value));
                    break;
                }
                case 2: {
                    Asn1OctetString asn1OctetString = (Asn1OctetString)asn1Field2;
                    Asn1PreparatorHelper.prepareField((Asn1OctetString)asn1OctetString, (byte[])((byte[])this.value));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unimplemented Asn1Field: " + this.field.getClass().getName());
                }
            }
            return this.field.getContent().getOriginalValue();
        }

        public void prepareWithTag() {
            super.prepare();
            this.field.setTagOctets(new byte[]{this.contextTag});
            this.field.setLengthOctets(new byte[]{(byte)((byte[])this.field.getContent().getValue()).length});
        }
    }
}

