/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.x509.preparator.extension;

import de.rub.nds.asn1.model.Asn1BitString;
import de.rub.nds.asn1.model.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Field;
import de.rub.nds.asn1.preparator.Asn1PreparatorHelper;
import de.rub.nds.x509attacker.chooser.X509Chooser;
import de.rub.nds.x509attacker.config.extension.KeyUsageConfig;
import de.rub.nds.x509attacker.x509.model.extensions.KeyUsage;
import de.rub.nds.x509attacker.x509.preparator.extension.ExtensionPreparator;

public class KeyUsagePreparator
extends ExtensionPreparator<KeyUsage, KeyUsageConfig> {
    public KeyUsagePreparator(X509Chooser chooser, KeyUsage container, KeyUsageConfig config) {
        super(chooser, container, config);
    }

    @Override
    public void extensionPrepareSubComponents() {
        if (((KeyUsage)this.field).getBitString() == null) {
            ((KeyUsage)this.field).setBitString(new Asn1BitString("bitString"));
        }
        Asn1BitString bitString = ((KeyUsage)this.field).getBitString();
        byte unusedBits = 7;
        if (((KeyUsageConfig)this.config).isOverflowInvalidation()) {
            unusedBits = 6;
        }
        bitString.setUnusedBits(unusedBits);
        bitString.setUsedBits(this.computeBitString((KeyUsageConfig)this.config));
        bitString.setPadding((byte)0);
        bitString.setContent(Asn1PreparatorHelper.encodeBitString((byte[])((byte[])bitString.getUsedBits().getValue()), (Byte)((Byte)bitString.getUnusedBits().getValue()), (Byte)((Byte)bitString.getPadding().getValue())));
        Asn1PreparatorHelper.prepareAfterContent((Asn1Field)bitString);
    }

    @Override
    public byte[] extensionEncodeChildrenContent() {
        return this.encodeChildren(new Asn1Encodable[]{((KeyUsage)this.field).getBitString()});
    }

    private byte[] computeBitString(KeyUsageConfig config) {
        byte higherByte;
        int lowerByte = 0;
        if (!config.isOverflowInvalidation()) {
            lowerByte |= config.isNonRepudiation() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isKeyEncipherment() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isDataEncipherment() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isKeyAgreement() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isKeyCertSign() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.iscRLSign() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isEncipherOnly() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isDecipherOnly() ? 1 : 0;
            higherByte = (byte)(config.isDigitalSignature() ? 1 : 0);
        } else {
            lowerByte |= config.isKeyEncipherment() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isDataEncipherment() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isKeyAgreement() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isKeyCertSign() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.iscRLSign() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isEncipherOnly() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isDecipherOnly() ? 1 : 0;
            lowerByte <<= 1;
            lowerByte |= config.isOverflowWithOne() ? 1 : 0;
            higherByte = (byte)((config.isDigitalSignature() ? 1 : 0) | (config.isNonRepudiation() ? 2 : 0));
        }
        return new byte[]{higherByte, (byte)lowerByte};
    }
}

