/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.modifiablevariable.util.IllegalStringAdapter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.protocol.xml.Pair;
import de.rub.nds.tlsattacker.core.config.ConfigIO;
import de.rub.nds.tlsattacker.core.config.adapter.MapAdapter;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.constants.AlpnProtocol;
import de.rub.nds.tlsattacker.core.constants.AuthzDataFormat;
import de.rub.nds.tlsattacker.core.constants.CertificateStatusRequestType;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.constants.ChooserType;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ClientAuthenticationType;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ConnectionIdUsage;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EsniDnsKeyRecordVersion;
import de.rub.nds.tlsattacker.core.constants.EsniVersion;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.HeartbeatMode;
import de.rub.nds.tlsattacker.core.constants.KeyUpdateRequest;
import de.rub.nds.tlsattacker.core.constants.MaxFragmentLength;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.PskKeyExchangeMode;
import de.rub.nds.tlsattacker.core.constants.RecordSizeLimit;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.SniType;
import de.rub.nds.tlsattacker.core.constants.SrtpProtectionProfile;
import de.rub.nds.tlsattacker.core.constants.StarttlsType;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.constants.TokenBindingType;
import de.rub.nds.tlsattacker.core.constants.TokenBindingVersion;
import de.rub.nds.tlsattacker.core.constants.UserMappingExtensionHintType;
import de.rub.nds.tlsattacker.core.layer.constant.StackConfiguration;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EchConfig;
import de.rub.nds.tlsattacker.core.protocol.message.extension.cachedinfo.CachedObject;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameters;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import de.rub.nds.tlsattacker.core.protocol.message.extension.statusrequestv2.RequestItemV2;
import de.rub.nds.tlsattacker.core.protocol.message.extension.trustedauthority.TrustedAuthority;
import de.rub.nds.tlsattacker.core.quic.constants.QuicVersion;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ActionOption;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.core.workflow.filter.FilterType;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import de.rub.nds.x509attacker.filesystem.CertificateBytes;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlRootElement(name="config")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={})
public class Config
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private Boolean respectPeerRecordSizeLimitations = true;
    private StackConfiguration defaultLayerConfiguration;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultHandshakeSecret = new byte[32];
    @XmlElement(name="certificateBytes")
    @XmlElementWrapper
    private List<CertificateBytes> defaultExplicitCertificateChain = null;
    private Boolean autoAdjustCertificate = true;
    private Boolean autoAdjustSignatureAndHashAlgorithm = true;
    @XmlElement(name="certificateConfig")
    @XmlElementWrapper
    private List<X509CertificateConfig> certificateChainConfig;
    @XmlElement(name="outputFilter")
    @XmlElementWrapper
    private List<FilterType> outputFilters;
    private Boolean applyFiltersInPlace = true;
    private Boolean filtersKeepUserSettings = true;
    private Boolean reorderReceivedDtlsRecords = true;
    private ProtocolVersion highestProtocolVersion = ProtocolVersion.TLS12;
    private OutboundConnection defaultClientConnection;
    private Boolean receiveFinalTcpSocketStateWithTimeout = false;
    private Boolean retryFailedClientTcpSocketInitialization = false;
    private Boolean resetClientSourcePort = true;
    private InboundConnection defaultServerConnection;
    private RunningModeType defaultRunningMode = RunningModeType.CLIENT;
    private Boolean dtlsCookieExchange = true;
    private Boolean clientAuthentication = false;
    private Boolean respectClientProposedExtensions = false;
    @XmlElement(name="defaultClientSupportedSignatureAndHashAlgorithm")
    @XmlElementWrapper
    private List<SignatureAndHashAlgorithm> defaultClientSupportedSignatureAndHashAlgorithms;
    @XmlElement(name="defaultClientSupportedCertificateSignAlgorithms")
    @XmlElementWrapper
    private List<SignatureAndHashAlgorithm> defaultClientSupportedCertificateSignAlgorithms;
    @XmlElement(name="defaultClientSupportedCipherSuite")
    @XmlElementWrapper
    private List<CipherSuite> defaultClientSupportedCipherSuites;
    @XmlElement(name="defaultServerSupportedCipherSuite")
    @XmlElementWrapper
    private List<CipherSuite> defaultServerSupportedCipherSuites;
    @XmlElement(name="defaultServerSupportedSSL2CipherSuite")
    @XmlElementWrapper
    private List<SSL2CipherSuite> defaultServerSupportedSSL2CipherSuites;
    @XmlElement(name="defaultClientNamedGroup")
    @XmlElementWrapper
    private List<NamedGroup> defaultClientNamedGroups;
    @XmlElement(name="defaultServerNamedGroup")
    @XmlElementWrapper
    private List<NamedGroup> defaultServerNamedGroups;
    @XmlElement(name="supportedVersion")
    @XmlElementWrapper
    private List<ProtocolVersion> supportedVersions;
    private HeartbeatMode heartbeatMode = HeartbeatMode.PEER_ALLOWED_TO_SEND;
    private Integer defaultAdditionalPadding = 0;
    @XmlElement(name="defaultSniHostname")
    @XmlElementWrapper
    private List<ServerNamePair> defaultSniHostnames = new LinkedList<ServerNamePair>(List.of(new ServerNamePair(SniType.HOST_NAME.getValue(), "example.com".getBytes(StandardCharsets.US_ASCII))));
    private NamedGroup defaultSelectedNamedGroup = NamedGroup.SECP256R1;
    @XmlElement
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private Map<NamedGroup, BigInteger> defaultKeySharePrivateMap = new HashMap<NamedGroup, BigInteger>();
    @XmlElement(name="defaultClientKeyShareNamedGroup")
    @XmlElementWrapper
    private List<NamedGroup> defaultClientKeyShareNamedGroups;
    @XmlElement(name="defaultClientKeyStoreEntry")
    @XmlElementWrapper
    private List<KeyShareStoreEntry> defaultClientKeyStoreEntries;
    private KeyShareStoreEntry defaultServerKeyShareEntry;
    private SniType sniType = SniType.HOST_NAME;
    private Integer preferredCertRsaKeySize = 2048;
    private Integer preferredCertDssKeySize = 2048;
    private KeyUpdateRequest defaultKeyUpdateRequestMode = KeyUpdateRequest.UPDATE_NOT_REQUESTED;
    private Boolean encryptChangeCipherSpecTls13 = false;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] tlsSessionTicket = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientRenegotiationInfo = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerRenegotiationInfo = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSignedCertificateTimestamp = new byte[0];
    private TokenBindingVersion defaultTokenBindingVersion = TokenBindingVersion.DRAFT_13;
    @XmlElement(name="defaultTokenBindingKeyParameter")
    @XmlElementWrapper
    private List<TokenBindingKeyParameters> defaultTokenBindingKeyParameters;
    private CertificateStatusRequestType certificateStatusRequestExtensionRequestType = CertificateStatusRequestType.OCSP;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] certificateStatusRequestExtensionResponderIDList = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] certificateStatusRequestExtensionRequestExtension = new byte[0];
    @XmlElement(name="defaultProposedAlpnProtocol")
    @XmlElementWrapper
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private List<String> defaultProposedAlpnProtocols;
    @XmlElement(name="defaultQuicTransportParameters")
    private QuicTransportParameters defaultQuicTransportParameters;
    @XmlElement(name="defaultQuicServerRetryToken")
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultQuicServerRetryToken = DataConverter.hexStringToByteArray((String)"1234567890abcedf1234567890abcedf");
    private Boolean echoQuic = false;
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultSelectedAlpnProtocol = AlpnProtocol.HTTP_2.getConstant();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] secureRemotePasswordExtensionIdentifier = "UserName".getBytes(Charset.forName("UTF-8"));
    @XmlElement(name="clientSupportedSrtpProtectionProfiles")
    @XmlElementWrapper
    private List<SrtpProtectionProfile> clientSupportedSrtpProtectionProfiles;
    @XmlElement(name="serverSupportedSrtpProtectionProfiles")
    @XmlElementWrapper
    private List<SrtpProtectionProfile> serverSupportedSrtpProtectionProfiles;
    private SrtpProtectionProfile defaultSelectedSrtpProtectionProfile = SrtpProtectionProfile.SRTP_AES128_CM_HMAC_SHA1_80;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] secureRealTimeTransportProtocolMasterKeyIdentifier = new byte[0];
    private UserMappingExtensionHintType userMappingExtensionHintType = UserMappingExtensionHintType.UPN_DOMAIN_HINT;
    @XmlElement(name="certificateTypeDesiredType")
    @XmlElementWrapper
    private List<CertificateType> certificateTypeDesiredTypes;
    @XmlElement(name="clientCertificateTypeDesiredType")
    @XmlElementWrapper
    private List<CertificateType> clientCertificateTypeDesiredTypes;
    @XmlElement(name="serverCertificateTypeDesiredType")
    @XmlElementWrapper
    private List<CertificateType> serverCertificateTypeDesiredTypes;
    @XmlElement(name="clientAuthzExtensionDataFormat")
    @XmlElementWrapper
    private List<AuthzDataFormat> clientAuthzExtensionDataFormat;
    private Boolean certificateTypeExtensionMessageState = true;
    @XmlElement(name="serverAuthzExtensionDataFormat")
    @XmlElementWrapper
    private List<AuthzDataFormat> serverAuthzExtensionDataFormat;
    @XmlElement(name="trustedCaIndicationExtensionAuthority")
    @XmlElementWrapper
    private List<TrustedAuthority> trustedCaIndicationExtensionAuthorities;
    private Boolean clientCertificateTypeExtensionMessageState = true;
    private Boolean cachedInfoExtensionIsClientState = true;
    @XmlElement(name="cachedObject")
    @XmlElementWrapper
    private List<CachedObject> cachedObjectList;
    @XmlElement(name="statusRequestV2Request")
    @XmlElementWrapper
    private List<RequestItemV2> statusRequestV2RequestList;
    private WorkflowTraceType workflowTraceType = null;
    private Boolean serverSendsApplicationData = false;
    private Boolean addExtensionsInSSL = false;
    private Boolean addECPointFormatExtension = true;
    private Boolean addEllipticCurveExtension = true;
    private Boolean addHeartbeatExtension = false;
    private Boolean addMaxFragmentLengthExtension = false;
    private Boolean addRecordSizeLimitExtension = false;
    private Boolean addServerNameIndicationExtension = false;
    private Boolean addSignatureAndHashAlgorithmsExtension = true;
    private Boolean addSignatureAlgorithmsCertExtension = false;
    private Boolean addSupportedVersionsExtension = false;
    private Boolean addKeyShareExtension = false;
    private Boolean addEarlyDataExtension = false;
    private Integer defaultMaxEarlyDataSize = 16384;
    private Boolean addEncryptedServerNameIndicationExtension = false;
    private Boolean addPWDClearExtension = false;
    private Boolean addPWDProtectExtension = false;
    private Boolean addPSKKeyExchangeModesExtension = false;
    private Boolean addPreSharedKeyExtension = false;
    private Boolean addPaddingExtension = false;
    private Boolean addExtendedMasterSecretExtension = false;
    private Boolean addSessionTicketTLSExtension = false;
    private Boolean addDebugExtension = false;
    private Boolean addExtendedRandomExtension = false;
    private Boolean addQuicTransportParametersExtension = false;
    private Boolean addSignedCertificateTimestampExtension = false;
    private Boolean addRenegotiationInfoExtension = true;
    private Boolean addTokenBindingExtension = false;
    private Boolean addHttpCookie = false;
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultHttpCookieName = "tls-attacker";
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultHttpCookieValue = "42130912812";
    private Boolean addCertificateStatusRequestExtension = false;
    private Boolean addAlpnExtension = false;
    private Boolean addSRPExtension = false;
    private Boolean addSRTPExtension = false;
    private Boolean addTruncatedHmacExtension = false;
    private Boolean addUserMappingExtension = false;
    private Boolean addCertificateTypeExtension = false;
    private Boolean addClientAuthzExtension = false;
    private Boolean addServerAuthzExtension = false;
    private Boolean addClientCertificateTypeExtension = false;
    private Boolean addServerCertificateTypeExtension = false;
    private Boolean addEncryptThenMacExtension = false;
    private Boolean addCachedInfoExtension = false;
    private Boolean addClientCertificateUrlExtension = false;
    private Boolean addTrustedCaIndicationExtension = false;
    private Boolean addCertificateStatusRequestV2Extension = false;
    private Boolean addCookieExtension = false;
    private Boolean sendHandshakeMessagesWithinSingleRecord = false;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    @XmlElement(name="defaultConnectionId")
    private byte[] defaultConnectionId = new byte[]{1, 2, 3};
    @XmlElement(name="defaultDebugContent")
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultDebugContent = "TLS-Attacker Debug Content";
    private Integer defaultNumberOfRequestedConnectionIds = 3;
    private ConnectionIdUsage defaultUsageOfSentConnectionIds = ConnectionIdUsage.CID_SPARE;
    private Boolean addConnectionIdExtension = false;
    @XmlElement(name="pskKeyExchangeMode")
    @XmlElementWrapper
    List<PskKeyExchangeMode> pskKeyExchangeModes;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] psk = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] clientEarlyTrafficSecret = new byte[128];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] earlySecret = new byte[256];
    private CipherSuite earlyDataCipherSuite = CipherSuite.TLS_AES_128_GCM_SHA256;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] earlyDataPsk = new byte[256];
    @XmlElement(name="defaultPskSet")
    @XmlElementWrapper
    private List<PskSet> defaultPskSets = new LinkedList<PskSet>();
    private Boolean limitPsksToOne = false;
    private Boolean preserveMessageRecordRelation = false;
    private Boolean usePsk = false;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] earlyData = DataConverter.hexStringToByteArray((String)"544c532d41747461636b65720a");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] distinguishedNames = new byte[0];
    private Boolean enforceSettings = false;
    private Integer receiveMaximumBytes = 0x1000000;
    private Boolean stealthMode = false;
    private Boolean stopActionsAfterIOException = false;
    private Boolean stopTraceAfterUnexpected = false;
    @XmlElement(name="messageFactoryActionOption")
    @XmlElementWrapper
    private List<ActionOption> messageFactoryActionOptions = new LinkedList<ActionOption>();
    private BigInteger defaultServerEphemeralDhGenerator = BigInteger.valueOf(2L);
    private BigInteger defaultServerEphemeralDhModulus = new BigInteger("5809605995369958062791915965639201402176612226902900533702900882779736177890990861472094774477339581147373410185646378328043729800750470098210924487866935059164371588168047540943981644516632755067501626434556398193186628990071248660819361205119793693985433297036118232914410171876807536457391277857011849897410207519105333355801121109356897459426271845471397952675959440793493071628394122780510124618488232602464649876850458861245784240929258426287699705312584509625419513463605155428017165714465363094021609290561084025893662561222573202082865797821865270991145082200656978177192827024538990239969175546190770645685893438011714430426409338676314743571154537142031573004276428701433036381801705308659830751190352946025482059931306571004727362479688415574702596946457770284148435989129632853918392117997472632693078113129886487399347796982772784615865232621289656944284216824611318709764535152507354116344703769998514148343807");
    private BigInteger defaultServerEphemeralDhPrivateKey = new BigInteger("FFFF", 16);
    private BigInteger defaultClientEphemeralDhPrivateKey = new BigInteger("FFFF", 16);
    private BigInteger defaultServerEphemeralDhPublicKey = new BigInteger("2043613254509771843465057207078304133427100053346630496863115304729422431506842297554370188431622336168084226893060531474609378481237396107127063278624858982135545329954888129900714249447398611399069380214077491792199889131147659097337451088584054931352640316306698530468089459265836208766829761530786550035554546801263324790398605318443686766315312672983302101280548433287949333943437948214799189911192606949101858307621640886413682299273130735853556255008467704876737231663242842259426239401780891543201358635180397430055997246351872086043137262555233050955216238105392009330462604912891943865361186717249962097299588875409587651544594728203293910128024102640696503192096755401014128136916889018704050784334709496695214785225237421325503031115105974843553040027247097092511319153606298406218024502785451855415341620633845851737579504653807158340552365430158715166515645118698024341396560621615465703434564793715203380646117");
    private BigInteger defaultClientEphemeralDhPublicKey = new BigInteger("2043613254509771843465057207078304133427100053346630496863115304729422431506842297554370188431622336168084226893060531474609378481237396107127063278624858982135545329954888129900714249447398611399069380214077491792199889131147659097337451088584054931352640316306698530468089459265836208766829761530786550035554546801263324790398605318443686766315312672983302101280548433287949333943437948214799189911192606949101858307621640886413682299273130735853556255008467704876737231663242842259426239401780891543201358635180397430055997246351872086043137262555233050955216238105392009330462604912891943865361186717249962097299588875409587651544594728203293910128024102640696503192096755401014128136916889018704050784334709496695214785225237421325503031115105974843553040027247097092511319153606298406218024502785451855415341620633845851737579504653807158340552365430158715166515645118698024341396560621615465703434564793715203380646117");
    private BigInteger defaultEcdsaNonce = new BigInteger(1, DataConverter.hexStringToByteArray((String)"60B420BB3851D9D47ACB933DBE70399BF6C92DA33AF01D4FB770E98C0325F41D3EBAF8986DA712C82BCD4D554BF0B54023C29B624DE9EF9C2F931EFC580F9AFB081B12E107B1E805F2B4F5F0F1D00C2D0F62634670921C505867FF20F6A8335E98AF8725385586B41FEFF205B4E05A000823F78B5F8F5C02439CE8F67A781D90CBE6BF1AE7F2BC40A49709A06C0E31499BF02969CA42D203E566BCC696DE08FA0102A0FD2E2330B0964ABB7C443020DE1CAD09BFD6381FFB94DAAFBB90C4ED91A0613AD1DC4B4703AF84C1D63B1A876921C6D5869D61CCB98ED13AE6C09A13FC91E14922F301CF8BCF934315A6049D2F07D983FAA91B8F4E7265ECB815A7CBAB"));
    private BigInteger defaultDsaNonce = new BigInteger(1, DataConverter.hexStringToByteArray((String)"349C55648DCF992F3F33E8026CFAC87C1D2BA075"));
    private GOSTCurve defaultSelectedGostCurve = GOSTCurve.GostR3410_2001_CryptoPro_XchB;
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultApplicationMessageData = "Test";
    @XmlElement(name="clientCertificateType")
    @XmlElementWrapper
    private List<ClientCertificateType> clientCertificateTypes;
    private Integer heartbeatPayloadLength = 256;
    private Integer heartbeatPaddingLength = 256;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    @XmlElement(name="defaultPaddingExtensionBytes")
    private byte[] defaultPaddingExtensionBytes = new byte[]{0, 0, 0, 0, 0, 0};
    private Integer dtlsDefaultCookieLength = 20;
    private Integer dtlsMaximumFragmentLength = 1400;
    private Integer quicMaximumFrameSize = 1100;
    private WorkflowExecutorType workflowExecutorType = WorkflowExecutorType.DEFAULT;
    private Boolean flushOnMessageTypeChange = true;
    private Boolean createFragmentsDynamically = true;
    private Boolean createRecordsDynamically = true;
    private Boolean individualTransportPacketsForFragments = false;
    private Integer individualTransportPacketCooldown = 0;
    private Boolean resetWorkflowTracesBeforeSaving = false;
    private Boolean workflowExecutorShouldOpen = true;
    private Boolean stopReceivingAfterFatal = false;
    private Boolean workflowExecutorShouldClose = true;
    private Boolean stopActionsAfterFatal = false;
    private Boolean stopActionsAfterQuicConnectionClose = true;
    private Boolean stopActionsAfterQuicStatelessReset = true;
    private Boolean finishWithCloseNotify = false;
    private Boolean ignoreRetransmittedCcsInDtls = false;
    private Boolean addRetransmissionsToWorkflowTraceInDtls = false;
    private Integer maxUDPRetransmissions = 3;
    private Boolean expectHandshakeDoneQuicFrame = false;
    private Boolean isQuic = false;
    private Boolean quicRetryFlowRequired = false;
    private QuicVersion quicVersion = QuicVersion.VERSION_1;
    private Boolean quicImmediateCloseOnTlsError = false;
    private byte[] defaultQuicNewToken = DataConverter.hexStringToByteArray((String)"AABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFF");
    private byte[] defaultQuicPathChallange = DataConverter.hexStringToByteArray((String)"AABBCCDD");
    private Boolean stopActionsAfterWarning = false;
    private CipherSuite defaultSelectedCipherSuite = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
    private CertificateType defaultSelectedServerCertificateType = CertificateType.X509;
    private CertificateType defaultSelectedClientCertificateType = CertificateType.X509;
    private SSL2CipherSuite defaultSSL2CipherSuite = SSL2CipherSuite.SSL_CK_RC4_128_WITH_MD5;
    @XmlElement(name="defaultServerSupportedPointFormat")
    @XmlElementWrapper
    private List<ECPointFormat> defaultServerSupportedPointFormats;
    @XmlElement(name="defaultClientSupportedPointFormat")
    @XmlElementWrapper
    private List<ECPointFormat> defaultClientSupportedPointFormats;
    @XmlElement(name="defaultServerSupportedSignatureAndHashAlgorithm")
    @XmlElementWrapper
    private List<SignatureAndHashAlgorithm> defaultServerSupportedSignatureAndHashAlgorithms;
    @XmlElement(name="defaultServerSupportedCertificateSignAlgorithms")
    @XmlElementWrapper
    private List<SignatureAndHashAlgorithm> defaultServerSupportedCertificateSignAlgorithms;
    private SignatureAndHashAlgorithm defaultSelectedSignatureAndHashAlgorithm = SignatureAndHashAlgorithm.RSA_SHA1;
    private SignatureAndHashAlgorithm defaultSelectedSignatureAlgorithmCert = SignatureAndHashAlgorithm.RSA_SHA1;
    private ProtocolVersion defaultLastRecordProtocolVersion = ProtocolVersion.TLS10;
    private ProtocolVersion defaultSelectedProtocolVersion = ProtocolVersion.TLS12;
    private ProtocolVersion defaultHighestClientProtocolVersion = ProtocolVersion.TLS12;
    private MaxFragmentLength defaultMaxFragmentLength = MaxFragmentLength.TWO_12;
    private Integer defaultAssumedMaxReceiveLimit = RecordSizeLimit.DEFAULT_MAX_RECORD_DATA_SIZE;
    private Integer defaultMaxRecordData = RecordSizeLimit.DEFAULT_MAX_RECORD_DATA_SIZE;
    private Integer inboundRecordSizeLimit = RecordSizeLimit.DEFAULT_MAX_RECORD_DATA_SIZE;
    private HeartbeatMode defaultHeartbeatMode = HeartbeatMode.PEER_ALLOWED_TO_SEND;
    @XmlElement(name="defaultClientSupportedCompressionMethod")
    @XmlElementWrapper
    private List<CompressionMethod> defaultClientSupportedCompressionMethods;
    @XmlElement(name="defaultServerSupportedCompressionMethod")
    @XmlElementWrapper
    private List<CompressionMethod> defaultServerSupportedCompressionMethods;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultMasterSecret = new byte[48];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPreMasterSecret = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientExtendedRandom = DataConverter.hexStringToByteArray((String)"AABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABB");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerExtendedRandom = DataConverter.hexStringToByteArray((String)"AABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABB");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientRandom = DataConverter.hexStringToByteArray((String)"00112233445566778899AABBCCDDEEFFFFEEDDCCBBAA99887766554433221100");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerRandom = DataConverter.hexStringToByteArray((String)"00112233445566778899AABBCCDDEEFFFFEEDDCCBBAA99887766554433221100");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientSessionId = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientTicketResumptionSessionId = DataConverter.hexStringToByteArray((String)"332CAC09A5C56974E3D49C0741F396C5F1C90B41529DD643485E65B1C0619D2B");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerSessionId = new byte[0];
    private CompressionMethod defaultSelectedCompressionMethod = CompressionMethod.NULL;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] dtlsDefaultCookie = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultExtensionCookie = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultCertificateRequestContext = new byte[0];
    private PRFAlgorithm defaultPRFAlgorithm = PRFAlgorithm.TLS_PRF_LEGACY;
    private AlertDescription defaultAlertDescription = AlertDescription.CLOSE_NOTIFY;
    private AlertLevel defaultAlertLevel = AlertLevel.WARNING;
    private NamedGroup defaultEcCertificateCurve = NamedGroup.SECP256R1;
    private Point defaultClientEphemeralEcPublicKey = Point.createPoint((BigInteger)new BigInteger("42877656971275811310262564894490210024759287182177196162425349131675946712428"), (BigInteger)new BigInteger("61154801112014214504178281461992570017247172004704277041681093927569603776562"), this.defaultSelectedNamedGroup.getGroupParameters());
    private Point defaultServerEphemeralEcPublicKey = Point.createPoint((BigInteger)new BigInteger("42877656971275811310262564894490210024759287182177196162425349131675946712428"), (BigInteger)new BigInteger("61154801112014214504178281461992570017247172004704277041681093927569603776562"), this.defaultSelectedNamedGroup.getGroupParameters());
    private BigInteger defaultServerEphemeralEcPrivateKey = new BigInteger("3");
    private BigInteger defaultClientEphemeralEcPrivateKey = new BigInteger("3");
    private BigInteger defaultServerEphemeralRsaExportPublicKey = new BigInteger("65537");
    private BigInteger defaultServerEphemeralRsaExportPrivateKey = new BigInteger("7dc0cb485a3edb56811aeab12cdcda8e48b023298dd453a37b4d75d9e0bbba27c98f0e4852c16fd52341ffb673f64b580b7111abf14bf323e53a2dfa92727364ddb34f541f74a478a077f15277c013606aea839307e6f5fec23fdd72506feea7cbe362697949b145fe8945823a39a898ac6583fc5fbaefa1e77cbc95b3b475e66106e92b906bdbb214b87bcc94020f317fc1c056c834e9cee0ad21951fbdca088274c4ef9d8c2004c6294f49b370fb249c1e2431fb80ce5d3dc9e342914501ef4c162e54e1ee4fed9369b82afc00821a29f4979a647e60935420d44184d98f9cb75122fb604642c6d1ff2b3a51dc32eefdc57d9a9407ad6a06d10e83e2965481", 16);
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPSKKey = DataConverter.hexStringToByteArray((String)"1a2b3c4d");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPSKIdentity = "Client_Identity".getBytes(Charset.forName("UTF-8"));
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPSKIdentityHint = new byte[0];
    private BigInteger defaultSRPModulus = new BigInteger(1, DataConverter.hexStringToByteArray((String)"EEAF0AB9ADB38DD69C33F80AFA8FC5E86072618775FF3C0B9EA2314C9C256576D674DF7496EA81D3383B4813D692C6E0E0D5D8E250B98BE48E495C1D6089DAD15DC7D7B46154D6B6CE8EF4AD69B15D4982559B297BCF1885C529F566660E57EC68EDBC3C05726CC02FD4CBF4976EAA9AFD5138FE8376435B9FC61D2FC0EB06E3"));
    private BigInteger defaultSRPGenerator = BigInteger.valueOf(2L);
    private BigInteger defaultSRPServerPrivateKey = new BigInteger("3");
    private BigInteger defaultSRPClientPrivateKey = new BigInteger("5");
    private BigInteger defaultSRPServerPublicKey = new BigInteger(1, DataConverter.hexStringToByteArray((String)"AC47983DEB1698D9A9029E8F7B39092F441DDD72C56D3A63F236E1CF6CEE839937AB5FD69F8CEBBA64C210170A59B2526ED34B9DD83EF86DF7899DF68297844B15E6F2D1BD2448640D32A48220E6343875976A268F28D25174C37D8DC19F2BA5A35301CEED689206FA91CE7A172D908B821DF8C760918E6A5D1C0CFA76AF503B"));
    private BigInteger defaultSRPClientPublicKey = new BigInteger(1, DataConverter.hexStringToByteArray((String)"25C843"));
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSRPServerSalt = DataConverter.hexStringToByteArray((String)"AABBCCDD");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSRPIdentity = "UserName".getBytes(Charset.forName("UTF-8"));
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSRPPassword = "Password".getBytes(Charset.forName("UTF-8"));
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientHandshakeTrafficSecret = new byte[32];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerHandshakeTrafficSecret = new byte[32];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientApplicationTrafficSecret = new byte[32];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerApplicationTrafficSecret = new byte[32];
    private BigInteger defaultServerEphemeralRsaExportModulus = new BigInteger("00e208ff3431b8d1f6c48d9bb93c76a9c7f5693ada3eb45fa12581d2203a97246a5ceed7cf8d8fc1d6136225545855dd41581543cecba0b4a5776f90d05a0059ff", 16);
    private BigInteger defaultServerEphemeralDhExportGenerator = BigInteger.valueOf(2L);
    private BigInteger defaultServerEphemeralDhExportModulus = new BigInteger("0090e6a3f16f2c9325a8a036d9bd96d69ae2b6caa59fd7d4cce729b225f8849a14d0fb5939102ba44ed54f26c186e1ad243d58a1a4542ce1adffd482e8f85ef663", 16);
    private BigInteger defaultServerEphemeralDhExportPublicKey = new BigInteger("2530802253db34a8106584c96a066050310bd3b2eb11c71dd7095638eef4b7961892b13b2c983cc31635c49982b485fe837be0ba9d7f75ff72e2cae0f4c1b090", 16);
    private BigInteger defaultServerEphemeralDhExportPrivateKey = new BigInteger("4ba017c0142c0df8fe5f8da8f4046c0933486730b155f1b09bd611c09863b72ad9aec3782d9379883c4a291c748c530f433207f740e0db5f67748c2c2dde2866", 16);
    private TokenBindingType defaultTokenBindingType = TokenBindingType.PROVIDED_TOKEN_BINDING;
    private Point defaultTokenBindingECPublicKey = Point.createPoint((BigInteger)new BigInteger("42877656971275811310262564894490210024759287182177196162425349131675946712428"), (BigInteger)new BigInteger("61154801112014214504178281461992570017247172004704277041681093927569603776562"), this.defaultSelectedNamedGroup.getGroupParameters());
    private BigInteger defaultTokenBindingRsaPublicKey = new BigInteger("65537");
    private BigInteger defaultTokenBindingRsaPrivateKey = new BigInteger("89489425009274444368228545921773093919669586065884257445497854456487674839629818390934941973262879616797970608917283679875499331574161113854088813275488110588247193077582527278437906504015680623423550067240042466665654232383502922215493623289472138866445818789127946123407807725702626644091036502372545139713");
    private BigInteger defaultTokenBindingEcPrivateKey = new BigInteger("3");
    private BigInteger defaultTokenBindingRsaModulus = new BigInteger("145906768007583323230186939349070635292401872375357164399581871019873438799005358938369571402670149802121818086292467422828157022922076746906543401224889672472407926969987100581290103199317858753663710862357656510507883714297115637342788911463535102712032765166518411726859837988672111837205085526346618740053");
    private Boolean useFreshRandom = true;
    private ChooserType chooserType = ChooserType.DEFAULT;
    private Boolean useAllProvidedDtlsFragments = false;
    private Boolean useAllProvidedRecords = false;
    private Boolean useAllProvidedQuicPackets = false;
    private Boolean quicDoNotPad = false;
    private Boolean discardPacketsWithMismatchedSCID = true;
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultHttpsLocationPath = "/";
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultHttpsRequestPath = "/robots.txt";
    private Integer defaultMaxHttpLength = 65536;
    private StarttlsType starttlsType = StarttlsType.NONE;
    private Boolean overrideSessionIdForTickets = true;
    private Long sessionTicketLifetimeHint = 7200L;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] sessionTicketEncryptionKey = DataConverter.hexStringToByteArray((String)"536563757265535469636b65744b6579");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] sessionTicketKeyHMAC = DataConverter.hexStringToByteArray((String)"536563757265535469636b65744b6579536563757265535469636b65744b6579");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] sessionTicketKeyName = DataConverter.hexStringToByteArray((String)"544c532d41747461636b6572204b6579");
    private CipherAlgorithm sessionTicketCipherAlgorithm = CipherAlgorithm.AES_128_CBC;
    private MacAlgorithm sessionTicketMacAlgorithm = MacAlgorithm.HMAC_SHA256;
    private Boolean sessionTicketShouldParse = true;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSessionTicketAgeAdd = DataConverter.hexStringToByteArray((String)"cb8dbe8e");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSessionTicketNonce = DataConverter.hexStringToByteArray((String)"00");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSessionTicketIdentity = DataConverter.hexStringToByteArray((String)"5266d21abe0f5156106eb1f0ec54a48a90fbc136de990a8881192211cc83aa7992ceb67d7a40b3f304fdea87e4ca61042c19641fd7493975ec69a3ec3f5fb6404aa4ac5acd5efbea15d454d89888a46fc4e6c6b9a3e0ee08ea21538372ced8d0aca453ceae44ce372a5388ab4cef67c5eae8cc1c72735d2646c19b2c50a4ee9bc97e70c6b57cab276a11a59fc5cbe0f5d2519e164fbf9f07a9dd053bcfc08939b475c7a2e76f04ef2a06cc9672bd4034");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultLastClientHello = new byte[32];
    private ClientAuthenticationType clientAuthenticationType = ClientAuthenticationType.ANONYMOUS;
    private Boolean tls13BackwardsCompatibilityMode = true;
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultClientPWDUsername = "fred";
    private NamedGroup defaultPWDProtectGroup = NamedGroup.SECP256R1;
    private BigInteger defaultServerPWDProtectPrivateKey = new BigInteger("191991257030464195512760799659436374116556484140110877679395918219072292938297573720808302564562486757422301181089761");
    private Point defaultServerPWDProtectPublicKey = Point.createPoint((BigInteger)new BigInteger("18331185786522319349444255540874590232255475110717040504630785378857839293510"), (BigInteger)new BigInteger("77016287303447444409379355974404854219241223376914775755121063765271326101171"), this.defaultSelectedNamedGroup.getGroupParameters());
    private BigInteger defaultServerPWDProtectRandomSecret = new BigInteger("1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111");
    @XmlJavaTypeAdapter(value=IllegalStringAdapter.class)
    private String defaultPWDPassword = "barney";
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerPWDPrivate = DataConverter.hexStringToByteArray((String)"21d99d341c9797b3ae72dfd289971f1b74ce9de68ad4b9abf54888d8f6c5043c");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerPWDMask = DataConverter.hexStringToByteArray((String)"0d96ab624d082c71255be3648dcd303f6ab0ca61a95034a553e3308d1d3744e5");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientPWDPrivate = DataConverter.hexStringToByteArray((String)"171de8caa5352d36ee96a39979b5b72fa189ae7a6a09c77f7b438af16df4a88b");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientPWDMask = DataConverter.hexStringToByteArray((String)"4f745bdfc295d3b38429f7eb3025a48883728b07d88605c0ee202316a072d1bd");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerPWDSalt = DataConverter.hexStringToByteArray((String)"963c77cdc13a2a8d75cdddd1e0449929843711c21d47ce6e6383cdda37e47da3");
    private ECPointFormat defaultSelectedPointFormat = ECPointFormat.UNCOMPRESSED;
    private String defaultDnsServer = "8.8.8.8";
    private BigInteger defaultEsniClientPrivateKey = new BigInteger("191991257030464195512760799659436374116556484140110877679395918219072292938297573720808302564562486757422301181089761");
    @XmlElement(name="clientSupportedEsniCipherSuite")
    @XmlElementWrapper
    private List<CipherSuite> clientSupportedEsniCipherSuites = new LinkedList<CipherSuite>();
    @XmlElement(name="clientSupportedEsniNamedGroup")
    @XmlElementWrapper
    private List<NamedGroup> clientSupportedEsniNamedGroups = new LinkedList<NamedGroup>();
    @XmlElement(name="esniServerKeyPair")
    @XmlElementWrapper
    private List<KeyShareEntry> esniServerKeyPairs = new LinkedList<KeyShareEntry>();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultEsniClientNonce = DataConverter.hexStringToByteArray((String)"a7284c9a52f15c13644b947261774657");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultEsniServerNonce = DataConverter.hexStringToByteArray((String)"00000000000000000000000000000000");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultEsniRecordBytes = DataConverter.hexStringToByteArray((String)"ff0100124b2a0024001d0020fa572d03e21e15f9ca1aa7fb85f61b9fc78458a78050ac581811863325944412000213010104000000005dcc3a45000000005dda12050000");
    private EsniDnsKeyRecordVersion defaultEsniRecordVersion = EsniVersion.DRAFT_2.getDnsKeyRecordVersion();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultEsniRecordChecksum = DataConverter.hexStringToByteArray((String)"00124b2a");
    @XmlElement(name="defaultEsniServerKeyShareEntry")
    @XmlElementWrapper
    private List<KeyShareStoreEntry> defaultEsniServerKeyShareEntries = new LinkedList<KeyShareStoreEntry>();
    @XmlElement(name="defaultEsniServerCipherSuite")
    @XmlElementWrapper
    private List<CipherSuite> defaultEsniServerCipherSuites = new LinkedList<CipherSuite>();
    private Integer defaultEsniPaddedLength = 260;
    private Long defaultEsniNotBefore = 1582655135231L;
    private Long defaultEsniNotAfter = 1585247135231L;
    @XmlElement(name="defaultEsniExtension")
    @XmlElementWrapper
    private List<ExtensionType> defaultEsniExtensions = new LinkedList<ExtensionType>();
    private BigInteger defaultEchClientPrivateKey = new BigInteger("191991257030464195512760799659436374116556484140110877679395918219072292938297573720808302564562486757422301181089761");
    private BigInteger defaultEchServerPrivateKey = new BigInteger("-1673869334575128978734767576405071540980308529037586990006706167463937836529");
    private EchConfig defaultEchConfig;
    private Boolean addEncryptedClientHelloExtension = false;
    private Integer defaultMaxEchAlpnPadding = 25;
    private Boolean acceptOnlyFittingDtlsFragments = false;
    private Boolean canSkipMessageSequenceNumber = false;
    private Boolean acceptContentRewritingDtlsFragments = true;
    private Boolean writeKeylogFile = false;
    private String keylogFilePath = null;
    private Boolean useDtls13HeaderSeqNumSizeLongEncoding = true;
    private Boolean retransmitAcknowledgedRecordsInDtls13 = false;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultRsaSsaPssSalt = DataConverter.hexStringToByteArray((String)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");

    @Deprecated
    public static Config createConfig() {
        return new Config();
    }

    public static Config createConfig(File f) {
        return ConfigIO.read(f);
    }

    public static Config createConfig(InputStream stream) {
        return ConfigIO.read(stream);
    }

    public static Config createEmptyConfig() {
        Config c = new Config();
        for (Field field : c.getClass().getDeclaredFields()) {
            if (field.getName().equals("LOGGER") || field.getType().isPrimitive() || field.getName().contains("Extension")) continue;
            field.setAccessible(true);
            try {
                field.set(c, null);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Could not set field in Config!", (Throwable)e);
            }
        }
        return c;
    }

    public Config() {
        this.certificateChainConfig = new LinkedList<X509CertificateConfig>();
        LinkedList<Pair> rdn = new LinkedList<Pair>();
        rdn.add(new Pair((Object)X500AttributeType.COMMON_NAME, (Object)"Attacker CA - Global Insecurity Provider"));
        rdn.add(new Pair((Object)X500AttributeType.COUNTRY_NAME, (Object)"Global"));
        rdn.add(new Pair((Object)X500AttributeType.ORGANISATION_NAME, (Object)"TLS-Attacker"));
        X509CertificateConfig caConfig = new X509CertificateConfig();
        caConfig.setIssuer(rdn);
        caConfig.setSubject(rdn);
        byte[] serialNumber = DataConverter.hexStringToByteArray((String)"DEADBEEFDEADBEEFDEADBEEFDEADBEEFDEADBEEF");
        caConfig.setSerialNumber(new BigInteger(serialNumber));
        X509CertificateConfig leafConfig = new X509CertificateConfig();
        leafConfig.setIssuer(rdn);
        rdn = new LinkedList();
        rdn.add(new Pair((Object)X500AttributeType.COMMON_NAME, (Object)"tls-attacker.com"));
        rdn.add(new Pair((Object)X500AttributeType.ORGANISATION_NAME, (Object)"TLS-Attacker"));
        leafConfig.setSubject(rdn);
        serialNumber = DataConverter.hexStringToByteArray((String)"0F1F2F34F5F6F7F8F9F0F0F9F8F7F6F5F4F3F2F1");
        leafConfig.setSerialNumber(new BigInteger(serialNumber));
        this.certificateChainConfig.add(leafConfig);
        this.certificateChainConfig.add(caConfig);
        this.defaultLayerConfiguration = StackConfiguration.TLS;
        this.defaultClientConnection = new OutboundConnection("client", 443, "localhost");
        this.defaultServerConnection = new InboundConnection("server", 443, "localhost");
        this.workflowTraceType = WorkflowTraceType.DYNAMIC_HANDSHAKE;
        this.clientSupportedSrtpProtectionProfiles = new LinkedList<SrtpProtectionProfile>();
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AES128_CM_HMAC_SHA1_80);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AES128_CM_HMAC_SHA1_32);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_NULL_HMAC_SHA1_32);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_NULL_HMAC_SHA1_80);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.DOUBLE_AEAD_AES_128_GCM_AEAD_AES_128_GCM);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.DOUBLE_AEAD_AES_256_GCM_AEAD_AES_256_GCM);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AEAD_AES_128_GCM);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AEAD_AES_256_GCM);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AEAD_ARIA_128_GCM);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AEAD_ARIA_256_GCM);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_ARIA_128_CTR_HMAC_SHA1_32);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_ARIA_128_CTR_HMAC_SHA1_80);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_ARIA_256_CTR_HMAC_SHA1_32);
        this.clientSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_ARIA_256_CTR_HMAC_SHA1_80);
        this.serverSupportedSrtpProtectionProfiles = new LinkedList<SrtpProtectionProfile>();
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AES128_CM_HMAC_SHA1_80);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AES128_CM_HMAC_SHA1_32);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_NULL_HMAC_SHA1_32);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_NULL_HMAC_SHA1_80);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.DOUBLE_AEAD_AES_128_GCM_AEAD_AES_128_GCM);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.DOUBLE_AEAD_AES_256_GCM_AEAD_AES_256_GCM);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AEAD_AES_128_GCM);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AEAD_AES_256_GCM);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AEAD_ARIA_128_GCM);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_AEAD_ARIA_256_GCM);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_ARIA_128_CTR_HMAC_SHA1_32);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_ARIA_128_CTR_HMAC_SHA1_80);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_ARIA_256_CTR_HMAC_SHA1_32);
        this.serverSupportedSrtpProtectionProfiles.add(SrtpProtectionProfile.SRTP_ARIA_256_CTR_HMAC_SHA1_80);
        this.defaultEsniServerKeyShareEntries.add(new KeyShareStoreEntry(NamedGroup.ECDH_X25519, DataConverter.hexStringToByteArray((String)"fa572d03e21e15f9ca1aa7fb85f61b9fc78458a78050ac581811863325944412")));
        this.defaultEsniServerCipherSuites.add(CipherSuite.TLS_AES_128_GCM_SHA256);
        this.defaultClientSupportedSignatureAndHashAlgorithms = new LinkedList<SignatureAndHashAlgorithm>();
        this.defaultClientSupportedSignatureAndHashAlgorithms.addAll(SignatureAndHashAlgorithm.getImplemented());
        this.defaultClientSupportedCertificateSignAlgorithms = new LinkedList<SignatureAndHashAlgorithm>();
        this.defaultClientSupportedCertificateSignAlgorithms.addAll(SignatureAndHashAlgorithm.getImplementedTls13SignatureAndHashAlgorithms());
        this.defaultClientSupportedCompressionMethods = new LinkedList<CompressionMethod>();
        this.defaultClientSupportedCompressionMethods.add(CompressionMethod.NULL);
        this.defaultServerSupportedCompressionMethods = new LinkedList<CompressionMethod>();
        this.defaultServerSupportedCompressionMethods.add(CompressionMethod.NULL);
        this.defaultClientSupportedCipherSuites = new LinkedList<CipherSuite>();
        this.defaultClientSupportedCipherSuites.addAll(CipherSuite.getImplemented());
        this.defaultServerSupportedCipherSuites = new LinkedList<CipherSuite>();
        this.defaultServerSupportedCipherSuites.addAll(CipherSuite.getImplemented());
        this.clientSupportedEsniCipherSuites = new LinkedList<CipherSuite>();
        this.clientSupportedEsniCipherSuites.addAll(CipherSuite.getImplemented());
        this.defaultServerSupportedSSL2CipherSuites = new LinkedList<SSL2CipherSuite>();
        this.defaultServerSupportedSSL2CipherSuites.addAll(Arrays.asList(SSL2CipherSuite.values()));
        this.defaultClientNamedGroups = NamedGroup.getImplemented();
        this.defaultServerNamedGroups = NamedGroup.getImplemented();
        this.clientSupportedEsniNamedGroups = NamedGroup.getImplemented();
        this.clientCertificateTypes = new LinkedList<ClientCertificateType>();
        this.clientCertificateTypes.add(ClientCertificateType.RSA_SIGN);
        this.supportedVersions = new LinkedList<ProtocolVersion>();
        this.supportedVersions.add(ProtocolVersion.TLS13);
        this.defaultTokenBindingKeyParameters = new LinkedList<TokenBindingKeyParameters>();
        this.defaultTokenBindingKeyParameters.add(TokenBindingKeyParameters.ECDSAP256);
        this.defaultTokenBindingKeyParameters.add(TokenBindingKeyParameters.RSA2048_PKCS1_5);
        this.defaultTokenBindingKeyParameters.add(TokenBindingKeyParameters.RSA2048_PSS);
        this.defaultServerSupportedSignatureAndHashAlgorithms = new LinkedList<SignatureAndHashAlgorithm>();
        this.defaultServerSupportedSignatureAndHashAlgorithms.addAll(SignatureAndHashAlgorithm.getImplemented());
        this.defaultServerSupportedCertificateSignAlgorithms = new LinkedList<SignatureAndHashAlgorithm>();
        this.defaultServerSupportedCertificateSignAlgorithms.addAll(SignatureAndHashAlgorithm.getImplementedTls13SignatureAndHashAlgorithms());
        this.defaultServerSupportedPointFormats = new LinkedList<ECPointFormat>();
        this.defaultClientSupportedPointFormats = new LinkedList<ECPointFormat>();
        this.defaultServerSupportedPointFormats.add(ECPointFormat.UNCOMPRESSED);
        this.defaultClientSupportedPointFormats.add(ECPointFormat.UNCOMPRESSED);
        this.certificateTypeDesiredTypes = new LinkedList<CertificateType>();
        this.certificateTypeDesiredTypes.add(CertificateType.OPEN_PGP);
        this.certificateTypeDesiredTypes.add(CertificateType.X509);
        this.clientAuthzExtensionDataFormat = new LinkedList<AuthzDataFormat>();
        this.clientAuthzExtensionDataFormat.add(AuthzDataFormat.X509_ATTR_CERT);
        this.clientAuthzExtensionDataFormat.add(AuthzDataFormat.SAML_ASSERTION);
        this.clientAuthzExtensionDataFormat.add(AuthzDataFormat.X509_ATTR_CERT_URL);
        this.clientAuthzExtensionDataFormat.add(AuthzDataFormat.SAML_ASSERTION_URL);
        this.serverAuthzExtensionDataFormat = new LinkedList<AuthzDataFormat>();
        this.serverAuthzExtensionDataFormat.add(AuthzDataFormat.X509_ATTR_CERT);
        this.serverAuthzExtensionDataFormat.add(AuthzDataFormat.SAML_ASSERTION);
        this.serverAuthzExtensionDataFormat.add(AuthzDataFormat.X509_ATTR_CERT_URL);
        this.serverAuthzExtensionDataFormat.add(AuthzDataFormat.SAML_ASSERTION_URL);
        this.clientCertificateTypeDesiredTypes = new LinkedList<CertificateType>();
        this.clientCertificateTypeDesiredTypes.add(CertificateType.OPEN_PGP);
        this.clientCertificateTypeDesiredTypes.add(CertificateType.X509);
        this.clientCertificateTypeDesiredTypes.add(CertificateType.RAW_PUBLIC_KEY);
        this.serverCertificateTypeDesiredTypes = new LinkedList<CertificateType>();
        this.serverCertificateTypeDesiredTypes.add(CertificateType.OPEN_PGP);
        this.serverCertificateTypeDesiredTypes.add(CertificateType.X509);
        this.serverCertificateTypeDesiredTypes.add(CertificateType.RAW_PUBLIC_KEY);
        this.cachedObjectList = new LinkedList<CachedObject>();
        this.trustedCaIndicationExtensionAuthorities = new LinkedList<TrustedAuthority>();
        this.statusRequestV2RequestList = new LinkedList<RequestItemV2>();
        this.outputFilters = new ArrayList<FilterType>();
        this.outputFilters.add(FilterType.DEFAULT);
        this.applyFiltersInPlace = false;
        this.filtersKeepUserSettings = true;
        this.defaultClientKeyStoreEntries = new LinkedList<KeyShareStoreEntry>();
        this.defaultClientKeyStoreEntries.add(new KeyShareStoreEntry(NamedGroup.ECDH_X25519, DataConverter.hexStringToByteArray((String)"2A981DB6CDD02A06C1763102C9E741365AC4E6F72B3176A6BD6A3523D3EC0F4C")));
        this.defaultClientKeyShareNamedGroups = new LinkedList<NamedGroup>();
        this.defaultClientKeyShareNamedGroups.add(NamedGroup.ECDH_X25519);
        this.defaultServerKeyShareEntry = new KeyShareStoreEntry(NamedGroup.ECDH_X25519, DataConverter.hexStringToByteArray((String)"2A981DB6CDD02A06C1763102C9E741365AC4E6F72B3176A6BD6A3523D3EC0F4C"));
        this.defaultEchConfig = EchConfig.createDefaultEchConfig();
        this.pskKeyExchangeModes = new LinkedList<PskKeyExchangeMode>();
        this.pskKeyExchangeModes.add(PskKeyExchangeMode.PSK_KE);
        this.pskKeyExchangeModes.add(PskKeyExchangeMode.PSK_DHE_KE);
        this.defaultPskSets = new LinkedList<PskSet>();
        this.defaultProposedAlpnProtocols = new LinkedList<String>();
        this.defaultProposedAlpnProtocols.add(AlpnProtocol.HTTP_2.getConstant());
        this.defaultQuicTransportParameters = QuicTransportParameters.getDefaultParameters();
    }

    public void setDefaultRsaSsaPssSalt(byte[] salt) {
        this.defaultRsaSsaPssSalt = salt;
    }

    public byte[] getDefaultRsaSsaPssSalt() {
        return this.defaultRsaSsaPssSalt;
    }

    public Point getDefaultClientEphemeralEcPublicKey() {
        return this.defaultClientEphemeralEcPublicKey;
    }

    public void setDefaultClientEphemeralEcPublicKey(Point defaultClientEcPublicKey) {
        this.defaultClientEphemeralEcPublicKey = defaultClientEcPublicKey;
    }

    public Point getDefaultServerEphemeralEcPublicKey() {
        return this.defaultServerEphemeralEcPublicKey;
    }

    public void setDefaultServerEphemeralEcPublicKey(Point defaultServerEcPublicKey) {
        this.defaultServerEphemeralEcPublicKey = defaultServerEcPublicKey;
    }

    public Boolean getAutoAdjustCertificate() {
        return this.autoAdjustCertificate;
    }

    public void setAutoAdjustCertificate(Boolean autoAdjustCertificate) {
        this.autoAdjustCertificate = autoAdjustCertificate;
    }

    public BigInteger getDefaultEcdsaNonce() {
        return this.defaultEcdsaNonce;
    }

    public void setDefaultEcdsaNonce(BigInteger defaultEcdsaNonce) {
        this.defaultEcdsaNonce = defaultEcdsaNonce;
    }

    public BigInteger getDefaultDsaNonce() {
        return this.defaultDsaNonce;
    }

    public void setDefaultDsaNonce(BigInteger defaultDsaNonce) {
        this.defaultDsaNonce = defaultDsaNonce;
    }

    public List<X509CertificateConfig> getCertificateChainConfig() {
        return this.certificateChainConfig;
    }

    public void setCertificateChainConfig(List<X509CertificateConfig> certificateChainConfig) {
        this.certificateChainConfig = certificateChainConfig;
    }

    public List<CertificateBytes> getDefaultExplicitCertificateChain() {
        return this.defaultExplicitCertificateChain;
    }

    public void setDefaultExplicitCertificateChain(List<CertificateBytes> defaultExplicitCertificateChain) {
        this.defaultExplicitCertificateChain = defaultExplicitCertificateChain;
    }

    public String getDefaultSelectedAlpnProtocol() {
        return this.defaultSelectedAlpnProtocol;
    }

    public void setDefaultSelectedAlpnProtocol(String defaultSelectedAlpnProtocol) {
        this.defaultSelectedAlpnProtocol = defaultSelectedAlpnProtocol;
    }

    public Boolean getStopReceivingAfterFatal() {
        return this.stopReceivingAfterFatal;
    }

    public void setStopReceivingAfterFatal(Boolean stopReceivingAfterFatal) {
        this.stopReceivingAfterFatal = stopReceivingAfterFatal;
    }

    public Boolean getStopActionsAfterWarning() {
        return this.stopActionsAfterWarning;
    }

    public void setStopActionsAfterWarning(Boolean stopActionsAfterWarning) {
        this.stopActionsAfterWarning = stopActionsAfterWarning;
    }

    public Boolean getExpectHandshakeDoneQuicFrame() {
        return this.expectHandshakeDoneQuicFrame;
    }

    public void setExpectHandshakeDoneQuicFrame(Boolean expectHandshakeDoneQuicFrame) {
        this.expectHandshakeDoneQuicFrame = expectHandshakeDoneQuicFrame;
    }

    public QuicVersion getQuicVersion() {
        return this.quicVersion;
    }

    public void setQuicVersion(QuicVersion quicVersion) {
        this.quicVersion = quicVersion;
    }

    public Boolean isAcceptOnlyFittingDtlsFragments() {
        return this.acceptOnlyFittingDtlsFragments;
    }

    public void setAcceptOnlyFittingDtlsFragments(Boolean acceptOnlyFittingDtlsFragments) {
        this.acceptOnlyFittingDtlsFragments = acceptOnlyFittingDtlsFragments;
    }

    public Boolean isCanSkipMessageSequenceNumber() {
        return this.canSkipMessageSequenceNumber;
    }

    public void setCanSkipMessageSequenceNumber(Boolean canSkipMessageSequenceNumber) {
        this.canSkipMessageSequenceNumber = canSkipMessageSequenceNumber;
    }

    public Boolean isAcceptContentRewritingDtlsFragments() {
        return this.acceptContentRewritingDtlsFragments;
    }

    public void setAcceptContentRewritingDtlsFragments(Boolean acceptContentRewritingDtlsFragments) {
        this.acceptContentRewritingDtlsFragments = acceptContentRewritingDtlsFragments;
    }

    public Boolean getReorderReceivedDtlsRecords() {
        return this.reorderReceivedDtlsRecords;
    }

    public void setReorderReceivedDtlsRecords(Boolean reorderReceivedDtlsRecords) {
        this.reorderReceivedDtlsRecords = reorderReceivedDtlsRecords;
    }

    public Config createCopy() {
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        ConfigIO.write(this, (OutputStream)stream);
        return ConfigIO.read(new ByteArrayInputStream(stream.toByteArray()));
    }

    public CertificateType getDefaultSelectedServerCertificateType() {
        return this.defaultSelectedServerCertificateType;
    }

    public void setDefaultSelectedServerCertificateType(CertificateType defaultSelectedServerCertificateType) {
        this.defaultSelectedServerCertificateType = defaultSelectedServerCertificateType;
    }

    public CertificateType getDefaultSelectedClientCertificateType() {
        return this.defaultSelectedClientCertificateType;
    }

    public void setDefaultSelectedClientCertificateType(CertificateType defaultSelectedClientCertificateType) {
        this.defaultSelectedClientCertificateType = defaultSelectedClientCertificateType;
    }

    public ECPointFormat getDefaultSelectedPointFormat() {
        return this.defaultSelectedPointFormat;
    }

    public void setDefaultSelectedPointFormat(ECPointFormat defaultSelectedPointFormat) {
        this.defaultSelectedPointFormat = defaultSelectedPointFormat;
    }

    public Boolean getStopActionsAfterIOException() {
        return this.stopActionsAfterIOException;
    }

    public void setStopActionsAfterIOException(Boolean stopActionsAfterIOException) {
        this.stopActionsAfterIOException = stopActionsAfterIOException;
    }

    public Boolean getTls13BackwardsCompatibilityMode() {
        return this.tls13BackwardsCompatibilityMode;
    }

    public void setTls13BackwardsCompatibilityMode(Boolean tls13BackwardsCompatibilityMode) {
        this.tls13BackwardsCompatibilityMode = tls13BackwardsCompatibilityMode;
    }

    public Boolean isOverrideSessionIdForTickets() {
        return this.overrideSessionIdForTickets;
    }

    public void setOverrideSessionIdForTickets(Boolean overrideSessionIdForTickets) {
        this.overrideSessionIdForTickets = overrideSessionIdForTickets;
    }

    public long getSessionTicketLifetimeHint() {
        return this.sessionTicketLifetimeHint;
    }

    public void setSessionTicketLifetimeHint(long sessionTicketLifetimeHint) {
        this.sessionTicketLifetimeHint = sessionTicketLifetimeHint;
    }

    public byte[] getSessionTicketEncryptionKey() {
        return Arrays.copyOf(this.sessionTicketEncryptionKey, this.sessionTicketEncryptionKey.length);
    }

    public void setSessionTicketEncryptionKey(byte[] sessionTicketEncryptionKey) {
        this.sessionTicketEncryptionKey = sessionTicketEncryptionKey;
    }

    public byte[] getSessionTicketKeyHMAC() {
        return Arrays.copyOf(this.sessionTicketKeyHMAC, this.sessionTicketKeyHMAC.length);
    }

    public void setSessionTicketKeyHMAC(byte[] sessionTicketKeyHMAC) {
        this.sessionTicketKeyHMAC = sessionTicketKeyHMAC;
    }

    public byte[] getSessionTicketKeyName() {
        return Arrays.copyOf(this.sessionTicketKeyName, this.sessionTicketKeyName.length);
    }

    public void setSessionTicketKeyName(byte[] sessionTicketKeyName) {
        this.sessionTicketKeyName = sessionTicketKeyName;
    }

    public Boolean isSessionTicketShouldParse() {
        return this.sessionTicketShouldParse;
    }

    public void setSessionTicketShouldParse(Boolean sessionTicketShouldParse) {
        this.sessionTicketShouldParse = sessionTicketShouldParse;
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return this.clientAuthenticationType;
    }

    public void setClientAuthenticationType(ClientAuthenticationType clientAuthenticationType) {
        this.clientAuthenticationType = clientAuthenticationType;
    }

    public String getDefaultHttpsLocationPath() {
        return this.defaultHttpsLocationPath;
    }

    public void setDefaultHttpsLocationPath(String defaultHttpsLocationPath) {
        this.defaultHttpsLocationPath = defaultHttpsLocationPath;
    }

    public String getDefaultHttpsRequestPath() {
        return this.defaultHttpsRequestPath;
    }

    public void setDefaultHttpsRequestPath(String defaultHttpsRequestPath) {
        this.defaultHttpsRequestPath = defaultHttpsRequestPath;
    }

    public int getDefaultMaxHttpLength() {
        return this.defaultMaxHttpLength;
    }

    public void setDefaultMaxHttpLength(int defaultMaxHttpLength) {
        this.defaultMaxHttpLength = defaultMaxHttpLength;
    }

    public Boolean isUseFreshRandom() {
        return this.useFreshRandom;
    }

    public void setUseFreshRandom(Boolean useFreshRandom) {
        this.useFreshRandom = useFreshRandom;
    }

    public Boolean isUseAllProvidedDtlsFragments() {
        return this.useAllProvidedDtlsFragments;
    }

    public void setUseAllProvidedDtlsFragments(Boolean useAllProvidedDtlsFragments) {
        this.useAllProvidedDtlsFragments = useAllProvidedDtlsFragments;
    }

    public Boolean isUseAllProvidedRecords() {
        return this.useAllProvidedRecords;
    }

    public void setUseAllProvidedRecords(Boolean useAllProvidedRecords) {
        this.useAllProvidedRecords = useAllProvidedRecords;
    }

    public Boolean isUseAllProvidedQuicPackets() {
        return this.useAllProvidedQuicPackets;
    }

    public void setUseAllProvidedQuicPackets(Boolean useAllProvidedQuicPackets) {
        this.useAllProvidedQuicPackets = useAllProvidedQuicPackets;
    }

    public byte[] getDefaultServerRenegotiationInfo() {
        return Arrays.copyOf(this.defaultServerRenegotiationInfo, this.defaultServerRenegotiationInfo.length);
    }

    public void setDefaultServerRenegotiationInfo(byte[] defaultServerRenegotiationInfo) {
        this.defaultServerRenegotiationInfo = defaultServerRenegotiationInfo;
    }

    public ChooserType getChooserType() {
        return this.chooserType;
    }

    public void setChooserType(ChooserType chooserType) {
        this.chooserType = chooserType;
    }

    public Boolean isStealthMode() {
        return this.stealthMode;
    }

    public void setStealthMode(Boolean stealthMode) {
        this.stealthMode = stealthMode;
    }

    public BigInteger getDefaultServerDhExportGenerator() {
        return this.defaultServerEphemeralDhExportGenerator;
    }

    public void setDefaultServerDhExportGenerator(BigInteger defaultServerEphemeralDhExportGenerator) {
        this.defaultServerEphemeralDhExportGenerator = defaultServerEphemeralDhExportGenerator;
    }

    public BigInteger getDefaultServerDhExportModulus() {
        return this.defaultServerEphemeralDhExportModulus;
    }

    public void setDefaultServerDhExportModulus(BigInteger defaultServerEphemeralDhExportModulus) {
        if (defaultServerEphemeralDhExportModulus.signum() != 1) {
            throw new IllegalArgumentException("Modulus cannot be negative or zero:" + defaultServerEphemeralDhExportModulus.toString());
        }
        this.defaultServerEphemeralDhExportModulus = defaultServerEphemeralDhExportModulus;
    }

    public BigInteger getDefaultServerDhExportPublicKey() {
        return this.defaultServerEphemeralDhExportPublicKey;
    }

    public void setDefaultServerDhExportPublicKey(BigInteger defaultServerEphemeralDhExportPublicKey) {
        this.defaultServerEphemeralDhExportPublicKey = defaultServerEphemeralDhExportPublicKey;
    }

    public BigInteger getDefaultServerDhExportPrivateKey() {
        return this.defaultServerEphemeralDhExportPrivateKey;
    }

    public void setDefaultServerDhExportPrivateKey(BigInteger defaultServerEphemeralDhExportPrivateKey) {
        this.defaultServerEphemeralDhExportPrivateKey = defaultServerEphemeralDhExportPrivateKey;
    }

    public Point getDefaultTokenBindingECPublicKey() {
        return this.defaultTokenBindingECPublicKey;
    }

    public void setDefaultTokenBindingECPublicKey(Point defaultTokenBindingECPublicKey) {
        this.defaultTokenBindingECPublicKey = defaultTokenBindingECPublicKey;
    }

    public BigInteger getDefaultTokenBindingRsaPublicKey() {
        return this.defaultTokenBindingRsaPublicKey;
    }

    public void setDefaultTokenBindingRsaPublicKey(BigInteger defaultTokenBindingRsaPublicKey) {
        this.defaultTokenBindingRsaPublicKey = defaultTokenBindingRsaPublicKey;
    }

    public BigInteger getDefaultTokenBindingRsaPrivateKey() {
        return this.defaultTokenBindingRsaPrivateKey;
    }

    public void setDefaultTokenBindingRsaPrivateKey(BigInteger defaultTokenBindingRsaPrivateKey) {
        this.defaultTokenBindingRsaPrivateKey = defaultTokenBindingRsaPrivateKey;
    }

    public BigInteger getDefaultTokenBindingEcPrivateKey() {
        return this.defaultTokenBindingEcPrivateKey;
    }

    public void setDefaultTokenBindingEcPrivateKey(BigInteger defaultTokenBindingEcPrivateKey) {
        this.defaultTokenBindingEcPrivateKey = defaultTokenBindingEcPrivateKey;
    }

    public BigInteger getDefaultTokenBindingRsaModulus() {
        return this.defaultTokenBindingRsaModulus;
    }

    public void setDefaultTokenBindingRsaModulus(BigInteger defaultTokenBindingRsaModulus) {
        this.defaultTokenBindingRsaModulus = defaultTokenBindingRsaModulus;
    }

    public TokenBindingType getDefaultTokenBindingType() {
        return this.defaultTokenBindingType;
    }

    public void setDefaultTokenBindingType(TokenBindingType defaultTokenBindingType) {
        this.defaultTokenBindingType = defaultTokenBindingType;
    }

    public byte[] getDefaultClientHandshakeTrafficSecret() {
        return Arrays.copyOf(this.defaultClientHandshakeTrafficSecret, this.defaultClientHandshakeTrafficSecret.length);
    }

    public void setDefaultClientHandshakeTrafficSecret(byte[] defaultClientHandshakeTrafficSecret) {
        this.defaultClientHandshakeTrafficSecret = defaultClientHandshakeTrafficSecret;
    }

    public byte[] getDefaultServerHandshakeTrafficSecret() {
        return Arrays.copyOf(this.defaultServerHandshakeTrafficSecret, this.defaultServerHandshakeTrafficSecret.length);
    }

    public void setDefaultServerHandshakeTrafficSecret(byte[] defaultServerHandshakeTrafficSecret) {
        this.defaultServerHandshakeTrafficSecret = defaultServerHandshakeTrafficSecret;
    }

    public byte[] getDefaultCertificateRequestContext() {
        return Arrays.copyOf(this.defaultCertificateRequestContext, this.defaultCertificateRequestContext.length);
    }

    public void setDefaultCertificateRequestContext(byte[] defaultCertificateRequestContext) {
        this.defaultCertificateRequestContext = defaultCertificateRequestContext;
    }

    public Boolean isWorkflowExecutorShouldOpen() {
        return this.workflowExecutorShouldOpen;
    }

    public void setWorkflowExecutorShouldOpen(Boolean workflowExecutorShouldOpen) {
        this.workflowExecutorShouldOpen = workflowExecutorShouldOpen;
    }

    public Boolean isWorkflowExecutorShouldClose() {
        return this.workflowExecutorShouldClose;
    }

    public void setWorkflowExecutorShouldClose(Boolean workflowExecutorShouldClose) {
        this.workflowExecutorShouldClose = workflowExecutorShouldClose;
    }

    public byte[] getDefaultPSKKey() {
        return Arrays.copyOf(this.defaultPSKKey, this.defaultPSKKey.length);
    }

    public void setDefaultPSKKey(byte[] defaultPSKKey) {
        this.defaultPSKKey = defaultPSKKey;
    }

    public byte[] getDefaultPSKIdentity() {
        return Arrays.copyOf(this.defaultPSKIdentity, this.defaultPSKIdentity.length);
    }

    public void setDefaultPSKIdentity(byte[] defaultPSKIdentity) {
        this.defaultPSKIdentity = defaultPSKIdentity;
    }

    public byte[] getDefaultPSKIdentityHint() {
        return Arrays.copyOf(this.defaultPSKIdentityHint, this.defaultPSKIdentityHint.length);
    }

    public void setDefaultPSKIdentityHint(byte[] defaultPSKIdentityHint) {
        this.defaultPSKIdentityHint = defaultPSKIdentityHint;
    }

    public BigInteger getDefaultSRPModulus() {
        return this.defaultSRPModulus;
    }

    public void setDefaultSRPModulus(BigInteger defaultSRPModulus) {
        this.defaultSRPModulus = defaultSRPModulus;
    }

    public BigInteger getDefaultSRPServerPrivateKey() {
        return this.defaultSRPServerPrivateKey;
    }

    public void setDefaultSRPServerPrivateKey(BigInteger defaultSRPServerPrivateKey) {
        this.defaultSRPServerPrivateKey = defaultSRPServerPrivateKey;
    }

    public BigInteger getDefaultSRPServerPublicKey() {
        return this.defaultSRPServerPublicKey;
    }

    public void setDefaultSRPServerPublicKey(BigInteger defaultSRPServerPublicKey) {
        this.defaultSRPServerPublicKey = defaultSRPServerPublicKey;
    }

    public BigInteger getDefaultSRPClientPrivateKey() {
        return this.defaultSRPClientPrivateKey;
    }

    public void setDefaultSRPClientPrivateKey(BigInteger defaultSRPClientPrivateKey) {
        this.defaultSRPClientPrivateKey = defaultSRPClientPrivateKey;
    }

    public BigInteger getDefaultSRPClientPublicKey() {
        return this.defaultSRPClientPublicKey;
    }

    public void setDefaultSRPClientPublicKey(BigInteger defaultSRPClientPublicKey) {
        this.defaultSRPClientPublicKey = defaultSRPClientPublicKey;
    }

    public BigInteger getDefaultSRPGenerator() {
        return this.defaultSRPGenerator;
    }

    public void setDefaultSRPGenerator(BigInteger defaultSRPGenerator) {
        this.defaultSRPGenerator = defaultSRPGenerator;
    }

    public byte[] getDefaultSRPServerSalt() {
        return Arrays.copyOf(this.defaultSRPServerSalt, this.defaultSRPServerSalt.length);
    }

    public void setDefaultSRPServerSalt(byte[] defaultSRPServerSalt) {
        this.defaultSRPServerSalt = defaultSRPServerSalt;
    }

    public byte[] getDefaultSRPIdentity() {
        return Arrays.copyOf(this.defaultSRPIdentity, this.defaultSRPIdentity.length);
    }

    public void setDefaultSRPIdentity(byte[] defaultSRPIdentity) {
        this.defaultSRPIdentity = defaultSRPIdentity;
    }

    public byte[] getDefaultSRPPassword() {
        return Arrays.copyOf(this.defaultSRPPassword, this.defaultSRPPassword.length);
    }

    public void setDefaultSRPPassword(byte[] defaultSRPPassword) {
        this.defaultSRPPassword = defaultSRPPassword;
    }

    public AlertDescription getDefaultAlertDescription() {
        return this.defaultAlertDescription;
    }

    public void setDefaultAlertDescription(AlertDescription defaultAlertDescription) {
        this.defaultAlertDescription = defaultAlertDescription;
    }

    public AlertLevel getDefaultAlertLevel() {
        return this.defaultAlertLevel;
    }

    public void setDefaultAlertLevel(AlertLevel defaultAlertLevel) {
        this.defaultAlertLevel = defaultAlertLevel;
    }

    public GOSTCurve getDefaultSelectedGostCurve() {
        return this.defaultSelectedGostCurve;
    }

    public void setDefaultSelectedGostCurve(GOSTCurve defaultSelectedGostCurve) {
        this.defaultSelectedGostCurve = defaultSelectedGostCurve;
    }

    public PRFAlgorithm getDefaultPRFAlgorithm() {
        return this.defaultPRFAlgorithm;
    }

    public void setDefaultPRFAlgorithm(PRFAlgorithm defaultPRFAlgorithm) {
        this.defaultPRFAlgorithm = defaultPRFAlgorithm;
    }

    public byte[] getDtlsDefaultCookie() {
        return Arrays.copyOf(this.dtlsDefaultCookie, this.dtlsDefaultCookie.length);
    }

    public void setDtlsDefaultCookie(byte[] defaultDtlsCookie) {
        this.dtlsDefaultCookie = defaultDtlsCookie;
    }

    public Integer getDtlsDefaultCookieLength() {
        return this.dtlsDefaultCookieLength;
    }

    public void setDtlsDefaultCookieLength(Integer dtlsDefaultCookieLength) {
        this.dtlsDefaultCookieLength = dtlsDefaultCookieLength;
    }

    public Integer getDtlsMaximumFragmentLength() {
        return this.dtlsMaximumFragmentLength;
    }

    public void setDtlsMaximumFragmentLength(Integer dtlsMaximumFragmentLength) {
        this.dtlsMaximumFragmentLength = dtlsMaximumFragmentLength;
    }

    public Integer getQuicMaximumFrameSize() {
        return this.quicMaximumFrameSize;
    }

    public void setQuicMaximumFrameSize(Integer quicMaximumFrameSize) {
        this.quicMaximumFrameSize = quicMaximumFrameSize;
    }

    public byte[] getDefaultClientSessionId() {
        return Arrays.copyOf(this.defaultClientSessionId, this.defaultClientSessionId.length);
    }

    public void setDefaultClientSessionId(byte[] defaultClientSessionId) {
        this.defaultClientSessionId = defaultClientSessionId;
    }

    public byte[] getDefaultServerSessionId() {
        return Arrays.copyOf(this.defaultServerSessionId, this.defaultServerSessionId.length);
    }

    public void setDefaultServerSessionId(byte[] defaultServerSessionId) {
        this.defaultServerSessionId = defaultServerSessionId;
    }

    public CompressionMethod getDefaultSelectedCompressionMethod() {
        return this.defaultSelectedCompressionMethod;
    }

    public void setDefaultSelectedCompressionMethod(CompressionMethod defaultSelectedCompressionMethod) {
        this.defaultSelectedCompressionMethod = defaultSelectedCompressionMethod;
    }

    public Boolean isAddQuicTransportParametersExtension() {
        return this.addQuicTransportParametersExtension;
    }

    public void setQuicTransportParametersExtension(Boolean addQuicTransportParameterExtension) {
        this.addQuicTransportParametersExtension = addQuicTransportParameterExtension;
    }

    public Boolean isAddExtendedRandomExtension() {
        return this.addExtendedRandomExtension;
    }

    public void setAddExtendedRandomExtension(Boolean addExtendedRandomExtension) {
        this.addExtendedRandomExtension = addExtendedRandomExtension;
    }

    public byte[] getDefaultClientExtendedRandom() {
        return Arrays.copyOf(this.defaultClientExtendedRandom, this.defaultClientExtendedRandom.length);
    }

    public byte[] getDefaultServerExtendedRandom() {
        return Arrays.copyOf(this.defaultServerExtendedRandom, this.defaultServerExtendedRandom.length);
    }

    public void setDefaultClientExtendedRandom(byte[] defaultClientExtendedRandom) {
        this.defaultClientExtendedRandom = defaultClientExtendedRandom;
    }

    public void setDefaultServerExtendedRandom(byte[] defaultServerExtendedRandom) {
        this.defaultServerExtendedRandom = defaultServerExtendedRandom;
    }

    public byte[] getDefaultServerRandom() {
        return Arrays.copyOf(this.defaultServerRandom, this.defaultServerRandom.length);
    }

    public void setDefaultServerRandom(byte[] defaultServerRandom) {
        this.defaultServerRandom = defaultServerRandom;
    }

    public byte[] getDefaultClientRandom() {
        return Arrays.copyOf(this.defaultClientRandom, this.defaultClientRandom.length);
    }

    public void setDefaultClientRandom(byte[] defaultClientRandom) {
        this.defaultClientRandom = defaultClientRandom;
    }

    public byte[] getDefaultPreMasterSecret() {
        return Arrays.copyOf(this.defaultPreMasterSecret, this.defaultPreMasterSecret.length);
    }

    public void setDefaultPreMasterSecret(byte[] defaultPreMasterSecret) {
        this.defaultPreMasterSecret = defaultPreMasterSecret;
    }

    public byte[] getDefaultMasterSecret() {
        return Arrays.copyOf(this.defaultMasterSecret, this.defaultMasterSecret.length);
    }

    public void setDefaultMasterSecret(byte[] defaultMasterSecret) {
        this.defaultMasterSecret = defaultMasterSecret;
    }

    public ProtocolVersion getDefaultHighestClientProtocolVersion() {
        return this.defaultHighestClientProtocolVersion;
    }

    public void setDefaultHighestClientProtocolVersion(ProtocolVersion defaultHighestClientProtocolVersion) {
        this.defaultHighestClientProtocolVersion = defaultHighestClientProtocolVersion;
    }

    public ProtocolVersion getDefaultSelectedProtocolVersion() {
        return this.defaultSelectedProtocolVersion;
    }

    public void setDefaultSelectedProtocolVersion(ProtocolVersion defaultSelectedProtocolVersion) {
        this.defaultSelectedProtocolVersion = defaultSelectedProtocolVersion;
    }

    public List<SignatureAndHashAlgorithm> getDefaultServerSupportedSignatureAndHashAlgorithms() {
        return this.defaultServerSupportedSignatureAndHashAlgorithms;
    }

    public void setDefaultServerSupportedSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> defaultServerSupportedSignatureAndHashAlgorithms) {
        this.defaultServerSupportedSignatureAndHashAlgorithms = defaultServerSupportedSignatureAndHashAlgorithms;
    }

    public void setDefaultServerSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm ... defaultServerSupportedSignatureAndHashAlgorithms) {
        this.defaultServerSupportedSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(defaultServerSupportedSignatureAndHashAlgorithms));
    }

    public List<SignatureAndHashAlgorithm> getDefaultServerSupportedCertificateSignAlgorithms() {
        return this.defaultServerSupportedCertificateSignAlgorithms;
    }

    public void setDefaultServerSupportedCertificateSignAlgorithms(List<SignatureAndHashAlgorithm> defaultServerSupportedCertificateSignAlgorithms) {
        this.defaultServerSupportedCertificateSignAlgorithms = defaultServerSupportedCertificateSignAlgorithms;
    }

    public void setDefaultServerSupportedCertificateSignAlgorithms(SignatureAndHashAlgorithm ... defaultServerSupportedCertificateSignAlgorithms) {
        this.defaultServerSupportedCertificateSignAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(defaultServerSupportedCertificateSignAlgorithms));
    }

    public List<CipherSuite> getDefaultServerSupportedCipherSuites() {
        return this.defaultServerSupportedCipherSuites;
    }

    public void setDefaultServerSupportedCipherSuites(List<CipherSuite> defaultServerSupportedCipherSuites) {
        this.defaultServerSupportedCipherSuites = defaultServerSupportedCipherSuites;
    }

    public final void setDefaultServerSupportedCipherSuites(CipherSuite ... defaultServerSupportedCipherSuites) {
        this.defaultServerSupportedCipherSuites = new ArrayList<CipherSuite>(Arrays.asList(defaultServerSupportedCipherSuites));
    }

    public List<CompressionMethod> getDefaultClientSupportedCompressionMethods() {
        return this.defaultClientSupportedCompressionMethods;
    }

    public void setDefaultClientSupportedCompressionMethods(List<CompressionMethod> defaultClientSupportedCompressionMethods) {
        this.defaultClientSupportedCompressionMethods = defaultClientSupportedCompressionMethods;
    }

    public final void setDefaultClientSupportedCompressionMethods(CompressionMethod ... defaultClientSupportedCompressionMethods) {
        this.defaultClientSupportedCompressionMethods = new ArrayList<CompressionMethod>(Arrays.asList(defaultClientSupportedCompressionMethods));
    }

    public HeartbeatMode getDefaultHeartbeatMode() {
        return this.defaultHeartbeatMode;
    }

    public void setDefaultHeartbeatMode(HeartbeatMode defaultHeartbeatMode) {
        this.defaultHeartbeatMode = defaultHeartbeatMode;
    }

    public MaxFragmentLength getDefaultMaxFragmentLength() {
        return this.defaultMaxFragmentLength;
    }

    public void setDefaultMaxFragmentLength(MaxFragmentLength defaultMaxFragmentLength) {
        this.defaultMaxFragmentLength = defaultMaxFragmentLength;
    }

    public Integer getInboundRecordSizeLimit() {
        return this.inboundRecordSizeLimit;
    }

    public void setInboundRecordSizeLimit(Integer inboundRecordSizeLimit) {
        this.inboundRecordSizeLimit = inboundRecordSizeLimit;
    }

    public SignatureAndHashAlgorithm getDefaultSelectedSignatureAndHashAlgorithm() {
        return this.defaultSelectedSignatureAndHashAlgorithm;
    }

    public void setDefaultSelectedSignatureAndHashAlgorithm(SignatureAndHashAlgorithm defaultSelectedSignatureAndHashAlgorithm) {
        this.defaultSelectedSignatureAndHashAlgorithm = defaultSelectedSignatureAndHashAlgorithm;
    }

    public SignatureAndHashAlgorithm getDefaultSelectedSignatureAlgorithmCert() {
        return this.defaultSelectedSignatureAlgorithmCert;
    }

    public void setDefaultSelectedSignatureAlgorithmCert(SignatureAndHashAlgorithm defaultSelectedSignatureAlgorithmCert) {
        this.defaultSelectedSignatureAlgorithmCert = defaultSelectedSignatureAlgorithmCert;
    }

    public List<ECPointFormat> getDefaultClientSupportedPointFormats() {
        return this.defaultClientSupportedPointFormats;
    }

    public void setDefaultClientSupportedPointFormats(List<ECPointFormat> defaultClientSupportedPointFormats) {
        this.defaultClientSupportedPointFormats = defaultClientSupportedPointFormats;
    }

    public final void setDefaultClientSupportedPointFormats(ECPointFormat ... defaultClientSupportedPointFormats) {
        this.defaultClientSupportedPointFormats = new ArrayList<ECPointFormat>(Arrays.asList(defaultClientSupportedPointFormats));
    }

    public ProtocolVersion getDefaultLastRecordProtocolVersion() {
        return this.defaultLastRecordProtocolVersion;
    }

    public void setDefaultLastRecordProtocolVersion(ProtocolVersion defaultLastRecordProtocolVersion) {
        this.defaultLastRecordProtocolVersion = defaultLastRecordProtocolVersion;
    }

    public List<ECPointFormat> getDefaultServerSupportedPointFormats() {
        return this.defaultServerSupportedPointFormats;
    }

    public void setDefaultServerSupportedPointFormats(List<ECPointFormat> defaultServerSupportedPointFormats) {
        this.defaultServerSupportedPointFormats = defaultServerSupportedPointFormats;
    }

    public final void setDefaultServerSupportedPointFormats(ECPointFormat ... defaultServerSupportedPointFormats) {
        this.defaultServerSupportedPointFormats = new ArrayList<ECPointFormat>(Arrays.asList(defaultServerSupportedPointFormats));
    }

    public List<NamedGroup> getDefaultClientNamedGroups() {
        return this.defaultClientNamedGroups;
    }

    public void setDefaultClientNamedGroups(List<NamedGroup> defaultClientNamedGroups) {
        this.defaultClientNamedGroups = defaultClientNamedGroups;
    }

    public final void setDefaultClientNamedGroups(NamedGroup ... defaultClientNamedGroups) {
        this.defaultClientNamedGroups = new ArrayList<NamedGroup>(Arrays.asList(defaultClientNamedGroups));
    }

    public List<NamedGroup> getDefaultServerNamedGroups() {
        return this.defaultServerNamedGroups;
    }

    public void setDefaultServerNamedGroups(List<NamedGroup> defaultServerNamedGroups) {
        this.defaultServerNamedGroups = defaultServerNamedGroups;
    }

    public final void setDefaultServerNamedGroups(NamedGroup ... defaultServerNamedGroups) {
        this.defaultServerNamedGroups = new ArrayList<NamedGroup>(Arrays.asList(defaultServerNamedGroups));
    }

    public CipherSuite getDefaultSelectedCipherSuite() {
        return this.defaultSelectedCipherSuite;
    }

    public void setDefaultSelectedCipherSuite(CipherSuite defaultSelectedCipherSuite) {
        this.defaultSelectedCipherSuite = defaultSelectedCipherSuite;
    }

    public SSL2CipherSuite getDefaultSSL2CipherSuite() {
        return this.defaultSSL2CipherSuite;
    }

    public void setDefaultSSL2CipherSuite(SSL2CipherSuite defaultSSL2CipherSuite) {
        this.defaultSSL2CipherSuite = defaultSSL2CipherSuite;
    }

    public Integer getReceiveMaximumBytes() {
        return this.receiveMaximumBytes;
    }

    public void setReceiveMaximumBytes(int receiveMaximumBytes) {
        this.receiveMaximumBytes = receiveMaximumBytes;
    }

    public Boolean isResetWorkflowTracesBeforeSaving() {
        return this.resetWorkflowTracesBeforeSaving;
    }

    public void setResetWorkflowTracesBeforeSaving(Boolean resetWorkflowTracesBeforeSaving) {
        this.resetWorkflowTracesBeforeSaving = resetWorkflowTracesBeforeSaving;
    }

    public Boolean isFlushOnMessageTypeChange() {
        return this.flushOnMessageTypeChange;
    }

    public void setFlushOnMessageTypeChange(Boolean flushOnMessageTypeChange) {
        this.flushOnMessageTypeChange = flushOnMessageTypeChange;
    }

    public Boolean isCreateFragmentsDynamically() {
        return this.createFragmentsDynamically;
    }

    public void setCreateFragmentsDynamically(Boolean createFragmentsDynamically) {
        this.createFragmentsDynamically = createFragmentsDynamically;
    }

    public Boolean isCreateRecordsDynamically() {
        return this.createRecordsDynamically;
    }

    public void setCreateRecordsDynamically(Boolean createRecordsDynamically) {
        this.createRecordsDynamically = createRecordsDynamically;
    }

    public Boolean isIndividualTransportPacketsForFragments() {
        return this.individualTransportPacketsForFragments;
    }

    public void setIndividualTransportPacketsForFragments(Boolean individualTransportPacketsForFragments) {
        this.individualTransportPacketsForFragments = individualTransportPacketsForFragments;
    }

    public Integer getIndividualTransportPacketCooldown() {
        return this.individualTransportPacketCooldown;
    }

    public void setIndividualTransportPacketCooldown(Integer individualTransportPacketCooldown) {
        this.individualTransportPacketCooldown = individualTransportPacketCooldown;
    }

    public Integer getDefaultMaxRecordData() {
        return this.defaultMaxRecordData;
    }

    public void setDefaultMaxRecordData(int defaultMaxRecordData) {
        if (defaultMaxRecordData == 0) {
            LOGGER.warn("defaultMaxRecordData is being set to 0");
        }
        this.defaultMaxRecordData = defaultMaxRecordData;
    }

    public WorkflowExecutorType getWorkflowExecutorType() {
        return this.workflowExecutorType;
    }

    public void setWorkflowExecutorType(WorkflowExecutorType workflowExecutorType) {
        this.workflowExecutorType = workflowExecutorType;
    }

    public SniType getSniType() {
        return this.sniType;
    }

    public void setSniType(SniType sniType) {
        this.sniType = sniType;
    }

    public Integer getHeartbeatPayloadLength() {
        return this.heartbeatPayloadLength;
    }

    public void setHeartbeatPayloadLength(int heartbeatPayloadLength) {
        this.heartbeatPayloadLength = heartbeatPayloadLength;
    }

    public Integer getHeartbeatPaddingLength() {
        return this.heartbeatPaddingLength;
    }

    public void setHeartbeatPaddingLength(int heartbeatPaddingLength) {
        this.heartbeatPaddingLength = heartbeatPaddingLength;
    }

    public Boolean isAddPaddingExtension() {
        return this.addPaddingExtension;
    }

    public void setAddPaddingExtension(Boolean addPaddingExtension) {
        this.addPaddingExtension = addPaddingExtension;
    }

    public Boolean isAddExtendedMasterSecretExtension() {
        return this.addExtendedMasterSecretExtension;
    }

    public void setAddExtendedMasterSecretExtension(Boolean addExtendedMasterSecretExtension) {
        this.addExtendedMasterSecretExtension = addExtendedMasterSecretExtension;
    }

    public Boolean isAddSessionTicketTLSExtension() {
        return this.addSessionTicketTLSExtension;
    }

    public void setAddSessionTicketTLSExtension(Boolean addSessionTicketTLSExtension) {
        this.addSessionTicketTLSExtension = addSessionTicketTLSExtension;
    }

    public byte[] getDefaultPaddingExtensionBytes() {
        return Arrays.copyOf(this.defaultPaddingExtensionBytes, this.defaultPaddingExtensionBytes.length);
    }

    public void setDefaultPaddingExtensionBytes(byte[] defaultPaddingExtensionBytes) {
        this.defaultPaddingExtensionBytes = defaultPaddingExtensionBytes;
    }

    public List<ClientCertificateType> getClientCertificateTypes() {
        return this.clientCertificateTypes;
    }

    public void setClientCertificateTypes(List<ClientCertificateType> clientCertificateTypes) {
        this.clientCertificateTypes = clientCertificateTypes;
    }

    public final void setClientCertificateTypes(ClientCertificateType ... clientCertificateTypes) {
        this.clientCertificateTypes = new ArrayList<ClientCertificateType>(Arrays.asList(clientCertificateTypes));
    }

    public String getDefaultApplicationMessageData() {
        return this.defaultApplicationMessageData;
    }

    public void setDefaultApplicationMessageData(String defaultApplicationMessageData) {
        this.defaultApplicationMessageData = defaultApplicationMessageData;
    }

    public Boolean isEnforceSettings() {
        return this.enforceSettings;
    }

    public void setEnforceSettings(Boolean enforceSettings) {
        this.enforceSettings = enforceSettings;
    }

    public byte[] getDistinguishedNames() {
        return Arrays.copyOf(this.distinguishedNames, this.distinguishedNames.length);
    }

    public void setDistinguishedNames(byte[] distinguishedNames) {
        this.distinguishedNames = distinguishedNames;
    }

    public ProtocolVersion getHighestProtocolVersion() {
        return this.highestProtocolVersion;
    }

    public void setHighestProtocolVersion(ProtocolVersion highestProtocolVersion) {
        this.highestProtocolVersion = highestProtocolVersion;
    }

    public Boolean isServerSendsApplicationData() {
        return this.serverSendsApplicationData;
    }

    public void setServerSendsApplicationData(Boolean serverSendsApplicationData) {
        this.serverSendsApplicationData = serverSendsApplicationData;
    }

    public WorkflowTraceType getWorkflowTraceType() {
        return this.workflowTraceType;
    }

    public void setWorkflowTraceType(WorkflowTraceType workflowTraceType) {
        this.workflowTraceType = workflowTraceType;
    }

    public NamedGroup getDefaultSelectedNamedGroup() {
        return this.defaultSelectedNamedGroup;
    }

    public void setDefaultSelectedNamedGroup(NamedGroup defaultSelectedNamedGroup) {
        this.defaultSelectedNamedGroup = defaultSelectedNamedGroup;
    }

    public Boolean isDynamicWorkflow() {
        throw new UnsupportedOperationException("DynamicWorkflow is currently not supported.");
    }

    public void setDynamicWorkflow(Boolean dynamicWorkflow) {
        throw new UnsupportedOperationException("DynamicWorkflow is currently not supported.");
    }

    public List<CipherSuite> getDefaultClientSupportedCipherSuites() {
        return this.defaultClientSupportedCipherSuites;
    }

    public void setDefaultClientSupportedCipherSuites(List<CipherSuite> defaultClientSupportedCipherSuites) {
        this.defaultClientSupportedCipherSuites = defaultClientSupportedCipherSuites;
    }

    public final void setDefaultClientSupportedCipherSuites(CipherSuite ... defaultClientSupportedCipherSuites) {
        this.defaultClientSupportedCipherSuites = new ArrayList<CipherSuite>(Arrays.asList(defaultClientSupportedCipherSuites));
    }

    public Boolean isDtlsCookieExchange() {
        return this.dtlsCookieExchange;
    }

    public void setDtlsCookieExchange(Boolean dtlsCookieExchange) {
        this.dtlsCookieExchange = dtlsCookieExchange;
    }

    public Boolean isClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(Boolean clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public List<SignatureAndHashAlgorithm> getDefaultClientSupportedSignatureAndHashAlgorithms() {
        return this.defaultClientSupportedSignatureAndHashAlgorithms;
    }

    public void setDefaultClientSupportedSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> defaultClientSupportedSignatureAndHashAlgorithms) {
        this.defaultClientSupportedSignatureAndHashAlgorithms = defaultClientSupportedSignatureAndHashAlgorithms;
    }

    public final void setDefaultClientSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm ... supportedSignatureAndHashAlgorithms) {
        this.defaultClientSupportedSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(supportedSignatureAndHashAlgorithms));
    }

    public List<SignatureAndHashAlgorithm> getDefaultClientSupportedCertificateSignAlgorithms() {
        return this.defaultClientSupportedCertificateSignAlgorithms;
    }

    public void setDefaultClientSupportedCertificateSignAlgorithms(List<SignatureAndHashAlgorithm> defaultClientSupportedCertificateSignAlgorithms) {
        this.defaultClientSupportedCertificateSignAlgorithms = defaultClientSupportedCertificateSignAlgorithms;
    }

    public final void setDefaultClientSupportedCertificateSignAlgorithms(SignatureAndHashAlgorithm ... supportedSignatureAndHashAlgorithms) {
        this.defaultClientSupportedCertificateSignAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(supportedSignatureAndHashAlgorithms));
    }

    public List<ProtocolVersion> getSupportedVersions() {
        return this.supportedVersions;
    }

    public void setSupportedVersions(List<ProtocolVersion> supportedVersions) {
        this.supportedVersions = supportedVersions;
    }

    public final void setSupportedVersions(ProtocolVersion ... supportedVersions) {
        this.supportedVersions = new ArrayList<ProtocolVersion>(Arrays.asList(supportedVersions));
    }

    public HeartbeatMode getHeartbeatMode() {
        return this.heartbeatMode;
    }

    public void setHeartbeatMode(HeartbeatMode heartbeatMode) {
        this.heartbeatMode = heartbeatMode;
    }

    public Boolean isAddECPointFormatExtension() {
        return this.addECPointFormatExtension;
    }

    public void setAddECPointFormatExtension(Boolean addECPointFormatExtension) {
        this.addECPointFormatExtension = addECPointFormatExtension;
    }

    public Boolean isAddExtensionsInSSL() {
        return this.addExtensionsInSSL;
    }

    public void setAddExtensionsInSSL(Boolean addExtensionsInSSL) {
        this.addExtensionsInSSL = addExtensionsInSSL;
    }

    public Boolean isAddEllipticCurveExtension() {
        return this.addEllipticCurveExtension;
    }

    public void setAddEllipticCurveExtension(Boolean addEllipticCurveExtension) {
        this.addEllipticCurveExtension = addEllipticCurveExtension;
    }

    public Boolean isAddHeartbeatExtension() {
        return this.addHeartbeatExtension;
    }

    public void setAddHeartbeatExtension(Boolean addHeartbeatExtension) {
        this.addHeartbeatExtension = addHeartbeatExtension;
    }

    public Boolean isAddMaxFragmentLengthExtension() {
        return this.addMaxFragmentLengthExtension;
    }

    public void setAddMaxFragmentLengthExtension(Boolean addMaxFragmentLengthExtension) {
        this.addMaxFragmentLengthExtension = addMaxFragmentLengthExtension;
    }

    public Boolean isAddRecordSizeLimitExtension() {
        return this.addRecordSizeLimitExtension;
    }

    public void setAddRecordSizeLimitExtension(Boolean addRecordSizeLimitExtension) {
        this.addRecordSizeLimitExtension = addRecordSizeLimitExtension;
    }

    public Boolean isAddServerNameIndicationExtension() {
        return this.addServerNameIndicationExtension;
    }

    public void setAddServerNameIndicationExtension(Boolean addServerNameIndicationExtension) {
        this.addServerNameIndicationExtension = addServerNameIndicationExtension;
    }

    public Boolean isAddSignatureAndHashAlgorithmsExtension() {
        return this.addSignatureAndHashAlgorithmsExtension;
    }

    public void setAddSignatureAndHashAlgorithmsExtension(Boolean addSignatureAndHashAlgorithmsExtension) {
        this.addSignatureAndHashAlgorithmsExtension = addSignatureAndHashAlgorithmsExtension;
    }

    public Boolean isAddSignatureAlgorithmsCertExtension() {
        return this.addSignatureAlgorithmsCertExtension;
    }

    public void setAddSignatureAlgorithmsCertExtension(Boolean addSignatureAlgorithmsCertExtension) {
        this.addSignatureAlgorithmsCertExtension = addSignatureAlgorithmsCertExtension;
    }

    public Boolean isAddSupportedVersionsExtension() {
        return this.addSupportedVersionsExtension;
    }

    public void setAddSupportedVersionsExtension(Boolean addSupportedVersionsExtension) {
        this.addSupportedVersionsExtension = addSupportedVersionsExtension;
    }

    public Boolean isAddKeyShareExtension() {
        return this.addKeyShareExtension;
    }

    public void setAddKeyShareExtension(Boolean addKeyShareExtension) {
        this.addKeyShareExtension = addKeyShareExtension;
    }

    public Boolean isAddEarlyDataExtension() {
        return this.addEarlyDataExtension;
    }

    public Boolean isAddDebugExtension() {
        return this.addDebugExtension;
    }

    public void setAddEarlyDataExtension(Boolean addEarlyDataExtension) {
        this.addEarlyDataExtension = addEarlyDataExtension;
    }

    public void setAddDebugExtension(Boolean addDebugExtension) {
        this.addDebugExtension = addDebugExtension;
    }

    public Boolean isAddEncryptedServerNameIndicationExtension() {
        return this.addEncryptedServerNameIndicationExtension;
    }

    public void setAddEncryptedServerNameIndicationExtension(Boolean addEncryptedServerNameIndicationExtension) {
        this.addEncryptedServerNameIndicationExtension = addEncryptedServerNameIndicationExtension;
    }

    public Boolean isAddEncryptedClientHelloExtension() {
        return this.addEncryptedClientHelloExtension;
    }

    public void setAddEncryptedClientHelloExtension(Boolean addEncryptedClientHelloExtension) {
        this.addEncryptedClientHelloExtension = addEncryptedClientHelloExtension;
    }

    public void setAddPWDClearExtension(Boolean addPWDClearExtension) {
        this.addPWDClearExtension = addPWDClearExtension;
    }

    public Boolean isAddPSKKeyExchangeModesExtension() {
        return this.addPSKKeyExchangeModesExtension;
    }

    public void setAddPSKKeyExchangeModesExtension(Boolean addPSKKeyExchangeModesExtension) {
        this.addPSKKeyExchangeModesExtension = addPSKKeyExchangeModesExtension;
    }

    public Boolean isAddPreSharedKeyExtension() {
        return this.addPreSharedKeyExtension;
    }

    public Boolean isAddPWDClearExtension() {
        return this.addPWDClearExtension;
    }

    public void setAddPreSharedKeyExtension(Boolean addPreSharedKeyExtension) {
        this.addPreSharedKeyExtension = addPreSharedKeyExtension;
    }

    public void setPSKKeyExchangeModes(List<PskKeyExchangeMode> pskKeyExchangeModes) {
        this.pskKeyExchangeModes = pskKeyExchangeModes;
    }

    public List<PskKeyExchangeMode> getPSKKeyExchangeModes() {
        return this.pskKeyExchangeModes;
    }

    public Integer getDefaultAdditionalPadding() {
        return this.defaultAdditionalPadding;
    }

    public void setDefaultAdditionalPadding(Integer defaultAdditionalPadding) {
        this.defaultAdditionalPadding = defaultAdditionalPadding;
    }

    public byte[] getTlsSessionTicket() {
        return Arrays.copyOf(this.tlsSessionTicket, this.tlsSessionTicket.length);
    }

    public void setTlsSessionTicket(byte[] tlsSessionTicket) {
        this.tlsSessionTicket = tlsSessionTicket;
    }

    public byte[] getDefaultSignedCertificateTimestamp() {
        return Arrays.copyOf(this.defaultSignedCertificateTimestamp, this.defaultSignedCertificateTimestamp.length);
    }

    public void setDefaultSignedCertificateTimestamp(byte[] defaultSignedCertificateTimestamp) {
        this.defaultSignedCertificateTimestamp = defaultSignedCertificateTimestamp;
    }

    public Boolean isAddSignedCertificateTimestampExtension() {
        return this.addSignedCertificateTimestampExtension;
    }

    public void setAddSignedCertificateTimestampExtension(Boolean addSignedCertificateTimestampExtension) {
        this.addSignedCertificateTimestampExtension = addSignedCertificateTimestampExtension;
    }

    public byte[] getDefaultClientRenegotiationInfo() {
        return Arrays.copyOf(this.defaultClientRenegotiationInfo, this.defaultClientRenegotiationInfo.length);
    }

    public void setDefaultClientRenegotiationInfo(byte[] defaultClientRenegotiationInfo) {
        this.defaultClientRenegotiationInfo = defaultClientRenegotiationInfo;
    }

    public Boolean isAddRenegotiationInfoExtension() {
        return this.addRenegotiationInfoExtension;
    }

    public void setAddRenegotiationInfoExtension(Boolean addRenegotiationInfoExtension) {
        this.addRenegotiationInfoExtension = addRenegotiationInfoExtension;
    }

    public TokenBindingVersion getDefaultTokenBindingVersion() {
        return this.defaultTokenBindingVersion;
    }

    public void setDefaultTokenBindingVersion(TokenBindingVersion defaultTokenBindingVersion) {
        this.defaultTokenBindingVersion = defaultTokenBindingVersion;
    }

    public List<TokenBindingKeyParameters> getDefaultTokenBindingKeyParameters() {
        return this.defaultTokenBindingKeyParameters;
    }

    public void setDefaultTokenBindingKeyParameters(List<TokenBindingKeyParameters> defaultTokenBindingKeyParameters) {
        this.defaultTokenBindingKeyParameters = defaultTokenBindingKeyParameters;
    }

    public final void setDefaultTokenBindingKeyParameters(TokenBindingKeyParameters ... defaultTokenBindingKeyParameters) {
        this.defaultTokenBindingKeyParameters = new ArrayList<TokenBindingKeyParameters>(Arrays.asList(defaultTokenBindingKeyParameters));
    }

    public Boolean isAddTokenBindingExtension() {
        return this.addTokenBindingExtension;
    }

    public void setAddTokenBindingExtension(Boolean addTokenBindingExtension) {
        this.addTokenBindingExtension = addTokenBindingExtension;
    }

    public Boolean isAddHttpCookie() {
        return this.addHttpCookie;
    }

    public void setAddHttpCookie(Boolean addHttpCookie) {
        this.addHttpCookie = addHttpCookie;
    }

    public String getDefaultHttpCookieName() {
        return this.defaultHttpCookieName;
    }

    public void setDefaultHttpCookieName(String defaultHttpCookieName) {
        this.defaultHttpCookieName = defaultHttpCookieName;
    }

    public String getDefaultHttpCookieValue() {
        return this.defaultHttpCookieValue;
    }

    public void setDefaultHttpCookieValue(String defaultHttpCookieValue) {
        this.defaultHttpCookieValue = defaultHttpCookieValue;
    }

    public CertificateStatusRequestType getCertificateStatusRequestExtensionRequestType() {
        return this.certificateStatusRequestExtensionRequestType;
    }

    public void setCertificateStatusRequestExtensionRequestType(CertificateStatusRequestType certificateStatusRequestExtensionRequestType) {
        this.certificateStatusRequestExtensionRequestType = certificateStatusRequestExtensionRequestType;
    }

    public byte[] getCertificateStatusRequestExtensionResponderIDList() {
        return Arrays.copyOf(this.certificateStatusRequestExtensionResponderIDList, this.certificateStatusRequestExtensionResponderIDList.length);
    }

    public void setCertificateStatusRequestExtensionResponderIDList(byte[] certificateStatusRequestExtensionResponderIDList) {
        this.certificateStatusRequestExtensionResponderIDList = certificateStatusRequestExtensionResponderIDList;
    }

    public byte[] getCertificateStatusRequestExtensionRequestExtension() {
        return Arrays.copyOf(this.certificateStatusRequestExtensionRequestExtension, this.certificateStatusRequestExtensionRequestExtension.length);
    }

    public void setCertificateStatusRequestExtensionRequestExtension(byte[] certificateStatusRequestExtensionRequestExtension) {
        this.certificateStatusRequestExtensionRequestExtension = certificateStatusRequestExtensionRequestExtension;
    }

    public byte[] getSecureRemotePasswordExtensionIdentifier() {
        return Arrays.copyOf(this.secureRemotePasswordExtensionIdentifier, this.secureRemotePasswordExtensionIdentifier.length);
    }

    public void setSecureRemotePasswordExtensionIdentifier(byte[] secureRemotePasswordExtensionIdentifier) {
        this.secureRemotePasswordExtensionIdentifier = secureRemotePasswordExtensionIdentifier;
    }

    public List<SrtpProtectionProfile> getClientSupportedSrtpProtectionProfiles() {
        return this.clientSupportedSrtpProtectionProfiles;
    }

    public void setClientSupportedSrtpProtectionProfiles(List<SrtpProtectionProfile> secureRealTimeTransportProtocolProtectionProfiles) {
        this.clientSupportedSrtpProtectionProfiles = secureRealTimeTransportProtocolProtectionProfiles;
    }

    public byte[] getSecureRealTimeTransportProtocolMasterKeyIdentifier() {
        return Arrays.copyOf(this.secureRealTimeTransportProtocolMasterKeyIdentifier, this.secureRealTimeTransportProtocolMasterKeyIdentifier.length);
    }

    public void setSecureRealTimeTransportProtocolMasterKeyIdentifier(byte[] secureRealTimeTransportProtocolMasterKeyIdentifier) {
        this.secureRealTimeTransportProtocolMasterKeyIdentifier = secureRealTimeTransportProtocolMasterKeyIdentifier;
    }

    public UserMappingExtensionHintType getUserMappingExtensionHintType() {
        return this.userMappingExtensionHintType;
    }

    public void setUserMappingExtensionHintType(UserMappingExtensionHintType userMappingExtensionHintType) {
        this.userMappingExtensionHintType = userMappingExtensionHintType;
    }

    public List<CertificateType> getCertificateTypeDesiredTypes() {
        return this.certificateTypeDesiredTypes;
    }

    public void setCertificateTypeDesiredTypes(List<CertificateType> certificateTypeDesiredTypes) {
        this.certificateTypeDesiredTypes = certificateTypeDesiredTypes;
    }

    public List<CertificateType> getClientCertificateTypeDesiredTypes() {
        return this.clientCertificateTypeDesiredTypes;
    }

    public void setClientCertificateTypeDesiredTypes(List<CertificateType> clientCertificateTypeDesiredTypes) {
        this.clientCertificateTypeDesiredTypes = clientCertificateTypeDesiredTypes;
    }

    public List<CertificateType> getServerCertificateTypeDesiredTypes() {
        return this.serverCertificateTypeDesiredTypes;
    }

    public void setServerCertificateTypeDesiredTypes(List<CertificateType> serverCertificateTypeDesiredTypes) {
        this.serverCertificateTypeDesiredTypes = serverCertificateTypeDesiredTypes;
    }

    public List<AuthzDataFormat> getClientAuthzExtensionDataFormat() {
        return this.clientAuthzExtensionDataFormat;
    }

    public void setClientAuthzExtensionDataFormat(List<AuthzDataFormat> clientAuthzExtensionDataFormat) {
        this.clientAuthzExtensionDataFormat = clientAuthzExtensionDataFormat;
    }

    public Boolean isCertificateTypeExtensionMessageState() {
        return this.certificateTypeExtensionMessageState;
    }

    public void setCertificateTypeExtensionMessageState(Boolean certificateTypeExtensionMessageState) {
        this.certificateTypeExtensionMessageState = certificateTypeExtensionMessageState;
    }

    public List<AuthzDataFormat> getServerAuthzExtensionDataFormat() {
        return this.serverAuthzExtensionDataFormat;
    }

    public void setServerAuthzExtensionDataFormat(List<AuthzDataFormat> serverAuthzExtensionDataFormat) {
        this.serverAuthzExtensionDataFormat = serverAuthzExtensionDataFormat;
    }

    public List<TrustedAuthority> getTrustedCaIndicationExtensionAuthorities() {
        return this.trustedCaIndicationExtensionAuthorities;
    }

    public void setTrustedCaIndicationExtensionAuthorities(List<TrustedAuthority> trustedCaIndicationExtensionAuthorities) {
        this.trustedCaIndicationExtensionAuthorities = trustedCaIndicationExtensionAuthorities;
    }

    public Boolean isClientCertificateTypeExtensionMessageState() {
        return this.clientCertificateTypeExtensionMessageState;
    }

    public void setClientCertificateTypeExtensionMessageState(Boolean clientCertificateTypeExtensionMessageState) {
        this.clientCertificateTypeExtensionMessageState = clientCertificateTypeExtensionMessageState;
    }

    public Boolean isCachedInfoExtensionIsClientState() {
        return this.cachedInfoExtensionIsClientState;
    }

    public void setCachedInfoExtensionIsClientState(Boolean cachedInfoExtensionIsClientState) {
        this.cachedInfoExtensionIsClientState = cachedInfoExtensionIsClientState;
    }

    public List<CachedObject> getCachedObjectList() {
        return this.cachedObjectList;
    }

    public void setCachedObjectList(List<CachedObject> cachedObjectList) {
        this.cachedObjectList = cachedObjectList;
    }

    public List<RequestItemV2> getStatusRequestV2RequestList() {
        return this.statusRequestV2RequestList;
    }

    public void setStatusRequestV2RequestList(List<RequestItemV2> statusRequestV2RequestList) {
        this.statusRequestV2RequestList = statusRequestV2RequestList;
    }

    public Boolean isAddCertificateStatusRequestExtension() {
        return this.addCertificateStatusRequestExtension;
    }

    public void setAddCertificateStatusRequestExtension(Boolean addCertificateStatusRequestExtension) {
        this.addCertificateStatusRequestExtension = addCertificateStatusRequestExtension;
    }

    public Boolean isAddAlpnExtension() {
        return this.addAlpnExtension;
    }

    public void setAddAlpnExtension(Boolean addAlpnExtension) {
        this.addAlpnExtension = addAlpnExtension;
    }

    public Boolean isAddSRPExtension() {
        return this.addSRPExtension;
    }

    public void setAddSRPExtension(Boolean addSRPExtension) {
        this.addSRPExtension = addSRPExtension;
    }

    public Boolean isAddSRTPExtension() {
        return this.addSRTPExtension;
    }

    public void setAddSRTPExtension(Boolean addSRTPExtension) {
        this.addSRTPExtension = addSRTPExtension;
    }

    public Boolean isAddTruncatedHmacExtension() {
        return this.addTruncatedHmacExtension;
    }

    public void setAddTruncatedHmacExtension(Boolean addTruncatedHmacExtension) {
        this.addTruncatedHmacExtension = addTruncatedHmacExtension;
    }

    public Boolean isAddUserMappingExtension() {
        return this.addUserMappingExtension;
    }

    public void setAddUserMappingExtension(Boolean addUserMappingExtension) {
        this.addUserMappingExtension = addUserMappingExtension;
    }

    public Boolean isAddCertificateTypeExtension() {
        return this.addCertificateTypeExtension;
    }

    public void setAddCertificateTypeExtension(Boolean addCertificateTypeExtension) {
        this.addCertificateTypeExtension = addCertificateTypeExtension;
    }

    public Boolean isAddClientAuthzExtension() {
        return this.addClientAuthzExtension;
    }

    public void setAddClientAuthzExtension(Boolean addClientAuthzExtension) {
        this.addClientAuthzExtension = addClientAuthzExtension;
    }

    public Boolean isAddServerAuthzExtension() {
        return this.addServerAuthzExtension;
    }

    public void setAddServerAuthzExtension(Boolean addServerAuthzExtension) {
        this.addServerAuthzExtension = addServerAuthzExtension;
    }

    public Boolean isAddClientCertificateTypeExtension() {
        return this.addClientCertificateTypeExtension;
    }

    public void setAddClientCertificateTypeExtension(Boolean addClientCertificateTypeExtension) {
        this.addClientCertificateTypeExtension = addClientCertificateTypeExtension;
    }

    public Boolean isAddServerCertificateTypeExtension() {
        return this.addServerCertificateTypeExtension;
    }

    public void setAddServerCertificateTypeExtension(Boolean addServerCertificateTypeExtension) {
        this.addServerCertificateTypeExtension = addServerCertificateTypeExtension;
    }

    public Boolean isAddEncryptThenMacExtension() {
        return this.addEncryptThenMacExtension;
    }

    public void setAddEncryptThenMacExtension(Boolean addEncryptThenMacExtension) {
        this.addEncryptThenMacExtension = addEncryptThenMacExtension;
    }

    public Boolean isAddCachedInfoExtension() {
        return this.addCachedInfoExtension;
    }

    public void setAddCachedInfoExtension(Boolean addCachedInfoExtension) {
        this.addCachedInfoExtension = addCachedInfoExtension;
    }

    public Boolean isAddClientCertificateUrlExtension() {
        return this.addClientCertificateUrlExtension;
    }

    public void setAddClientCertificateUrlExtension(Boolean addClientCertificateUrlExtension) {
        this.addClientCertificateUrlExtension = addClientCertificateUrlExtension;
    }

    public Boolean isAddTrustedCaIndicationExtension() {
        return this.addTrustedCaIndicationExtension;
    }

    public void setAddTrustedCaIndicationExtension(Boolean addTrustedCaIndicationExtension) {
        this.addTrustedCaIndicationExtension = addTrustedCaIndicationExtension;
    }

    public Boolean isAddCertificateStatusRequestV2Extension() {
        return this.addCertificateStatusRequestV2Extension;
    }

    public void setAddCertificateStatusRequestV2Extension(Boolean addCertificateStatusRequestV2Extension) {
        this.addCertificateStatusRequestV2Extension = addCertificateStatusRequestV2Extension;
    }

    public List<CompressionMethod> getDefaultServerSupportedCompressionMethods() {
        return this.defaultServerSupportedCompressionMethods;
    }

    public void setDefaultServerSupportedCompressionMethods(List<CompressionMethod> defaultServerSupportedCompressionMethods) {
        this.defaultServerSupportedCompressionMethods = defaultServerSupportedCompressionMethods;
    }

    public void setDefaultServerSupportedCompressionMethods(CompressionMethod ... defaultServerSupportedCompressionMethods) {
        this.defaultServerSupportedCompressionMethods = new ArrayList<CompressionMethod>(Arrays.asList(defaultServerSupportedCompressionMethods));
    }

    public OutboundConnection getDefaultClientConnection() {
        return this.defaultClientConnection;
    }

    public void setDefaultClientConnection(OutboundConnection defaultClientConnection) {
        this.defaultClientConnection = defaultClientConnection;
    }

    public InboundConnection getDefaultServerConnection() {
        return this.defaultServerConnection;
    }

    public void setDefaultServerConnection(InboundConnection defaultServerConnection) {
        this.defaultServerConnection = defaultServerConnection;
    }

    public Boolean isReceiveFinalTcpSocketStateWithTimeout() {
        return this.receiveFinalTcpSocketStateWithTimeout;
    }

    public void setReceiveFinalTcpSocketStateWithTimeout(Boolean receiveFinalTcpSocketStateWithTimeout) {
        this.receiveFinalTcpSocketStateWithTimeout = receiveFinalTcpSocketStateWithTimeout;
    }

    public RunningModeType getDefaultRunningMode() {
        return this.defaultRunningMode;
    }

    public void setDefaultRunningMode(RunningModeType defaultRunningMode) {
        this.defaultRunningMode = defaultRunningMode;
    }

    public Boolean isStopActionsAfterFatal() {
        return this.stopActionsAfterFatal;
    }

    public void setStopActionsAfterFatal(Boolean stopActionsAfterFatal) {
        this.stopActionsAfterFatal = stopActionsAfterFatal;
    }

    public Boolean isStopActionAfterQuicConnCloseFrame() {
        return this.stopActionsAfterQuicConnectionClose;
    }

    public void setStopActionAfterQuicConnCloseFrame(Boolean stopActionsAfterQuicConnectionClose) {
        this.stopActionsAfterQuicConnectionClose = stopActionsAfterQuicConnectionClose;
    }

    public Boolean isFinishWithCloseNotify() {
        return this.finishWithCloseNotify;
    }

    public void setFinishWithCloseNotify(Boolean finishWithCloseNotify) {
        this.finishWithCloseNotify = finishWithCloseNotify;
    }

    public Boolean isIgnoreRetransmittedCcsInDtls() {
        return this.ignoreRetransmittedCcsInDtls;
    }

    public void setIgnoreRetransmittedCssInDtls(Boolean ignoreRetransmittedCcs) {
        this.ignoreRetransmittedCcsInDtls = ignoreRetransmittedCcs;
    }

    public Boolean isAddRetransmissionsToWorkflowTraceInDtls() {
        return this.addRetransmissionsToWorkflowTraceInDtls;
    }

    public void setAddRetransmissionsToWorkflowTraceInDtls(Boolean addRetransmissionsToWorkflowTrace) {
        this.addRetransmissionsToWorkflowTraceInDtls = addRetransmissionsToWorkflowTrace;
    }

    public int getMaxUDPRetransmissions() {
        return this.maxUDPRetransmissions;
    }

    public void setMaxUDPRetransmissions(int maxRetransmissions) {
        this.maxUDPRetransmissions = maxRetransmissions;
    }

    public List<FilterType> getOutputFilters() {
        return this.outputFilters;
    }

    public void setOutputFilters(List<FilterType> outputFilters) {
        this.outputFilters = outputFilters;
    }

    public Boolean isApplyFiltersInPlace() {
        return this.applyFiltersInPlace;
    }

    public void setApplyFiltersInPlace(Boolean applyFiltersInPlace) {
        this.applyFiltersInPlace = applyFiltersInPlace;
    }

    public Boolean isFiltersKeepUserSettings() {
        return this.filtersKeepUserSettings;
    }

    public void setFiltersKeepUserSettings(Boolean filtersKeepUserSettings) {
        this.filtersKeepUserSettings = filtersKeepUserSettings;
    }

    public byte[] getDefaultClientApplicationTrafficSecret() {
        return Arrays.copyOf(this.defaultClientApplicationTrafficSecret, this.defaultClientApplicationTrafficSecret.length);
    }

    public void setDefaultClientApplicationTrafficSecret(byte[] defaultClientApplicationTrafficSecret) {
        this.defaultClientApplicationTrafficSecret = defaultClientApplicationTrafficSecret;
    }

    public byte[] getDefaultServerApplicationTrafficSecret() {
        return Arrays.copyOf(this.defaultServerApplicationTrafficSecret, this.defaultServerApplicationTrafficSecret.length);
    }

    public void setDefaultServerApplicationTrafficSecret(byte[] defaultServerApplicationTrafficSecret) {
        this.defaultServerApplicationTrafficSecret = defaultServerApplicationTrafficSecret;
    }

    public byte[] getEarlyData() {
        return Arrays.copyOf(this.earlyData, this.earlyData.length);
    }

    public void setEarlyData(byte[] earlyData) {
        this.earlyData = earlyData;
    }

    public List<PskSet> getDefaultPskSets() {
        return this.defaultPskSets;
    }

    public void setDefaultPskSets(List<PskSet> defaultPskSets) {
        this.defaultPskSets = defaultPskSets;
    }

    public byte[] getPsk() {
        return Arrays.copyOf(this.psk, this.psk.length);
    }

    public void setPsk(byte[] psk) {
        this.psk = psk;
    }

    public byte[] getDefaultSessionTicketAgeAdd() {
        return Arrays.copyOf(this.defaultSessionTicketAgeAdd, this.defaultSessionTicketAgeAdd.length);
    }

    public void setDefaultSessionTicketAgeAdd(byte[] defaultSessionTicketAgeAdd) {
        this.defaultSessionTicketAgeAdd = defaultSessionTicketAgeAdd;
    }

    public byte[] getDefaultSessionTicketNonce() {
        return Arrays.copyOf(this.defaultSessionTicketNonce, this.defaultSessionTicketNonce.length);
    }

    public void setDefaultSessionTicketNonce(byte[] defaultSessionTicketNonce) {
        this.defaultSessionTicketNonce = defaultSessionTicketNonce;
    }

    public byte[] getDefaultSessionTicketIdentity() {
        return Arrays.copyOf(this.defaultSessionTicketIdentity, this.defaultSessionTicketIdentity.length);
    }

    public void setDefaultSessionTicketIdentity(byte[] defaultSessionTicketIdentity) {
        this.defaultSessionTicketIdentity = defaultSessionTicketIdentity;
    }

    public byte[] getClientEarlyTrafficSecret() {
        return Arrays.copyOf(this.clientEarlyTrafficSecret, this.clientEarlyTrafficSecret.length);
    }

    public void setClientEarlyTrafficSecret(byte[] clientEarlyTrafficSecret) {
        this.clientEarlyTrafficSecret = clientEarlyTrafficSecret;
    }

    public byte[] getEarlySecret() {
        return Arrays.copyOf(this.earlySecret, this.earlySecret.length);
    }

    public void setEarlySecret(byte[] earlySecret) {
        this.earlySecret = earlySecret;
    }

    public CipherSuite getEarlyDataCipherSuite() {
        return this.earlyDataCipherSuite;
    }

    public void setEarlyDataCipherSuite(CipherSuite earlyDataCipherSuite) {
        this.earlyDataCipherSuite = earlyDataCipherSuite;
    }

    public byte[] getEarlyDataPsk() {
        return Arrays.copyOf(this.earlyDataPsk, this.earlyDataPsk.length);
    }

    public void setEarlyDataPsk(byte[] earlyDataPsk) {
        this.earlyDataPsk = earlyDataPsk;
    }

    public Boolean isUsePsk() {
        return this.usePsk;
    }

    public void setUsePsk(Boolean usePsk) {
        this.usePsk = usePsk;
    }

    public List<String> getDefaultProposedAlpnProtocols() {
        return this.defaultProposedAlpnProtocols;
    }

    public void setDefaultProposedAlpnProtocols(List<String> defaultProposedAlpnProtocols) {
        this.defaultProposedAlpnProtocols = defaultProposedAlpnProtocols;
    }

    public void setDefaultProposedAlpnProtocols(String ... alpnAnnouncedProtocols) {
        this.defaultProposedAlpnProtocols = new ArrayList<String>(Arrays.asList(alpnAnnouncedProtocols));
    }

    public QuicTransportParameters getDefaultQuicTransportParameters() {
        return this.defaultQuicTransportParameters;
    }

    public void setDefaultQuicTransportParameters(QuicTransportParameters defaultQuicTransportParameters) {
        this.defaultQuicTransportParameters = defaultQuicTransportParameters;
    }

    public Boolean isEchoQuic() {
        return this.echoQuic;
    }

    public void setEchoQuic(Boolean echoQuic) {
        this.echoQuic = echoQuic;
    }

    public NamedGroup getDefaultEcCertificateCurve() {
        return this.defaultEcCertificateCurve;
    }

    public void setDefaultEcCertificateCurve(NamedGroup defaultEcCertificateCurve) {
        this.defaultEcCertificateCurve = defaultEcCertificateCurve;
    }

    public StarttlsType getStarttlsType() {
        return this.starttlsType;
    }

    public void setStarttlsType(StarttlsType starttlsType) {
        this.starttlsType = starttlsType;
    }

    public KeyShareStoreEntry getDefaultServerKeyShareEntry() {
        return this.defaultServerKeyShareEntry;
    }

    public void setDefaultServerKeyShareEntry(KeyShareStoreEntry defaultServerKeyShareEntry) {
        this.defaultServerKeyShareEntry = defaultServerKeyShareEntry;
    }

    public byte[] getDefaultHandshakeSecret() {
        return Arrays.copyOf(this.defaultHandshakeSecret, this.defaultHandshakeSecret.length);
    }

    public void setDefaultHandshakeSecret(byte[] defaultHandshakeSecret) {
        this.defaultHandshakeSecret = defaultHandshakeSecret;
    }

    public String getDefaultClientPWDUsername() {
        return this.defaultClientPWDUsername;
    }

    public void setDefaultClientPWDUsername(String username) {
        this.defaultClientPWDUsername = username;
    }

    public byte[] getDefaultServerPWDSalt() {
        return Arrays.copyOf(this.defaultServerPWDSalt, this.defaultServerPWDSalt.length);
    }

    public void setDefaultServerPWDSalt(byte[] salt) {
        this.defaultServerPWDSalt = salt;
    }

    public String getDefaultPWDPassword() {
        return this.defaultPWDPassword;
    }

    public void setDefaultPWDPassword(String password) {
        this.defaultPWDPassword = password;
    }

    public byte[] getDefaultServerPWDPrivate() {
        return Arrays.copyOf(this.defaultServerPWDPrivate, this.defaultServerPWDPrivate.length);
    }

    public void setDefaultServerPWDPrivate(byte[] defaultServerPWDPrivate) {
        this.defaultServerPWDPrivate = defaultServerPWDPrivate;
    }

    public byte[] getDefaultServerPWDMask() {
        return Arrays.copyOf(this.defaultServerPWDMask, this.defaultServerPWDMask.length);
    }

    public void setDefaultServerPWDMask(byte[] defaultServerPWDMask) {
        this.defaultServerPWDMask = defaultServerPWDMask;
    }

    public byte[] getDefaultClientPWDPrivate() {
        return Arrays.copyOf(this.defaultClientPWDPrivate, this.defaultClientPWDPrivate.length);
    }

    public void setDefaultClientPWDPrivate(byte[] defaultClientPWDPrivate) {
        this.defaultClientPWDPrivate = defaultClientPWDPrivate;
    }

    public byte[] getDefaultClientPWDMask() {
        return Arrays.copyOf(this.defaultClientPWDMask, this.defaultClientPWDMask.length);
    }

    public void setDefaultClientPWDMask(byte[] defaultClientPWDMask) {
        this.defaultClientPWDMask = defaultClientPWDMask;
    }

    public NamedGroup getDefaultPWDProtectGroup() {
        return this.defaultPWDProtectGroup;
    }

    public void setDefaultPWDProtectGroup(NamedGroup defaultPWDProtectGroup) {
        this.defaultPWDProtectGroup = defaultPWDProtectGroup;
    }

    public Point getDefaultServerPWDProtectPublicKey() {
        return this.defaultServerPWDProtectPublicKey;
    }

    public void setDefaultServerPWDProtectPublicKey(Point defaultServerPWDProtectPublicKey) {
        this.defaultServerPWDProtectPublicKey = defaultServerPWDProtectPublicKey;
    }

    public BigInteger getDefaultServerPWDProtectPrivateKey() {
        return this.defaultServerPWDProtectPrivateKey;
    }

    public void setDefaultServerPWDProtectPrivateKey(BigInteger defaultServerPWDProtectPrivateKey) {
        this.defaultServerPWDProtectPrivateKey = defaultServerPWDProtectPrivateKey;
    }

    public BigInteger getDefaultServerPWDProtectRandomSecret() {
        return this.defaultServerPWDProtectRandomSecret;
    }

    public void setDefaultServerPWDProtectRandomSecret(BigInteger defaultServerPWDProtectRandomSecret) {
        this.defaultServerPWDProtectRandomSecret = defaultServerPWDProtectRandomSecret;
    }

    public Boolean isAddPWDProtectExtension() {
        return this.addPWDProtectExtension;
    }

    public void setAddPWDProtectExtension(Boolean addPWDProtectExtension) {
        this.addPWDProtectExtension = addPWDProtectExtension;
    }

    public Boolean isStopTraceAfterUnexpected() {
        return this.stopTraceAfterUnexpected;
    }

    public void setStopTraceAfterUnexpected(Boolean stopTraceAfterUnexpected) {
        this.stopTraceAfterUnexpected = stopTraceAfterUnexpected;
    }

    public List<CipherSuite> getClientSupportedEsniCipherSuites() {
        return this.clientSupportedEsniCipherSuites;
    }

    public void setClientSupportedEsniCipherSuites(List<CipherSuite> clientSupportedEsniCipherSuites) {
        this.clientSupportedEsniCipherSuites = clientSupportedEsniCipherSuites;
    }

    public void setClientSupportedEsniCipherSuites(CipherSuite ... clientSupportedEsniCipherSuites) {
        this.clientSupportedEsniCipherSuites = new ArrayList<CipherSuite>(Arrays.asList(clientSupportedEsniCipherSuites));
    }

    public List<NamedGroup> getClientSupportedEsniNamedGroups() {
        return this.clientSupportedEsniNamedGroups;
    }

    public void setClientSupportedEsniNamedGroups(List<NamedGroup> clientSupportedEsniNamedGroups) {
        this.clientSupportedEsniNamedGroups = clientSupportedEsniNamedGroups;
    }

    public final void setClientSupportedEsniNamedGroups(NamedGroup ... clientSupportedEsniNamedGroups) {
        this.clientSupportedEsniNamedGroups = new ArrayList<NamedGroup>(Arrays.asList(clientSupportedEsniNamedGroups));
    }

    public List<KeyShareEntry> getEsniServerKeyPairs() {
        return this.esniServerKeyPairs;
    }

    public void setEsniServerKeyPairs(List<KeyShareEntry> esniServerKeyPairs) {
        this.esniServerKeyPairs = esniServerKeyPairs;
    }

    public final void setEsniServerKeyPairs(KeyShareEntry ... esniServerKeyPairs) {
        this.esniServerKeyPairs = new ArrayList<KeyShareEntry>(Arrays.asList(esniServerKeyPairs));
    }

    public byte[] getDefaultEsniClientNonce() {
        return Arrays.copyOf(this.defaultEsniClientNonce, this.defaultEsniClientNonce.length);
    }

    public void setDefaultEsniClientNonce(byte[] defaultEsniClientNonce) {
        this.defaultEsniClientNonce = defaultEsniClientNonce;
    }

    public BigInteger getDefaultEchClientPrivateKey() {
        return this.defaultEchClientPrivateKey;
    }

    public void setDefaultEchClientPrivateKey(BigInteger defaultEchClientPrivateKey) {
        this.defaultEchClientPrivateKey = defaultEchClientPrivateKey;
    }

    public BigInteger getDefaultEchServerPrivateKey() {
        return this.defaultEchServerPrivateKey;
    }

    public void setDefaultEchServerPrivateKey(BigInteger defaultEchServerPrivateKey) {
        this.defaultEchServerPrivateKey = defaultEchServerPrivateKey;
    }

    public byte[] getDefaultEsniServerNonce() {
        return Arrays.copyOf(this.defaultEsniServerNonce, this.defaultEsniServerNonce.length);
    }

    public void setDefaultEsniServerNonce(byte[] defaultEsniServerNonce) {
        this.defaultEsniServerNonce = defaultEsniServerNonce;
    }

    public byte[] getDefaultEsniRecordBytes() {
        return Arrays.copyOf(this.defaultEsniRecordBytes, this.defaultEsniRecordBytes.length);
    }

    public void setDefaultEsniRecordBytes(byte[] defaultEsniRecordBytes) {
        this.defaultEsniRecordBytes = defaultEsniRecordBytes;
    }

    public EsniDnsKeyRecordVersion getDefaultEsniRecordVersion() {
        return this.defaultEsniRecordVersion;
    }

    public void setDefaultEsniRecordVersion(EsniDnsKeyRecordVersion defaultEsniRecordVersion) {
        this.defaultEsniRecordVersion = defaultEsniRecordVersion;
    }

    public byte[] getDefaultEsniRecordChecksum() {
        return Arrays.copyOf(this.defaultEsniRecordChecksum, this.defaultEsniRecordChecksum.length);
    }

    public void setDefaultEsniRecordChecksum(byte[] defaultEsniRecordChecksum) {
        this.defaultEsniRecordChecksum = defaultEsniRecordChecksum;
    }

    public List<KeyShareStoreEntry> getDefaultEsniServerKeyShareEntries() {
        return this.defaultEsniServerKeyShareEntries;
    }

    public void setDefaultEsniServerKeyShareEntries(List<KeyShareStoreEntry> defaultEsniServerKeyShareEntries) {
        this.defaultEsniServerKeyShareEntries = defaultEsniServerKeyShareEntries;
    }

    public List<CipherSuite> getDefaultEsniServerCipherSuites() {
        return this.defaultEsniServerCipherSuites;
    }

    public void setDefaultEsniServerCipherSuites(List<CipherSuite> defaultEsniServerCipherSuites) {
        this.defaultEsniServerCipherSuites = defaultEsniServerCipherSuites;
    }

    public Integer getDefaultEsniPaddedLength() {
        return this.defaultEsniPaddedLength;
    }

    public void setDefaultEsniPaddedLength(Integer defaultEsniPaddedLength) {
        this.defaultEsniPaddedLength = defaultEsniPaddedLength;
    }

    public Long getDefaultEsniNotBefore() {
        return this.defaultEsniNotBefore;
    }

    public void setDefaultEsniNotBefore(Long defaultEsniNotBefore) {
        this.defaultEsniNotBefore = defaultEsniNotBefore;
    }

    public Long getDefaultEsniNotAfter() {
        return this.defaultEsniNotAfter;
    }

    public void setDefaultEsniNotAfter(Long defaultEsniNotAfter) {
        this.defaultEsniNotAfter = defaultEsniNotAfter;
    }

    public List<ExtensionType> getDefaultEsniExtensions() {
        return this.defaultEsniExtensions;
    }

    public void setDefaultEsniExtensions(List<ExtensionType> defaultEsniExtensions) {
        this.defaultEsniExtensions = defaultEsniExtensions;
    }

    public Boolean isWriteKeylogFile() {
        return this.writeKeylogFile;
    }

    public void setWriteKeylogFile(Boolean writeKeylogFile) {
        this.writeKeylogFile = writeKeylogFile;
    }

    public String getKeylogFilePath() {
        return this.keylogFilePath;
    }

    public void setKeylogFilePath(String keylogFilePath) {
        this.keylogFilePath = keylogFilePath;
    }

    public BigInteger getDefaultEsniClientPrivateKey() {
        return this.defaultEsniClientPrivateKey;
    }

    public void setDefaultEsniClientPrivateKey(BigInteger defaultEsniClientPrivateKey) {
        this.defaultEsniClientPrivateKey = defaultEsniClientPrivateKey;
    }

    public List<NamedGroup> getDefaultClientKeyShareNamedGroups() {
        return this.defaultClientKeyShareNamedGroups;
    }

    public void setDefaultClientKeyShareNamedGroups(List<NamedGroup> defaultClientKeyShareNamedGroups) {
        this.defaultClientKeyShareNamedGroups = defaultClientKeyShareNamedGroups;
    }

    public void setDefaultClientKeyShareNamedGroups(NamedGroup ... defaultClientKeyShareNamedGroups) {
        this.defaultClientKeyShareNamedGroups = new ArrayList<NamedGroup>(Arrays.asList(defaultClientKeyShareNamedGroups));
    }

    public List<KeyShareStoreEntry> getDefaultClientKeyStoreEntries() {
        return this.defaultClientKeyStoreEntries;
    }

    public void setDefaultClientKeyStoreEntries(List<KeyShareStoreEntry> defaultClientKeyStoreEntries) {
        this.defaultClientKeyStoreEntries = defaultClientKeyStoreEntries;
    }

    public List<ActionOption> getMessageFactoryActionOptions() {
        return this.messageFactoryActionOptions;
    }

    public void setMessageFactoryActionOptions(List<ActionOption> messageFactoryActionOptions) {
        this.messageFactoryActionOptions = messageFactoryActionOptions;
    }

    public Boolean isRetryFailedClientTcpSocketInitialization() {
        return this.retryFailedClientTcpSocketInitialization;
    }

    public void setRetryFailedClientTcpSocketInitialization(Boolean retryFailedClientTcpSocketInitialization) {
        this.retryFailedClientTcpSocketInitialization = retryFailedClientTcpSocketInitialization;
    }

    public Boolean isResetClientSourcePort() {
        return this.resetClientSourcePort;
    }

    public void setResetClientSourcePort(Boolean resetClientSourcePort) {
        this.resetClientSourcePort = resetClientSourcePort;
    }

    public Boolean isLimitPsksToOne() {
        return this.limitPsksToOne;
    }

    public void setLimitPsksToOne(Boolean limitPsksToOne) {
        this.limitPsksToOne = limitPsksToOne;
    }

    public Boolean getPreserveMessageRecordRelation() {
        return this.preserveMessageRecordRelation;
    }

    public void setPreserveMessageRecordRelation(Boolean preserveMessageRecordRelation) {
        this.preserveMessageRecordRelation = preserveMessageRecordRelation;
    }

    public Integer getDefaultMaxEarlyDataSize() {
        return this.defaultMaxEarlyDataSize;
    }

    public void setDefaultMaxEarlyDataSize(Integer defaultMaxEarlyDataSize) {
        this.defaultMaxEarlyDataSize = defaultMaxEarlyDataSize;
    }

    public byte[] getDefaultLastClientHello() {
        return Arrays.copyOf(this.defaultLastClientHello, this.defaultLastClientHello.length);
    }

    public void setDefaultLastClientHello(byte[] defaultLastClientHello) {
        this.defaultLastClientHello = defaultLastClientHello;
    }

    public int getPreferredCertRsaKeySize() {
        return this.preferredCertRsaKeySize;
    }

    public void setPreferredCertRsaKeySize(int preferredCertRsaKeySize) {
        this.preferredCertRsaKeySize = preferredCertRsaKeySize;
    }

    public int getPreferredCertDssKeySize() {
        return this.preferredCertDssKeySize;
    }

    public void setPreferredCertDssKeySize(int preferredCertDssKeySize) {
        this.preferredCertDssKeySize = preferredCertDssKeySize;
    }

    public byte[] getDefaultExtensionCookie() {
        return this.defaultExtensionCookie;
    }

    public void setDefaultExtensionCookie(byte[] defaultExtensionCookie) {
        this.defaultExtensionCookie = defaultExtensionCookie;
    }

    public Boolean isAddCookieExtension() {
        return this.addCookieExtension;
    }

    public void setAddCookieExtension(Boolean addCookieExtension) {
        this.addCookieExtension = addCookieExtension;
    }

    public Boolean isEncryptChangeCipherSpec() {
        return this.encryptChangeCipherSpecTls13;
    }

    public void setEncryptChangeCipherSpec(Boolean encryptChangeCipherSpec) {
        this.encryptChangeCipherSpecTls13 = encryptChangeCipherSpec;
    }

    public KeyUpdateRequest getDefaultKeyUpdateRequestMode() {
        return this.defaultKeyUpdateRequestMode;
    }

    public void setDefaultKeyUpdateRequestMode(KeyUpdateRequest defaultKeyUpdateRequestMode) {
        this.defaultKeyUpdateRequestMode = defaultKeyUpdateRequestMode;
    }

    public CipherAlgorithm getSessionTicketCipherAlgorithm() {
        return this.sessionTicketCipherAlgorithm;
    }

    public void setSessionTicketCipherAlgorithm(CipherAlgorithm sessionTicketCipherAlgorithm) {
        this.sessionTicketCipherAlgorithm = sessionTicketCipherAlgorithm;
    }

    public MacAlgorithm getSessionTicketMacAlgorithm() {
        return this.sessionTicketMacAlgorithm;
    }

    public void setSessionTicketMacAlgorithm(MacAlgorithm sessionTicketMacAlgorithm) {
        this.sessionTicketMacAlgorithm = sessionTicketMacAlgorithm;
    }

    public byte[] getDefaultClientTicketResumptionSessionId() {
        return this.defaultClientTicketResumptionSessionId;
    }

    public void setDefaultClientTicketResumptionSessionId(byte[] defaultClientTicketResumptionSessionId) {
        this.defaultClientTicketResumptionSessionId = defaultClientTicketResumptionSessionId;
    }

    public List<ServerNamePair> getDefaultSniHostnames() {
        return this.defaultSniHostnames;
    }

    public void setDefaultSniHostnames(List<ServerNamePair> defaultSniHostnames) {
        this.defaultSniHostnames = defaultSniHostnames;
    }

    public String getDefaultDnsServer() {
        return this.defaultDnsServer;
    }

    public void setDefaultDnsServer(String defaultDnsServer) {
        this.defaultDnsServer = defaultDnsServer;
    }

    public EchConfig getDefaultEchConfig() {
        return this.defaultEchConfig;
    }

    public void setDefaultEchConfig(EchConfig defaultEchConfig) {
        this.defaultEchConfig = defaultEchConfig;
    }

    public Integer getDefaultMaxEchAlpnPadding() {
        return this.defaultMaxEchAlpnPadding;
    }

    public void setDefaultMaxEchAlpnPadding(Integer defaultMaxEchAlpnPadding) {
        this.defaultMaxEchAlpnPadding = defaultMaxEchAlpnPadding;
    }

    public StackConfiguration getDefaultLayerConfiguration() {
        return this.defaultLayerConfiguration;
    }

    public void setDefaultLayerConfiguration(StackConfiguration defaultLayerConfiguration) {
        this.defaultLayerConfiguration = defaultLayerConfiguration;
    }

    public byte[] getDefaultConnectionId() {
        return Arrays.copyOf(this.defaultConnectionId, this.defaultConnectionId.length);
    }

    public void setDefaultConnectionId(byte[] defaultConnectionId) {
        this.defaultConnectionId = defaultConnectionId;
    }

    public String getDefaultDebugContent() {
        return this.defaultDebugContent;
    }

    public void setDefaultDebugContent(String defaultDebugContent) {
        this.defaultDebugContent = defaultDebugContent;
    }

    public Integer getDefaultNumberOfRequestedConnectionIds() {
        return this.defaultNumberOfRequestedConnectionIds;
    }

    public void setDefaultNumberOfRequestedConnectionIds(Integer defaultNumberOfRequestedConnectionIds) {
        this.defaultNumberOfRequestedConnectionIds = defaultNumberOfRequestedConnectionIds;
    }

    public ConnectionIdUsage getDefaultUsageOfSentConnectionIds() {
        return this.defaultUsageOfSentConnectionIds;
    }

    public void setDefaultUsageOfSentConnectionIds(ConnectionIdUsage defaultUsageofSentConnectionIds) {
        this.defaultUsageOfSentConnectionIds = defaultUsageofSentConnectionIds;
    }

    public Boolean isAddConnectionIdExtension() {
        return this.addConnectionIdExtension;
    }

    public void setAddConnectionIdExtension(Boolean addConnectionIdExtension) {
        this.addConnectionIdExtension = addConnectionIdExtension;
    }

    public List<SSL2CipherSuite> getDefaultServerSupportedSSL2CipherSuites() {
        return this.defaultServerSupportedSSL2CipherSuites;
    }

    public void setDefaultServerSupportedSSL2CipherSuites(List<SSL2CipherSuite> defaultServerSupportedSSL2CipherSuites) {
        this.defaultServerSupportedSSL2CipherSuites = defaultServerSupportedSSL2CipherSuites;
    }

    public Boolean getSendHandshakeMessagesWithinSingleRecord() {
        return this.sendHandshakeMessagesWithinSingleRecord;
    }

    public void setSendHandshakeMessagesWithinSingleRecord(Boolean sendHandshakeMessagesWithinSingleRecord) {
        this.sendHandshakeMessagesWithinSingleRecord = sendHandshakeMessagesWithinSingleRecord;
    }

    public Boolean getUseDtls13HeaderSeqNumSizeLongEncoding() {
        return this.useDtls13HeaderSeqNumSizeLongEncoding;
    }

    public void setUseDtls13HeaderSeqNumSizeLongEncoding(Boolean useDtls13HeaderSeqNumSizeLongEncoding) {
        this.useDtls13HeaderSeqNumSizeLongEncoding = useDtls13HeaderSeqNumSizeLongEncoding;
    }

    public Boolean getRetransmitAcknowledgedRecordsInDtls13() {
        return this.retransmitAcknowledgedRecordsInDtls13;
    }

    public void setRetransmitAcknowledgedRecordsInDtls13(Boolean retransmitAcknowledgedRecordsInDtls13) {
        this.retransmitAcknowledgedRecordsInDtls13 = retransmitAcknowledgedRecordsInDtls13;
    }

    public BigInteger getDefaultServerEphemeralDhGenerator() {
        return this.defaultServerEphemeralDhGenerator;
    }

    public void setDefaultServerEphemeralDhGenerator(BigInteger defaultServerEphemeralDhGenerator) {
        this.defaultServerEphemeralDhGenerator = defaultServerEphemeralDhGenerator;
    }

    public BigInteger getDefaultServerEphemeralDhModulus() {
        return this.defaultServerEphemeralDhModulus;
    }

    public void setDefaultServerEphemeralDhModulus(BigInteger defaultServerEphemeralDhModulus) {
        this.defaultServerEphemeralDhModulus = defaultServerEphemeralDhModulus;
    }

    public BigInteger getDefaultServerEphemeralDhPrivateKey() {
        return this.defaultServerEphemeralDhPrivateKey;
    }

    public void setDefaultServerEphemeralDhPrivateKey(BigInteger defaultServerEphemeralDhPrivateKey) {
        this.defaultServerEphemeralDhPrivateKey = defaultServerEphemeralDhPrivateKey;
    }

    public BigInteger getDefaultClientEphemeralDhPrivateKey() {
        return this.defaultClientEphemeralDhPrivateKey;
    }

    public void setDefaultClientEphemeralDhPrivateKey(BigInteger defaultClientEphemeralDhPrivateKey) {
        this.defaultClientEphemeralDhPrivateKey = defaultClientEphemeralDhPrivateKey;
    }

    public BigInteger getDefaultServerEphemeralDhPublicKey() {
        return this.defaultServerEphemeralDhPublicKey;
    }

    public void setDefaultServerEphemeralDhPublicKey(BigInteger defaultServerEphemeralDhPublicKey) {
        this.defaultServerEphemeralDhPublicKey = defaultServerEphemeralDhPublicKey;
    }

    public BigInteger getDefaultClientEphemeralDhPublicKey() {
        return this.defaultClientEphemeralDhPublicKey;
    }

    public void setDefaultClientEphemeralDhPublicKey(BigInteger defaultClientEphemeralDhPublicKey) {
        this.defaultClientEphemeralDhPublicKey = defaultClientEphemeralDhPublicKey;
    }

    public BigInteger getDefaultServerEphemeralEcPrivateKey() {
        return this.defaultServerEphemeralEcPrivateKey;
    }

    public void setDefaultServerEphemeralEcPrivateKey(BigInteger defaultServerEphemeralEcPrivateKey) {
        this.defaultServerEphemeralEcPrivateKey = defaultServerEphemeralEcPrivateKey;
    }

    public BigInteger getDefaultClientEphemeralEcPrivateKey() {
        return this.defaultClientEphemeralEcPrivateKey;
    }

    public void setDefaultClientEphemeralEcPrivateKey(BigInteger defaultClientEphemeralEcPrivateKey) {
        this.defaultClientEphemeralEcPrivateKey = defaultClientEphemeralEcPrivateKey;
    }

    public BigInteger getDefaultServerEphemeralRsaExportModulus() {
        return this.defaultServerEphemeralRsaExportModulus;
    }

    public void setDefaultServerEphemeralRsaExportModulus(BigInteger defaultServerEphemeralRsaExportModulus) {
        this.defaultServerEphemeralRsaExportModulus = defaultServerEphemeralRsaExportModulus;
    }

    public BigInteger getDefaultServerEphemeralRsaExportPublicKey() {
        return this.defaultServerEphemeralRsaExportPublicKey;
    }

    public void setDefaultServerEphemeralRsaExportPublicKey(BigInteger defaultServerEphemeralRsaExportPublicKey) {
        this.defaultServerEphemeralRsaExportPublicKey = defaultServerEphemeralRsaExportPublicKey;
    }

    public BigInteger getDefaultServerEphemeralRsaExportPrivateKey() {
        return this.defaultServerEphemeralRsaExportPrivateKey;
    }

    public void setDefaultServerEphemeralRsaExportPrivateKey(BigInteger defaultServerEphemeralRsaExportPrivateKey) {
        this.defaultServerEphemeralRsaExportPrivateKey = defaultServerEphemeralRsaExportPrivateKey;
    }

    public BigInteger getDefaultServerEphemeralDhExportGenerator() {
        return this.defaultServerEphemeralDhExportGenerator;
    }

    public void setDefaultServerEphemeralDhExportGenerator(BigInteger defaultServerEphemeralDhExportGenerator) {
        this.defaultServerEphemeralDhExportGenerator = defaultServerEphemeralDhExportGenerator;
    }

    public BigInteger getDefaultServerEphemeralDhExportModulus() {
        return this.defaultServerEphemeralDhExportModulus;
    }

    public void setDefaultServerEphemeralDhExportModulus(BigInteger defaultServerEphemeralDhExportModulus) {
        this.defaultServerEphemeralDhExportModulus = defaultServerEphemeralDhExportModulus;
    }

    public BigInteger getDefaultServerEphemeralDhExportPublicKey() {
        return this.defaultServerEphemeralDhExportPublicKey;
    }

    public void setDefaultServerEphemeralDhExportPublicKey(BigInteger defaultServerEphemeralDhExportPublicKey) {
        this.defaultServerEphemeralDhExportPublicKey = defaultServerEphemeralDhExportPublicKey;
    }

    public BigInteger getDefaultServerEphemeralDhExportPrivateKey() {
        return this.defaultServerEphemeralDhExportPrivateKey;
    }

    public void setDefaultServerEphemeralDhExportPrivateKey(BigInteger defaultServerEphemeralDhExportPrivateKey) {
        this.defaultServerEphemeralDhExportPrivateKey = defaultServerEphemeralDhExportPrivateKey;
    }

    public Boolean getAutoAdjustSignatureAndHashAlgorithm() {
        return this.autoAdjustSignatureAndHashAlgorithm;
    }

    public void setAutoAdjustSignatureAndHashAlgorithm(Boolean autoAdjustSignatureAndHashAlgorithm) {
        this.autoAdjustSignatureAndHashAlgorithm = autoAdjustSignatureAndHashAlgorithm;
    }

    public boolean isRespectPeerRecordSizeLimitations() {
        return this.respectPeerRecordSizeLimitations;
    }

    public void setRespectPeerRecordSizeLimitations(boolean respectPeerRecordSizeLimitations) {
        this.respectPeerRecordSizeLimitations = respectPeerRecordSizeLimitations;
    }

    public Integer getDefaultAssumedMaxReceiveLimit() {
        return this.defaultAssumedMaxReceiveLimit;
    }

    public void setDefaultAssumedMaxReceiveLimit(Integer defaultAssumedMaxReceiveLimit) {
        this.defaultAssumedMaxReceiveLimit = defaultAssumedMaxReceiveLimit;
    }

    public BigInteger getDefaultKeySharePrivateKey(NamedGroup group) {
        return this.defaultKeySharePrivateMap.getOrDefault((Object)group, new BigInteger("FFFF", 16));
    }

    public void setDefaultKeySharePrivateKey(NamedGroup group, BigInteger privateKey) {
        if (this.defaultKeySharePrivateMap.containsKey((Object)group)) {
            this.defaultKeySharePrivateMap.remove((Object)group);
        }
        this.defaultKeySharePrivateMap.put(group, privateKey);
    }

    public SrtpProtectionProfile getDefaultSelectedSrtpProtectionProfile() {
        return this.defaultSelectedSrtpProtectionProfile;
    }

    public void setDefaultSelectedSrtpProtectionProfile(SrtpProtectionProfile defaultSelectedSrtpProtectionProfile) {
        this.defaultSelectedSrtpProtectionProfile = defaultSelectedSrtpProtectionProfile;
    }

    public Boolean isRespectClientProposedExtensions() {
        return this.respectClientProposedExtensions;
    }

    public void setRespectClientProposedExtensions(Boolean respectClientProposedExtensions) {
        this.respectClientProposedExtensions = respectClientProposedExtensions;
    }

    public Boolean getQuic() {
        return this.isQuic;
    }

    public void setQuic(Boolean quic) {
        this.isQuic = quic;
    }

    public Boolean getQuicRetryFlowRequired() {
        return this.quicRetryFlowRequired;
    }

    public void setQuicRetryFlowRequired(Boolean quicRetryFlowRequired) {
        this.quicRetryFlowRequired = quicRetryFlowRequired;
    }

    public byte[] getDefaultQuicPathChallange() {
        return this.defaultQuicPathChallange;
    }

    public void setDefaultQuicPathChallange(byte[] defaultQuicPathChallange) {
        this.defaultQuicPathChallange = defaultQuicPathChallange;
    }

    public byte[] getDefaultQuicNewToken() {
        return this.defaultQuicNewToken;
    }

    public void setDefaultQuicNewToken(byte[] defaultQuicNewToken) {
        this.defaultQuicNewToken = defaultQuicNewToken;
    }

    public boolean stopActionAfterQuicStatelessReset() {
        return this.stopActionsAfterQuicStatelessReset;
    }

    public void setStopActionsAfterQuicStatelessReset(boolean stopActionsAfterQuicStatelessReset) {
        this.stopActionsAfterQuicStatelessReset = stopActionsAfterQuicStatelessReset;
    }

    public Boolean isQuicDoNotPad() {
        return this.quicDoNotPad;
    }

    public void setQuicDoNotPad(boolean quicDoNotPad) {
        this.quicDoNotPad = quicDoNotPad;
    }

    public Boolean isDiscardPacketsWithMismatchedSCID() {
        return this.discardPacketsWithMismatchedSCID;
    }

    public void setDiscardPacketsWithMismatchedSCID(Boolean discardPacketsWithMismatchedSCID) {
        this.discardPacketsWithMismatchedSCID = discardPacketsWithMismatchedSCID;
    }

    public byte[] getDefaultQuicServerRetryToken() {
        return this.defaultQuicServerRetryToken;
    }

    public void setDefaultQuicServerRetryToken(byte[] defaultQuicServerRetryToken) {
        this.defaultQuicServerRetryToken = defaultQuicServerRetryToken;
    }

    public Boolean getQuicImmediateCloseOnTlsError() {
        return this.quicImmediateCloseOnTlsError;
    }

    public void setQuicImmediateCloseOnTlsError(Boolean quicImmediateCloseOnTlsError) {
        this.quicImmediateCloseOnTlsError = quicImmediateCloseOnTlsError;
    }
}

