/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.filter.ConfigDisplayFilter;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.constants.X500AttributeType;
import jakarta.xml.bind.JAXB;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ConfigIO {
    private static JAXBContext context;

    static synchronized JAXBContext getJAXBContext() throws JAXBException {
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{Config.class, X509CertificateConfig.class, X500AttributeType.class});
        }
        return context;
    }

    public static void write(Config config, File f) {
        try (FileOutputStream fs = new FileOutputStream(f);){
            ConfigIO.write(config, fs);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void write(Config config, OutputStream os) {
        SilentByteArrayOutputStream tempStream = new SilentByteArrayOutputStream();
        JAXB.marshal((Object)config, (OutputStream)tempStream);
        try {
            os.write(tempStream.toString(StandardCharsets.UTF_8).replaceAll("\r?\n", System.lineSeparator()).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not format XML");
        }
    }

    public static void write(Config config, File f, ConfigDisplayFilter filter) {
        Config filteredConfig = ConfigIO.copy(config);
        filter.applyFilter(filteredConfig);
        ConfigIO.write(filteredConfig, f);
    }

    public static void write(Config config, OutputStream os, ConfigDisplayFilter filter) {
        Config filteredConfig = ConfigIO.copy(config);
        filter.applyFilter(filteredConfig);
        ConfigIO.write(filteredConfig, os);
    }

    public static Config read(File f) {
        Config config;
        Unmarshaller unmarshaller = ConfigIO.getJAXBContext().createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                return false;
            }
        });
        FileInputStream fis = new FileInputStream(f);
        try {
            config = ConfigIO.read(fis, unmarshaller);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("File cannot be read");
            }
        }
        fis.close();
        return config;
    }

    public static Config read(InputStream stream) {
        try {
            Unmarshaller unmarshaller = ConfigIO.getJAXBContext().createUnmarshaller();
            unmarshaller.setEventHandler(event -> false);
            return ConfigIO.read(stream, unmarshaller);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static Config read(InputStream stream, Unmarshaller unmarshaller) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(stream);
            return (Config)unmarshaller.unmarshal(xsr);
        }
        catch (JAXBException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public static Config copy(Config config) {
        SilentByteArrayOutputStream byteArrayOutputStream = new SilentByteArrayOutputStream();
        ConfigIO.write(config, (OutputStream)byteArrayOutputStream);
        return ConfigIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    private ConfigIO() {
    }
}

