/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config;

import de.rub.nds.tlsattacker.core.config.ConfigIO;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.SchemaOutputResolver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigSchemaGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String NO_NS = "__NO__NS";

    public static void main(String[] args) {
        try {
            File outputDirectory = new File(args[0]);
            assert (outputDirectory.exists() || outputDirectory.mkdirs());
            ConfigSchemaGenerator.generateSchema(outputDirectory);
        }
        catch (JAXBException | IOException e) {
            LOGGER.error((Object)e);
        }
    }

    private static void generateSchema(File outputDirectory) throws IOException, JAXBException {
        AccumulatingSchemaOutputResolver sor = new AccumulatingSchemaOutputResolver();
        ConfigIO.getJAXBContext().generateSchema((SchemaOutputResolver)sor);
        for (Map.Entry<String, StringWriter> e : sor.getSchemaWriters().entrySet()) {
            String systemId = sor.getSystemIds().get(e.getKey());
            File f = new File(outputDirectory, systemId);
            try (FileWriter w = new FileWriter(f, StandardCharsets.UTF_8);){
                w.write(e.getValue().toString().replaceAll("\r?\n", System.lineSeparator()));
            }
        }
    }

    public static class AccumulatingSchemaOutputResolver
    extends SchemaOutputResolver {
        private final Map<String, StringWriter> schemaWriters = new HashMap<String, StringWriter>();
        private final Map<String, String> systemIds = new HashMap<String, String>();

        public static String mapSystemIds() {
            return "Config.xsd";
        }

        public Result createOutput(String namespaceURI, String suggestedFileName) throws IOException {
            String ns = StringUtils.isBlank((CharSequence)namespaceURI) ? ConfigSchemaGenerator.NO_NS : namespaceURI;
            this.schemaWriters.put(ns, new StringWriter());
            String systemId = AccumulatingSchemaOutputResolver.mapSystemIds();
            this.systemIds.put(ns, systemId);
            StreamResult result = new StreamResult(this.schemaWriters.get(ns));
            result.setSystemId(systemId);
            return result;
        }

        public Map<String, StringWriter> getSchemaWriters() {
            return this.schemaWriters;
        }

        public Map<String, String> getSystemIds() {
            return this.systemIds;
        }
    }
}

