/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CipherSuiteDelegate
extends Delegate {
    @Parameter(names={"-cipher"}, description="TLS cipher suites to use, divided by a comma, e.g. TLS_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_256_CBC_SHA")
    private List<CipherSuite> cipherSuites = null;

    public List<CipherSuite> getCipherSuites() {
        if (this.cipherSuites == null) {
            return null;
        }
        return Collections.unmodifiableList(this.cipherSuites);
    }

    public void setCipherSuites(List<CipherSuite> cipherSuites) {
        this.cipherSuites = cipherSuites;
    }

    public void setCipherSuites(CipherSuite ... cipherSuites) {
        this.cipherSuites = new ArrayList<CipherSuite>(Arrays.asList(cipherSuites));
    }

    @Override
    public void applyDelegate(Config config) {
        if (this.cipherSuites != null) {
            config.setDefaultClientSupportedCipherSuites(this.cipherSuites);
            config.setDefaultServerSupportedCipherSuites(this.cipherSuites);
            if (this.cipherSuites.size() > 0) {
                config.setDefaultSelectedCipherSuite(this.cipherSuites.get(0));
            }
        }
    }
}

